/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.format.ResultSetFormatterWrapper;

public class SQLFormatterWrapper
extends ResultSetFormatterWrapper {
    private String m_connName;
    private String m_sql;

    public SQLFormatterWrapper(String conn, String sql) {
        this(conn, sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SQLFormatterWrapper(String connName, String sql, Map<String, ?> bindMap) {
        this.m_connName = connName;
        this.m_sql = sql;
        Connection conn = this.getConnection();
        if (LockManager.lock(conn)) {
            try {
                ResultSet rs = bindMap == null ? DBUtil.getInstance(conn).executeQuery(sql, (List)null) : DBUtil.getInstance(conn).executeQuery(sql, bindMap);
                if (rs == null) return;
                this.setResultSet(rs);
                return;
            }
            finally {
                LockManager.unlock(conn);
            }
        } else {
            System.out.println("Unable to get lock for connection");
        }
    }

    @Override
    public Connection getConnection() {
        Connection conn = null;
        try {
            conn = ConnectionResolver.getConnection(this.m_connName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conn;
    }

    @Override
    public String getSQL() {
        return this.m_sql;
    }
}

