/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Clob;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class FixedFormatter
extends ResultsFormatter {
    public static final String TYPE = "fixed";
    public static final String EXT = "txt";
    public static final String KEY_HEADER = "EXPORT_FIX_HEADER";
    public static final String KEY_REC_TERM = "EXPORT_FIX_REC_TERM";
    private static final int FIXED_PAD_LENGTH = 30;
    private boolean _isHeader;

    public FixedFormatter() {
        super(TYPE, Messages.getString("FixedFormatter.1"), EXT);
    }

    @Override
    public void end() throws IOException {
    }

    @Override
    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        String colm;
        Object val;
        if (col instanceof Clob) {
            Integer size = null;
            if (this.getScriptContext() != null) {
                size = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
            }
            val = size != null ? DataTypesUtil.stringValue(col, this.getConnection(), size) : DataTypesUtil.stringValue(col, this.getConnection());
        } else {
            val = this.getValue(col);
        }
        if (col == null && val != null) {
            colm = val.toString();
        } else {
            String cleanString = val != null ? this.cleanString(val.toString()) : "";
            colm = "\"" + cleanString + "\"";
        }
        this.write(this.rightpad(colm, 30));
    }

    @Override
    public void setTableName(String name) {
    }

    @Override
    public void start() throws IOException {
        int pad = 30;
        int columnCount = this.getColumnCount();
        if (this.isHeader()) {
            for (int i = 0; i < columnCount; ++i) {
                String cleanString = this.cleanString(this.getColumnName(i));
                int cleanStringLength = cleanString.length();
                String name = "\"" + cleanString + "\"";
                this.write(this.rightpad(name, pad));
            }
            this.write(this.getLineTerminator());
        }
    }

    private String rightpad(String name, int pad) {
        String returnStr = name != null ? name.trim() : name;
        String formatStr = "%1$-" + pad + "s";
        returnStr = name != null ? String.format(formatStr, name) : String.format(formatStr, "\"\"");
        return returnStr;
    }

    @Override
    public void startRow() throws IOException {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isHeaderOptionSupported() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public void isHeader(boolean isHeader) {
        this._isHeader = isHeader;
    }

    @Override
    public boolean isHeader() {
        return this._isHeader;
    }

    @Override
    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }
}

