/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import oracle.dbtools.raptor.extendedtype.AbstractExtendedType;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.CLOB;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;

public class XMLExtendeType
extends AbstractExtendedType {
    protected XMLExtendeType(int sqlType, OPAQUE origValue) {
        super(sqlType, origValue);
    }

    public XMLExtendeType(OPAQUE data) {
        this(2009, data);
    }

    public void setValue(OPAQUE opaque) {
        this.setOrigValue(opaque);
    }

    public OPAQUE getObjectValue() {
        return this.getOrigValue();
    }

    @Override
    public OPAQUE getOrigValue() {
        return (OPAQUE)super.getOrigValue();
    }

    public String toString() {
        try {
            URL _selectedURL = this.getLoadFromURL();
            if (_selectedURL != null) {
                return "[" + _selectedURL != null ? _selectedURL.toString() : "]";
            }
            if (this.getOrigValue() != null) {
                return DataTypesUtil.stringValue(this.getOrigValue(), (Connection)this.getOrigValue().getOracleConnection());
            }
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return "";
    }

    @Override
    public void duplicate() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(Boolean orig) throws Exception {
        if (orig == null && this.getLoadFromURL() != null || orig != null && !orig.booleanValue()) {
            return super.getBinaryStream(orig);
        }
        if (this.getOrigValue() != null) {
            XMLType xmlType = XMLType.createXML((OPAQUE)this.getOrigValue());
            CLOB clob = xmlType.getClobVal();
            try {
                return DataTypesUtil.getXMLAsBytes(clob.getCharacterStream());
            }
            catch (Exception e) {
                return clob.getAsciiStream();
            }
        }
        return null;
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return null;
    }

    @Override
    public Reader getReader(Boolean orig, String defaultCharset) throws Exception {
        URL loadFrom = this.getLoadFromURL();
        if (orig == null && loadFrom != null || orig != null && !orig.booleanValue()) {
            FileInputStream in;
            if (loadFrom != null && (in = new FileInputStream(new File(loadFrom.toURI()))) != null) {
                if (defaultCharset == null) {
                    defaultCharset = "UTF-8";
                }
                return DataTypesUtil.getXMLAsReader(in, defaultCharset);
            }
        } else {
            CLOB clob;
            OPAQUE opq = this.getOrigValue();
            Object xmlType = opq instanceof XMLType ? (XMLType)opq : (opq != null ? XMLType.createXML((OPAQUE)opq) : null);
            if (xmlType != null && (clob = xmlType.getClobVal()) != null) {
                return new TemporaryClobReader(clob);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDb(Connection conn, String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity, List<String> log) throws SQLException, IOException {
        try (Statement prep = null;){
            XMLType dbXmlType = null;
            URL _selectedURL = this.getLoadFromURL();
            if (_selectedURL != null) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(new File(_selectedURL.toURI()));
                }
                catch (URISyntaxException e1) {
                    Logger.getLogger(XMLExtendeType.class.getName()).log(Level.SEVERE, e1.getMessage());
                }
                CLOB clob = DataTypesUtil.getTemporaryCLOB(conn);
                try {
                    Writer clobWriter = clob.setCharacterStream(1L);
                    try {
                        DataTypesUtil.getXMLAsCharacters(is, clobWriter);
                        clobWriter.flush();
                        dbXmlType = XMLType.createXML((Connection)conn, (CLOB)clob);
                    }
                    catch (XMLStreamException xe) {
                        try {
                            dbXmlType = XMLType.createXML((Connection)conn, (InputStream)new FileInputStream(new File(_selectedURL.toURI())));
                        }
                        catch (URISyntaxException e) {
                            Logger.getLogger(XMLExtendeType.class.getName()).log(Level.SEVERE, e.getMessage());
                        }
                    }
                    finally {
                        try {
                            clobWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        clob.close();
                    }
                    catch (SQLException sQLException) {}
                }
            } else if (this.getOrigValue() != null) {
                dbXmlType = XMLType.createXML((OPAQUE)this.getOrigValue());
            }
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("UPDATE ").append(tableName).append(" SET ").append(columnName).append("=? WHERE ROWID=:sqldevrowid");
            if (dataIntegrity && rowScn != null) {
                sqlBuff.append(" AND ORA_ROWSCN=:sqldevrowscn");
            }
            log.add(sqlBuff.toString());
            prep = conn.prepareStatement(sqlBuff.toString());
            prep.setObject(1, dbXmlType);
            prep.setString(2, rowId);
            if (dataIntegrity && rowScn != null) {
                prep.setString(3, rowScn);
            }
            int updates = prep.executeUpdate();
            _selectedURL = null;
            boolean bl = updates == 1;
            return bl;
        }
    }

    @Override
    public boolean saveToDisk(String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity) throws SQLException, IOException {
        return false;
    }

    @Override
    public void setToDiskStream(OutputStream out) {
    }

    protected static class TemporaryClobReader
    extends BufferedReader {
        private CLOB clob;

        public TemporaryClobReader(CLOB clob) throws SQLException {
            super(clob.getCharacterStream());
            this.clob = clob;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                if (this.clob != null && this.clob.isTemporary()) {
                    this.clob.freeTemporary();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

