/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.Messages;

public abstract class AbstractExtendedType
implements ExtendedType<Object> {
    protected final int sqlType;
    private Object origValue;
    private boolean isNULL;
    private URL loadFrom;
    private RaptorTaskDescriptor toDiskTaskDescriptor;

    protected AbstractExtendedType(int sqlType, Object origValue) {
        this(sqlType, origValue, origValue == null);
    }

    protected AbstractExtendedType(int sqlType, Object origValue, boolean isNULL) {
        this.sqlType = sqlType;
        this.origValue = origValue;
        this.isNULL = isNULL;
        this.loadFrom = null;
        this.toDiskTaskDescriptor = null;
    }

    protected void setOrigValue(Object origValue, boolean isNULL) {
        this.origValue = origValue;
        this.isNULL = isNULL;
        this.loadFrom = null;
        this.toDiskTaskDescriptor = null;
    }

    protected void setOrigValue(Object origValue) {
        this.setOrigValue(origValue, origValue == null);
    }

    @Override
    public Object getOrigValue() {
        return this.origValue;
    }

    @Override
    public void setNULL(boolean isNULL) {
        this.isNULL = isNULL;
        if (this.isNULL) {
            this.loadFrom = null;
        }
    }

    @Override
    public boolean isSetNULL() {
        return this.isNULL;
    }

    @Override
    public final URL getLoadFromURL() {
        return this.loadFrom;
    }

    @Override
    public void setLoadFromURL(URL loadFrom) {
        this.loadFrom = loadFrom;
        if (loadFrom != null) {
            this.setNULL(false);
        }
    }

    @Override
    public final Reader getReader(String defaultCharset) throws Exception {
        return this.getReader(true, defaultCharset);
    }

    @Override
    public final Reader getReader(Boolean orig) throws Exception {
        return this.getReader(orig, null);
    }

    @Override
    public final Reader getReader() throws Exception {
        return this.getReader(true, null);
    }

    @Override
    public Reader getReader(Boolean orig, String defaultCharset) throws Exception {
        InputStream in = null;
        if (orig == null && this.loadFrom != null || orig != null && !orig.booleanValue()) {
            if (this.loadFrom != null) {
                // empty if block
            }
        } else {
            in = this.getBinaryStream();
        }
        if (in != null) {
            if (defaultCharset != null) {
                return new InputStreamReader(in, defaultCharset);
            }
            return new InputStreamReader(in);
        }
        return null;
    }

    @Override
    public final InputStream getBinaryStream() throws SQLException {
        try {
            return this.getBinaryStream(true);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
    }

    @Override
    public InputStream getBinaryStream(Boolean orig) throws Exception {
        FileInputStream in = null;
        if ((orig == null && this.loadFrom != null || orig != null && !orig.booleanValue()) && this.loadFrom != null) {
            in = new FileInputStream(new File(this.loadFrom.toURI()));
        }
        return in;
    }

    @Override
    public void setToDiskTaskDescriptor(RaptorTaskDescriptor taskDescriptor) {
        this.toDiskTaskDescriptor = taskDescriptor;
    }

    @Override
    public RaptorTaskDescriptor getToDiskTaskDescriptor() {
        return this.toDiskTaskDescriptor;
    }

    @Override
    public boolean isToDiskInDeterministic() {
        return true;
    }

    protected void setToDiskTaskProgress(RaptorTaskDescriptor taskDescriptor, int percentage) {
        taskDescriptor.setProgress(percentage);
        taskDescriptor.setMessage(MessageFormat.format(Messages.getString("GenericBlobType.1"), percentage));
    }
}

