/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.util;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class Timestamps {
    private static final DecimalFormat FRACTIONAL_FORMAT = new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final DecimalFormat PADDED_FRACTIONAL_FORMAT = new DecimalFormat("0.000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final SimpleDateFormat RFC_3339_MUNGED = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final Pattern TIMESTAMP = Pattern.compile("^\\d{4}-[01]\\d-[0123]\\dT[012]\\d:[0-5]\\d:[0-5]\\d(.\\d+)?(Z|([-+][012]\\d:[0-5]\\d))$");
    private static final MessageFormat RFC_3339_TEXT = new MessageFormat("{0,number,0000}-{1,number,00}-{2,number,00}T{3,number,00}:{4,number,00}:{5,number,00}");
    private static final TimeZone UTC = TimeZone.getTimeZone("Z");

    public static boolean isTimestamp(CharSequence text) {
        return TIMESTAMP.matcher(text).matches();
    }

    public static String toString(Timestamp timestamp) {
        return Timestamps.toString(timestamp.getTime());
    }

    public static String toString(long date) {
        return Timestamps.toString(FRACTIONAL_FORMAT, date);
    }

    public static String toPaddedString(long date) {
        return Timestamps.toString(PADDED_FRACTIONAL_FORMAT, date);
    }

    private static String toString(DecimalFormat fractionFormat, long date) {
        Calendar c = Calendar.getInstance(UTC);
        c.setTimeInMillis(date);
        StringBuilder b = new StringBuilder();
        b.append(RFC_3339_TEXT.format(new Object[]{c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13)}));
        int millis = c.get(14);
        if (PADDED_FRACTIONAL_FORMAT == fractionFormat || millis > 0) {
            DecimalFormat fmt = fractionFormat;
            b.append(fmt.format((double)millis / 1000.0).substring(1));
        }
        b.append('Z');
        return b.toString();
    }

    public static long valueOf(String date) {
        if (Timestamps.isTimestamp(date)) {
            long millis = 0L;
            StringBuilder text = new StringBuilder(date);
            Date d = null;
            if (date.endsWith("Z")) {
                text.replace(text.length() - 1, text.length(), "-0000");
            } else {
                text.deleteCharAt(text.length() - 3);
            }
            int fraction = date.indexOf(46);
            if (fraction > 0) {
                int end = text.length() - 5;
                millis = (long)(1000.0 * Double.parseDouble("0" + text.substring(fraction, end)));
                text.delete(fraction, end);
            }
            String munged = text.toString();
            try {
                d = RFC_3339_MUNGED.parse(munged);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return d.getTime() + millis;
        }
        throw new IllegalArgumentException("Not a correctly formatted timestamp: " + date);
    }
}

