/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatumAtName;

public class CallableBindingSplit<P extends DataBinding>
extends CallableBindingDatumAtName<P>
implements CallableBindingSplitMode<P> {
    protected CallableBindingDatumAtName inDatum;

    public CallableBindingSplit(BindContext context, P param) {
        this(context, param, param.getDataType());
    }

    public CallableBindingSplit(BindContext context, P param, DataType dataType) {
        this(context, param, dataType, param.getMode());
    }

    public CallableBindingSplit(BindContext context, P param, BindingMode modeOverride) {
        this(context, param, param.getDataType(), modeOverride);
    }

    public CallableBindingSplit(BindContext context, P param, DataType dataType, BindingMode modeOverride) {
        super(context, param, dataType, modeOverride.getEffectiveMode() == BindingMode.IN_OUT ? BindingMode.OUT : modeOverride);
        if (param.getMode().getEffectiveMode() == BindingMode.IN_OUT) {
            DataVariable inVariable = dataType.getDataTypeFactory().getDataVariable(param.getName(), dataType, BindingMode.IN);
            this.inDatum = (CallableBindingDatumAtName)dataType.getBind(context, inVariable);
        } else {
            this.inDatum = null;
        }
    }

    @Override
    public void setByNameBindToken(String bindToken) {
        if (this.inDatum != null) {
            this.inDatum.setByNameBindToken(bindToken);
        } else {
            super.setByNameBindToken(bindToken);
        }
    }

    @Override
    public String getByNameBindToken() {
        if (this.inDatum != null) {
            return this.inDatum.getByNameBindToken();
        }
        return super.getByNameBindToken();
    }

    @Override
    protected void customBind(DataValue value) throws SQLException {
        if (this.inDatum != null) {
            this.inDatum.bind((CallableStatement)this.getCallableStatement(), value);
        }
        super.customBind(value);
    }

    @Override
    public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder builder) {
        String name = this.getParameter().getName();
        DataType dataType = this.getDataType();
        BindingMode mode = this.param.getMode();
        if (this.param instanceof DataParameter) {
            switch (mode) {
                case IN: {
                    super.customBuilder(builder);
                    break;
                }
                case IN_OUT: {
                    this.inDatum.getBuilder(builder);
                }
                case OUT: {
                    builder.addComponent(PLSQLBlockComponent.DataDecls, name + " " + dataType.getConstrainedDataTypeString() + ";");
                    builder.addComponent(PLSQLBlockComponent.ParamBinding, name + "=>" + name);
                    break;
                }
                default: {
                    super.customBuilder(builder);
                    break;
                }
            }
        } else {
            switch (mode) {
                case IN: {
                    super.customBuilder(builder);
                    break;
                }
                case IN_OUT: {
                    this.inDatum.getBuilder(builder);
                }
                case OUT: {
                    super.customBuilder(builder);
                    break;
                }
                default: {
                    super.customBuilder(builder);
                }
            }
        }
        return builder;
    }

    @Override
    public void customReportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        super.customReportBinding(buffer, nullToken, value);
        if (this.inDatum != null) {
            this.inDatum.reportBinding(buffer, nullToken, value);
        }
    }

    @Override
    protected CallableBindingSplitMode<P> customSplitModeBinding() {
        return this;
    }
}

