/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.CallableBindingImpl;
import oracle.dbtools.raptor.datatypes.objects.PLSQLRecord;

public class CallableBindingRECORD<P extends DataBinding>
extends CallableBindingImpl<P>
implements CallableBindingSplitMode<P> {
    protected BindContext context;
    private CallableStatement stmt = null;
    private List<CallableBindingSplitMode<DataVariable>> subBindings;

    public CallableBindingRECORD(BindContext context, P param) {
        super(param);
        this.context = context;
    }

    @Override
    public void setByNameBindToken(String bindToken) {
    }

    @Override
    public String getByNameBindToken() {
        return null;
    }

    @Override
    public void setByPositionBindToken(String bindToken) {
    }

    @Override
    public String getByPositionBindToken() {
        return null;
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode mode) {
        return BindingStyle.CUSTOM;
    }

    @Override
    public String getBindToken(BindingMode mode) {
        return null;
    }

    @Override
    public CallableStatement getCallableStatement() {
        return this.stmt;
    }

    @Override
    protected void setCallableStatement(CallableStatement stmt) {
        this.stmt = stmt;
    }

    @Override
    protected void customBind(DataValue value) throws SQLException {
        List<DataValue> subComponents = value.getComponents();
        Iterator<DataValue> subComponentsIter = subComponents.iterator();
        for (CallableBindingSplitMode<DataVariable> binding : this.subBindings) {
            binding.bind(this.stmt, subComponentsIter.next());
        }
    }

    @Override
    protected void customBindIN(DataValue value) throws SQLException {
    }

    @Override
    protected void customBind() throws SQLException {
        for (CallableBindingSplitMode<DataVariable> binding : this.subBindings) {
            binding.bind(this.stmt);
        }
    }

    @Override
    protected void customBindOUT() throws SQLException {
    }

    @Override
    public void customReportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        List<DataValue> subComponents = value.getComponents();
        Iterator<DataValue> subComponentsIter = subComponents.iterator();
        for (CallableBindingSplitMode<DataVariable> binding : this.subBindings) {
            binding.reportBinding(buffer, nullToken, subComponentsIter.next());
        }
    }

    @Override
    public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder builder) {
        this.subBindings = new LinkedList<CallableBindingSplitMode<DataVariable>>();
        String name = this.getParameter().getName() == null ? "\"<RETURN>\"" : this.getParameter().getName();
        DataType datatype = this.param.getDataType();
        Collection<NamedValue<DataType>> components = datatype.getTypeComponents();
        for (NamedValue namedValue : components) {
            String componentName = name + "." + namedValue.getName();
            DataType componentDataType = (DataType)namedValue.getValue();
            DataVariable field = datatype.getDataTypeFactory().getDataVariable(componentName, componentDataType, this.mode);
            CallableBinding<DataVariable> fieldbinding = componentDataType.getBind(this.context, field);
            CallableBindingSplitMode<DataVariable> splitBinding = fieldbinding.getSplitModeBinding();
            PLSQLBoundBlockBuilder fieldBuilder = splitBinding.getBuilder();
            builder.addBuilder(fieldBuilder);
            this.subBindings.add(splitBinding);
        }
        if (this.param instanceof DataParameter) {
            switch (this.mode) {
                case RETURN: {
                    builder.addComponent(PLSQLBlockComponent.PreCallWrapper, name + " := ");
                    break;
                }
                default: {
                    builder.addComponent(PLSQLBlockComponent.ParamBinding, name + "=>" + name);
                }
            }
            builder.addComponent(PLSQLBlockComponent.DataDecls, name + " " + datatype.getConstrainedDataTypeString() + ";");
        }
        return builder;
    }

    @Override
    protected DataValue customOutput() throws SQLException {
        if (this.outputValue == null) {
            PLSQLRecord record = new PLSQLRecord(this.getDataType());
            for (CallableBindingSplitMode<DataVariable> binding : this.subBindings) {
                DataValue dataValue = binding.getOutput();
                record.add(dataValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT));
            }
            this.outputValue = this.dataType.getDataValue(record);
        }
        return this.outputValue;
    }

    @Override
    protected CallableBindingSplitMode<P> customSplitModeBinding() {
        return this;
    }
}

