/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongVarchar;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatum;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingLONGVARCHAR<P extends DataBinding>
extends CallableBindingDatum<P> {
    public CallableBindingLONGVARCHAR(BindContext context, P param) {
        super(context, param);
    }

    @Override
    protected void customBindIN(DataValue value, int pos) throws SQLException {
        this.inputValue = value;
        LongVarchar longVarchar = (LongVarchar)value.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longVarchar != null && !longVarchar.isNull()) {
            try {
                this.getCallableStatement().setCharacterStream(pos, longVarchar.getReader(), (int)longVarchar.getLength());
            }
            catch (IOException e) {
                throw new DataTypeIOException(e);
            }
        } else {
            this.getCallableStatement().setNull(pos, this.dataType.getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected DataValue customOutputByPosition(OracleCallableStatement stmt, int pos) throws SQLException {
        Reader reader = stmt.getCharacterStream(pos);
        return this.dataType.getDataValue(reader);
    }
}

