/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatumAtName;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingLONGBINARY<P extends DataBinding>
extends CallableBindingDatumAtName<P> {
    public CallableBindingLONGBINARY(BindContext context, P param) {
        super(context, param);
    }

    @Override
    protected void customBindIN(DataValue value, int pos) throws SQLException {
        this.inputValue = value;
        LongBinary longBinary = (LongBinary)value.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longBinary != null && !longBinary.isNull()) {
            try {
                this.getCallableStatement().setBinaryStream(pos, longBinary.getInputStream(), (int)longBinary.getLength());
            }
            catch (IOException e) {
                throw new DataTypeIOException(e);
            }
        } else {
            this.getCallableStatement().setNull(pos, this.dataType.getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected void customBindIN(DataValue value, String name) throws SQLException {
        this.inputValue = value;
        LongBinary longBinary = (LongBinary)value.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longBinary != null && !longBinary.isNull()) {
            try {
                this.getCallableStatement().setBinaryStreamAtName(name, longBinary.getInputStream(), (int)longBinary.getLength());
            }
            catch (IOException e) {
                throw new DataTypeIOException(e);
            }
        } else {
            this.getCallableStatement().setNull(name, this.dataType.getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected DataValue customOutputByPosition(OracleCallableStatement stmt, int pos) throws SQLException {
        InputStream istream = stmt.getBinaryStream(pos);
        return this.dataType.getDataValue(istream);
    }
}

