/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.SQLException;
import java.util.Collection;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatum;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingIndexTABLE<P extends DataBinding>
extends CallableBindingDatum<P> {
    public CallableBindingIndexTABLE(BindContext context, P param) {
        super(context, param);
    }

    @Override
    protected void customBindIN(DataValue value, int pos) throws SQLException {
        this.inputValue = value;
        Object[] typedValue = (Object[])value.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.JDBC);
        Collection<NamedValue<DataType>> typeComponents = this.dataType.getTypeComponents();
        DataType typeComponent = (DataType)((NamedValue)typeComponents.iterator().next()).getValue();
        int elemSqlType = typeComponent.getSqlDataType(ValueType.JDBC);
        Integer elemDataLength = typeComponent.getTypeMetadata().get_data_length();
        int elemMaxLen = elemDataLength != null ? elemDataLength : 0;
        this.getCallableStatement().setPlsqlIndexTable(pos, (Object)typedValue, typedValue.length, typedValue.length, elemSqlType, elemMaxLen);
    }

    @Override
    protected void customBindOUT(String bindToken) throws SQLException {
        Collection<NamedValue<DataType>> typeComponents = this.dataType.getTypeComponents();
        DataType typeComponent = (DataType)((NamedValue)typeComponents.iterator().next()).getValue();
        int elemSqlType = typeComponent.getSqlDataType(ValueType.JDBC);
        Integer elemDataLength = typeComponent.getTypeMetadata().get_data_length();
        int elemMaxLen = elemDataLength != null ? elemDataLength : 0;
        this.getCallableStatement().registerIndexTableOutParameter(this.context.remapPosition(bindToken), 1000, elemSqlType, elemMaxLen);
    }

    @Override
    protected DataValue customOutputByPosition(OracleCallableStatement stmt, int pos) throws SQLException {
        Object result = stmt.getPlsqlIndexTable(pos);
        return this.dataType.getDataValue(result);
    }
}

