/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypePlatformException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.CallableBindingImpl;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingSplit;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.Datum;

public class CallableBindingDatumAtName<P extends DataBinding>
extends CallableBindingImpl<P> {
    protected final BindContext context;
    private String byPositionBindToken;
    private String byNameBindToken;
    private OracleCallableStatement stmt;

    public CallableBindingDatumAtName(BindContext context, P param) {
        this(context, param, param.getDataType());
    }

    public CallableBindingDatumAtName(BindContext context, P param, DataType dataType) {
        this(context, param, dataType, param.getMode());
    }

    public CallableBindingDatumAtName(BindContext context, P param, BindingMode modeOverride) {
        this(context, param, param.getDataType(), modeOverride);
    }

    protected CallableBindingDatumAtName(BindContext context, P param, DataType dataType, BindingMode modeOverride) {
        super(param, dataType, modeOverride);
        this.context = context;
        this.stmt = null;
        this.byPositionBindToken = null;
        this.byNameBindToken = null;
    }

    @Override
    public void setByNameBindToken(String bindToken) {
        this.byNameBindToken = bindToken;
    }

    @Override
    public String getByNameBindToken() {
        return this.byNameBindToken;
    }

    @Override
    public void setByPositionBindToken(String bindToken) {
        this.byPositionBindToken = bindToken;
    }

    @Override
    public String getByPositionBindToken() {
        if (this.byPositionBindToken == null) {
            this.byPositionBindToken = this.context.nextBindToken();
        }
        return this.byPositionBindToken;
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode mode) {
        if (mode.getEffectiveMode() == BindingMode.IN && this.getByNameBindToken() != null) {
            return BindingStyle.NAME;
        }
        return BindingStyle.POSITION;
    }

    @Override
    public String getBindToken(BindingMode mode) {
        if (this.getBindingStyle(mode) == BindingStyle.NAME) {
            return this.getByNameBindToken();
        }
        return this.getByPositionBindToken();
    }

    public OracleCallableStatement getCallableStatement() {
        return this.stmt;
    }

    @Override
    protected void setCallableStatement(CallableStatement stmt) {
        try {
            this.stmt = (OracleCallableStatement)stmt;
        }
        catch (ClassCastException e) {
            throw new DataTypePlatformException(OracleCallableStatement.class);
        }
    }

    @Override
    protected DataValue customOutput() throws SQLException {
        if (this.outputValue == null) {
            this.outputValue = this.customOutputByPosition(this.getCallableStatement(), this.context.remapPosition(this.getByPositionBindToken()));
        }
        return this.outputValue;
    }

    @Override
    protected PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder builder) {
        String name = this.param.getName();
        if (this.param instanceof DataParameter) {
            switch (this.mode) {
                case RETURN: {
                    builder.addComponent(PLSQLBlockComponent.PreCallWrapper, "%s := ", this.getBindToken(this.mode));
                    break;
                }
                default: {
                    builder.addComponent(PLSQLBlockComponent.ParamBinding, name + "=>%s", this.getBindToken(this.mode));
                    break;
                }
            }
        } else {
            switch (this.mode) {
                case IN: {
                    builder.addComponent(PLSQLBlockComponent.PreCallBlocks, name + " := %s;", this.getBindToken(this.mode));
                    break;
                }
                case OUT: {
                    builder.addComponent(PLSQLBlockComponent.PostCallBlocks, "%s := " + name + ";", this.getBindToken(this.mode));
                }
            }
        }
        return builder;
    }

    @Override
    protected void customBindIN(DataValue value) throws SQLException {
        if (this.getBindingStyle(this.mode) == BindingStyle.NAME) {
            this.customBindIN(value, this.getByNameBindToken());
        } else {
            this.customBindIN(value, this.context.remapPosition(this.getByPositionBindToken()));
        }
    }

    protected void customBindIN(DataValue value, int pos) throws SQLException {
        Object typedValue;
        this.inputValue = value;
        Object object = typedValue = value != null ? value.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DATUM) : null;
        if (typedValue != null) {
            this.stmt.setObject(pos, typedValue, this.dataType.getSqlDataType(ValueType.DATUM));
        } else {
            this.stmt.setNull(pos, this.dataType.getSqlDataType(ValueType.DATUM));
        }
    }

    protected void customBindIN(DataValue value, String name) throws SQLException {
        Object typedValue;
        this.inputValue = value;
        Object object = typedValue = value != null ? value.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DATUM) : null;
        if (typedValue != null) {
            this.stmt.setObjectAtName(name, typedValue, this.dataType.getSqlDataType(ValueType.DATUM));
        } else {
            this.stmt.setNull(name, this.dataType.getSqlDataType(ValueType.DATUM));
        }
    }

    @Override
    protected void customBindOUT() throws SQLException {
        this.customBindOUT(this.getByPositionBindToken());
    }

    protected void customBindOUT(String bindToken) throws SQLException {
        String userTypeName = this.dataType.getUserDataTypeString();
        if (userTypeName != null) {
            this.stmt.registerOutParameter(this.context.remapPosition(bindToken), this.dataType.getSqlDataType(ValueType.DATUM), userTypeName);
        } else {
            this.stmt.registerOutParameter(this.context.remapPosition(bindToken), this.dataType.getSqlDataType(ValueType.DATUM));
        }
    }

    @Override
    protected void customReportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        this.reportBinding(buffer, nullToken, this.getBindToken(this.mode), value.getDataType(), this.mode.getEffectiveMode(), value.getStringValue().toString());
    }

    @Override
    protected CallableBindingSplitMode<P> customSplitModeBinding() {
        CallableBindingSplit<DataBinding> binding = new CallableBindingSplit<DataBinding>(this.context, this.param, this.dataType, this.mode);
        binding.setByNameBindToken(this.getByNameBindToken());
        binding.setByPositionBindToken(this.getByPositionBindToken());
        return binding;
    }

    protected DataValue customOutputByPosition(OracleCallableStatement stmt, int pos) throws SQLException {
        Datum result;
        block2: {
            result = null;
            try {
                result = stmt.getOracleObject(pos);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 17021) break block2;
                throw ex;
            }
        }
        return this.dataType.getDataValue(result);
    }
}

