/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.CallableBindingImpl;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingSplit;
import oracle.dbtools.raptor.datatypes.values.DataValueMapped;

public class CallableBindingBOOLEAN<P extends DataBinding>
extends CallableBindingImpl<P>
implements CallableBindingSplitMode<P> {
    protected final BindContext context;
    private final CallableBindingSplit<P> splitBinding;
    private CallableStatement stmt = null;
    private static final String BOOL2INT = "FUNCTION bool2int(b BOOLEAN)RETURN NUMBER AS BEGIN IF (b IS NULL)THEN RETURN NULL;ELSE CASE b WHEN true THEN RETURN 1;ELSE RETURN 0;END CASE;END IF;END bool2int;";
    private static final String INT2BOOL = "FUNCTION int2bool(i NUMBER)RETURN BOOLEAN AS BEGIN IF (i IS NULL)THEN RETURN NULL;ELSE RETURN (i <> 0);END IF;END int2bool;";

    public CallableBindingBOOLEAN(BindContext context, P param, DataType mappedType) {
        super(param);
        this.context = context;
        this.splitBinding = new CallableBindingSplit<P>(context, (DataBinding)param, mappedType){

            @Override
            public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder builder) {
                boolean add_bool2int = false;
                boolean add_int2bool = false;
                String name = this.getParameter().getName();
                DataType datatype = this.param.getDataType();
                BindingMode mode = this.param.getMode();
                if (this.param instanceof DataParameter) {
                    switch (mode) {
                        case RETURN: {
                            builder.addComponent(PLSQLBlockComponent.PreCallWrapper, "%s := bool2int(", this.getBindToken(mode));
                            builder.addComponent(PLSQLBlockComponent.PostCallWrapper, ")");
                            add_bool2int = true;
                            break;
                        }
                        case IN: {
                            builder.addComponent(PLSQLBlockComponent.ParamBinding, name + "=>int2bool(%s)", this.getBindToken(mode));
                            add_int2bool = true;
                            break;
                        }
                        case IN_OUT: {
                            builder.addComponent(PLSQLBlockComponent.PreCallBlocks, name + " := int2bool(%s);", this.inDatum.getBindToken(this.inDatum.getMode()));
                            add_int2bool = true;
                        }
                        case OUT: {
                            builder.addComponent(PLSQLBlockComponent.DataDecls, name + " " + datatype.getConstrainedDataTypeString() + ";");
                            builder.addComponent(PLSQLBlockComponent.ParamBinding, name + "=>" + name);
                            builder.addComponent(PLSQLBlockComponent.PostCallBlocks, "%s := bool2int(" + name + ");", this.getBindToken(mode));
                            add_bool2int = true;
                        }
                    }
                } else {
                    switch (mode) {
                        case IN: {
                            builder.addComponent(PLSQLBlockComponent.PreCallBlocks, name + " := int2bool(%s);", this.getBindToken(mode));
                            add_int2bool = true;
                            break;
                        }
                        case IN_OUT: {
                            builder.addComponent(PLSQLBlockComponent.PreCallBlocks, name + " := int2bool(%s);", this.inDatum.getBindToken(this.inDatum.getMode()));
                            add_int2bool = true;
                        }
                        case OUT: {
                            builder.addComponent(PLSQLBlockComponent.PostCallBlocks, "%s := bool2int(" + name + ");", this.getBindToken(mode));
                            add_bool2int = true;
                        }
                    }
                }
                if (add_bool2int) {
                    builder.addComponent(PLSQLBlockComponent.StdProcDecls, CallableBindingBOOLEAN.BOOL2INT);
                }
                if (add_int2bool) {
                    builder.addComponent(PLSQLBlockComponent.StdProcDecls, CallableBindingBOOLEAN.INT2BOOL);
                }
                return builder;
            }
        };
    }

    @Override
    public void setByNameBindToken(String bindToken) {
        this.splitBinding.setByNameBindToken(bindToken);
    }

    @Override
    public String getByNameBindToken() {
        return this.splitBinding.getByNameBindToken();
    }

    @Override
    public void setByPositionBindToken(String bindToken) {
        this.splitBinding.setByPositionBindToken(bindToken);
    }

    @Override
    public String getByPositionBindToken() {
        return this.splitBinding.getByPositionBindToken();
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode mode) {
        return this.splitBinding.getBindingStyle(mode);
    }

    @Override
    public String getBindToken(BindingMode mode) {
        return this.splitBinding.getBindToken(mode);
    }

    @Override
    protected void customBind(DataValue value) throws SQLException {
        this.inputValue = value;
        DataValue bindingValue = value instanceof DataValueMapped ? ((DataValueMapped)value).getBindingDataValue() : value;
        this.splitBinding.bind(this.stmt, bindingValue);
    }

    @Override
    public CallableStatement getCallableStatement() {
        return this.stmt;
    }

    @Override
    protected void setCallableStatement(CallableStatement stmt) {
        this.stmt = stmt;
    }

    @Override
    protected void customBindIN(DataValue value) throws SQLException {
    }

    @Override
    public void customReportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        DataValue bindingValue = value.getBindingDataValue();
        this.splitBinding.customReportBinding(buffer, nullToken, bindingValue);
    }

    @Override
    public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder builder) {
        return this.splitBinding.customBuilder(builder);
    }

    @Override
    protected void customBind() throws SQLException {
        this.splitBinding.bind(this.stmt);
    }

    @Override
    protected void customBindOUT() throws SQLException {
    }

    @Override
    protected DataValue customOutput() throws SQLException {
        if (this.outputValue == null) {
            DataValue bindingValue = this.splitBinding.getOutput();
            this.outputValue = this.dataType.getDataValue(bindingValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT));
        }
        return this.outputValue;
    }

    @Override
    protected CallableBindingSplitMode<P> customSplitModeBinding() {
        return this;
    }
}

