/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.DatumWithConnection;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingUDT;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.CompositeValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.datatypes.xml.XMLUtil;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.JDBCProxyUtil;
import oracle.jdbc.internal.OracleStruct;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection {
    protected STRUCT(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, STRUCT.expandTypeMetadata(context, typeMetadata));
    }

    protected static TypeMetadata expandTypeMetadata(DataTypeContext context, TypeMetadata typeMetadata) {
        TypeMetadata newTypeMetadata = typeMetadata;
        try {
            List<NamedValue<TypeMetadata>> attributes = STRUCT.loadAttributes(context, typeMetadata.get_type_owner(), typeMetadata.get_type_name());
            HashMap<TypeMetadata.Attribute, Object> attributeMap = new HashMap<TypeMetadata.Attribute, Object>();
            attributeMap.put(TypeMetadata.Attribute.TYPE_COMPONENTS, attributes);
            context.getDataTypeFactory();
            newTypeMetadata = DataTypeFactory.getTypeMetadata(typeMetadata, attributeMap);
        }
        catch (SQLException e) {
            throw new DataTypeSQLException(e);
        }
        return newTypeMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<NamedValue<TypeMetadata>> loadAttributes(DataTypeContext context, String owner, String type) throws SQLException {
        DataTypeConnectionProvider provider = context.getDataTypeConnectionProvider();
        LinkedList<NamedValue<TypeMetadata>> typeComponents = new LinkedList<NamedValue<TypeMetadata>>();
        ResultSet rset = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        Object conn = provider.lockDataTypeConnection();
        if (conn != null) {
            block6: {
                try {
                    DBUtil dbUtil = DBUtil.getInstance(conn);
                    dbUtil.setRaiseError(false);
                    String query = XMLUtil.getQuery(conn, "loadAttributes");
                    binds.put("OWNER", owner);
                    binds.put("TYPE", type);
                    rset = dbUtil.executeOracleQuery(query, binds);
                    if (rset == null) break block6;
                    while (rset.next()) {
                        String _attr_name = rset.getString("ATTR_NAME");
                        String _type_owner = rset.getString("ATTR_TYPE_OWNER");
                        String _type_name = rset.getString("ATTR_TYPE_NAME");
                        String _type_code = rset.getString("ATTR_TYPECODE");
                        Integer _char_length = STRUCT.getIntegerResult(rset, "LENGTH");
                        Integer _data_precision = STRUCT.getIntegerResult(rset, "PRECISION");
                        Integer _data_scale = STRUCT.getIntegerResult(rset, "SCALE");
                        String _char_used = rset.getString("CHAR_USED");
                        HashMap<TypeMetadata.Attribute, Object> attributes = new HashMap<TypeMetadata.Attribute, Object>();
                        String _data_type = "COLLECTION".equals(_type_code) ? "VARRAY" : ("OBJECT".equals(_type_code) ? "STRUCT" : _type_name);
                        STRUCT.addAttribute(attributes, TypeMetadata.Attribute.BASE_TYPE, DataTypesUtil.reformatDataTypeString(_data_type));
                        STRUCT.addAttribute(attributes, TypeMetadata.Attribute.DATA_PRECISION, _data_precision);
                        STRUCT.addAttribute(attributes, TypeMetadata.Attribute.DATA_SCALE, _data_scale);
                        if (_data_type != _type_name) {
                            STRUCT.addAttribute(attributes, TypeMetadata.Attribute.TYPE_OWNER, _type_owner);
                            STRUCT.addAttribute(attributes, TypeMetadata.Attribute.TYPE_NAME, _type_name);
                        }
                        if (_char_length != null && _char_length != 0) {
                            STRUCT.addAttribute(attributes, TypeMetadata.Attribute.CHAR_LENGTH, _char_length);
                            STRUCT.addAttribute(attributes, TypeMetadata.Attribute.CHAR_USED, _char_used);
                        }
                        TypeMetadata typeMetadata = context.getDataTypeFactory().getTypeMetadata(attributes);
                        typeComponents.add(new NamedValue<TypeMetadata>(_attr_name, typeMetadata));
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rset);
                    provider.unlockDataTypeConnection();
                    throw throwable;
                }
            }
            DBUtil.closeResultSet(rset);
            provider.unlockDataTypeConnection();
        }
        return typeComponents;
    }

    private static Integer getIntegerResult(ResultSet rset, String name) throws SQLException {
        return rset.getObject(name) != null ? Integer.valueOf(rset.getInt(name)) : null;
    }

    private static void addAttribute(HashMap<TypeMetadata.Attribute, Object> attributes, TypeMetadata.Attribute attribute, Object value) {
        if (value != null) {
            attributes.put(attribute, value);
        }
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        StringBuilder sb = new StringBuilder();
        int len = 0;
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append("(");
        }
        ++len;
        List<DataValue> components = this.getComponents(value);
        int i = 0;
        for (DataValue component : components) {
            if (i > 0) {
                if (maxLen < 0 || sb.length() < maxLen) {
                    sb.append(", ");
                }
                len += 2;
            }
            String fieldTag = component.getName() != null ? component.getName() + "=" : "";
            String componentValue = "" + component.getStringValue(connectionProvider, stringType, maxLen);
            if (maxLen < 0 || sb.length() < maxLen) {
                sb.append(fieldTag);
            }
            len += fieldTag.length();
            if (maxLen < 0 || sb.length() < maxLen) {
                sb.append(componentValue);
            }
            len += componentValue.length();
            ++i;
        }
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append(")");
        }
        return new StringValue(sb.toString(), ++len);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        IllegalArgumentException t = new IllegalArgumentException();
        t.fillInStackTrace();
        try {
            List dataValueList = this.customComponents(value);
            int arraySize = ((LinkedList)dataValueList).size();
            ArrayList<Object> objectArray = new ArrayList<Object>(arraySize);
            for (DataValue dataValue : dataValueList) {
                objectArray.add(dataValue.getTypedValue(ValueType.DATUM));
            }
            Object validConnection = connectionProvider.getValidDataTypeConnection();
            validConnection = (Connection)JDBCProxyUtil.getInstance().unwrap(validConnection);
            StructDescriptor desc = StructDescriptor.createDescriptor((String)this.getUserDataTypeString(), validConnection);
            return new oracle.sql.STRUCT(desc, validConnection, objectArray.toArray(new Object[arraySize]));
        }
        catch (SQLException e) {
            if (t != null) {
                throw new DataTypeIllegalArgumentException(this, internalValue, t);
            }
            throw new DataTypeIllegalArgumentException(this, internalValue, t);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        return oracle.jdbc.OracleStruct.class;
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2002;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        LinkedList<DataValue> dataValueList = new LinkedList<DataValue>();
        try {
            if (value == null) {
                return this.customInternalValue(connectionProvider, dataValueList);
            }
            if (value instanceof OracleStruct) {
                OracleStruct valueStruct = (OracleStruct)value;
                Datum[] datumArray = valueStruct.getOracleAttributes();
                return this.customInternalValue(connectionProvider, datumArray);
            }
            if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                int i = 0;
                Collection<NamedValue<DataType>> components = this.getTypeComponents();
                for (NamedValue namedValue : components) {
                    Object fieldValue = i < arrayLength ? Array.get(value, i++) : null;
                    DataValue newDataValue = ((DataType)namedValue.getValue()).getDataValue(fieldValue);
                    dataValueList.add(NamedDataValue.getNamedDataValue(namedValue.getName(), newDataValue));
                }
                return dataValueList;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object[] values = collection.toArray(new Object[0]);
                return this.customInternalValue(connectionProvider, values);
            }
            throw new DataTypeIllegalArgumentException(this, value);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    @Override
    protected Object customInternalValueFilter(DataTypeConnectionProvider connectionProvider, Object value) {
        if (DataTypesUtil.isEmpty(value)) {
            return this.customInternalValue(connectionProvider, null);
        }
        return super.customInternalValueFilter(connectionProvider, value);
    }

    @Override
    public <P extends DataBinding> CallableBinding<P> getBind(BindContext context, P param) {
        return new CallableBindingUDT<P>(context, param);
    }

    protected LinkedList<DataValue> customComponents(DataValueInternal value) {
        return (LinkedList)value.getInternalValue();
    }

    @Override
    protected DataValue customDataValue(Object object) {
        return new CompositeValue((DataTypeImpl)this, object);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return this.customInternalValue(this.getDataTypeContext().getDataTypeConnectionProvider(), null);
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
    }

    @Override
    public void bodyDataValue(NamedValue value, String text) {
    }

    @Override
    public void bodyDataValue(NamedValue value, DataValue dataValue) {
        LinkedList dataValueList = (LinkedList)value.getValue();
        int i = 0;
        for (DataValue valueSlot : dataValueList) {
            String slotName = valueSlot.getName();
            String valueName = dataValue.getName();
            if (slotName != null && valueName != null && slotName.equals(valueName)) {
                dataValueList.set(i, NamedDataValue.getNamedDataValue(slotName, dataValue));
            }
            ++i;
        }
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        return this.customDataValue(value.getValue());
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.RECORD;
    }
}

