/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALYM;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraINTERVALYMFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import org.xml.sax.SAXException;

public class INTERVALYM
extends Datum {
    private final DataType integerType;
    private static final int[] fields = new int[]{1, 2};
    private static final String[] fieldNames = new String[]{"YEARS", "MONTHS"};
    private static final LinkedHashMap<String, Integer> componentMap = new LinkedHashMap<String, Integer>(){
        {
            for (int j = 0; j < fieldNames.length; ++j) {
                this.put(fieldNames[j], fields[j]);
            }
        }
    };

    protected INTERVALYM(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
        TypeMetadata numberMetadata = context.getDataTypeFactory().getTypeMetadata(context.getDataTypeConnectionProvider(), (Integer)4);
        this.integerType = context.getDataTypeFactory().getDataType(context, numberMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: {
                try {
                    OraINTERVALYMFormat formatter = ((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).getOraINTERVALYMFormat(FormatType.REST);
                    return new StringValue(formatter.format(internalValue));
                }
                catch (ParseException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        switch (valueType) {
            case JDBC: {
                return this.customTypedValue(connectionProvider, value, ValueType.DEFAULT, target);
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return oracle.sql.INTERVALYM.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -103;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof oracle.sql.INTERVALYM) {
            return value;
        }
        if (value instanceof byte[]) {
            return new oracle.sql.INTERVALYM(Arrays.copyOf((byte[])value, ((byte[])value).length));
        }
        if (value instanceof OraINTERVALYM) {
            return ((OraINTERVALYM)value).getDatum();
        }
        return new oracle.sql.INTERVALYM(value.toString());
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        return "YMINTERVAL_UNCONSTRAINED";
    }

    @Override
    protected String customDataTypeString() {
        Integer precision = this.typeMetadata.get_data_precision();
        if (precision != null) {
            return "INTERVAL YEAR (" + precision + ") TO MONTH";
        }
        return "INTERVAL YEAR TO MONTH";
    }

    @Override
    protected void customMarshal(DataTypeConnectionProvider connectionProvider, DataValueInternal value, DataValueMarshalHandler hd, String name) throws SAXException {
        Object internalValue = value.getInternalValue();
        if (internalValue != null && hd.getStringType() == StringType.REST) {
            int last;
            OraINTERVALYM interval = OraINTERVALYM.getInstance((oracle.sql.INTERVALYM)internalValue);
            int first = 0;
            for (last = 1; last >= first && interval.get(fields[last]) == 0; --last) {
            }
            while (first <= last && interval.get(fields[first]) == 0) {
                ++first;
            }
            if (first > last) {
                first = 0;
                last = 0;
            }
            int sign = interval.get(0);
            for (int j = first; j <= last; ++j) {
                int field = interval.get(fields[j]) * sign;
                hd.marshal(this.integerType.getDataValue(field), fieldNames[j]);
            }
        } else {
            super.customMarshal(connectionProvider, value, hd, name);
        }
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return OraINTERVALYM.getInstance();
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
        String text = String.copyValueOf(ch, start, length);
        this.bodyDataValue(value, text);
    }

    @Override
    public void bodyDataValue(NamedValue value, String text) {
        OraINTERVALYM internal = (OraINTERVALYM)value.getValue();
        OraINTERVALYM external = OraINTERVALYM.getInstance(new oracle.sql.INTERVALYM(text));
        internal.set(0, external.get(0));
        internal.set(1, external.get(1));
        internal.set(2, external.get(2));
    }

    @Override
    public void bodyDataValue(NamedValue value, DataValue dataValue) {
        OraINTERVALYM internal = (OraINTERVALYM)value.getValue();
        String name = dataValue.getName();
        BigInteger fieldValue = (BigInteger)dataValue.getTypedValue(ValueType.JAVA);
        int fieldId = this.getFieldId(name);
        if (fieldId != -1) {
            internal.set(fieldId, fieldValue.intValue());
        }
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        OraINTERVALYM internal = (OraINTERVALYM)value.getValue();
        return this.getDataValue(internal != null ? internal.getDatum() : null);
    }

    public NamedValue<DataType> getComponentType(String name) {
        if (componentMap.containsKey(name)) {
            return new NamedValue<DataType>(name.toUpperCase(), this.integerType);
        }
        return null;
    }

    @Override
    protected Iterable<String> customComponentNames() {
        return componentMap.keySet();
    }

    private int getFieldId(String name) {
        Integer id = componentMap.get(name);
        return id != null ? id : -1;
    }
}

