/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatumAtName;
import oracle.dbtools.raptor.datatypes.util.StringValue;

public abstract class Datum
extends DataTypeImpl {
    protected Datum(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        switch (stringType) {
            case REST: 
            case GENERIC: {
                Object internalValue = value.getInternalValue();
                if (internalValue instanceof oracle.sql.Datum) {
                    try {
                        return new StringValue(((oracle.sql.Datum)internalValue).stringValue());
                    }
                    catch (SQLException e) {
                        throw new DataTypeSQLException(e);
                    }
                }
                return super.customStringValue(connectionProvider, value, stringType, maxLen);
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    public <P extends DataBinding> CallableBinding<P> getBind(BindContext context, P param) {
        return new CallableBindingDatumAtName<P>(context, param);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        try {
            switch (valueType) {
                case JAVA: {
                    return this.customTypedValue(connectionProvider, value, ValueType.JDBC, target);
                }
                case DATUM: {
                    Object superValue = super.customTypedValue(connectionProvider, value, valueType, target);
                    oracle.sql.Datum datum = (oracle.sql.Datum)superValue;
                    return datum;
                }
                case JDBC: {
                    Object superValue = super.customTypedValue(connectionProvider, value, valueType, target);
                    if (superValue instanceof oracle.sql.Datum) {
                        oracle.sql.Datum datum = (oracle.sql.Datum)superValue;
                        return datum.toJdbc();
                    }
                    return superValue;
                }
            }
            return super.customTypedValue(connectionProvider, value, valueType, target);
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return this.customTypedClass(connectionProvider, ValueType.JDBC);
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return this.customSqlDataType(ValueType.JDBC);
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected boolean customRequiresConnection() {
        return false;
    }
}

