/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingCURSOR;
import oracle.dbtools.raptor.datatypes.values.ResultSetValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.jdbc.OracleCallableStatement;
import org.xml.sax.SAXException;

public class CURSOR
extends Datum {
    protected CURSOR(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        ResultSet ret = (ResultSet)value;
        return ret;
    }

    @Override
    protected DataValue customDataValue(Object object) {
        return new ResultSetValue((DataTypeImpl)this, object);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        switch (valueType) {
            case JDBC: {
                return this.customTypedValue(connectionProvider, value, ValueType.DEFAULT, target);
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return ResultSet.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -10;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected boolean customEquals(Object obj1, Object obj2) {
        DataTypeConnectionProvider provider = this.getDataTypeConnectionProvider();
        try {
            Object nlsConnection = provider.peekNLSConnection();
            String leftText = DataTypesUtil.stringValueChecked(obj1, nlsConnection, 32768);
            String rightText = DataTypesUtil.stringValueChecked(obj2, nlsConnection, 32768);
            return CURSOR.areEquals(leftText, rightText);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <P extends DataBinding> CallableBinding<P> getBind(BindContext context, P param) {
        return new CallableBindingCURSOR<P>(context, param);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        return null;
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
    }

    @Override
    protected void customMarshal(DataTypeConnectionProvider connectionProvider, DataValueInternal value, DataValueMarshalHandler hd, String name) throws SAXException {
        hd.bodyDataValue((DataType)this, name, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long hashResultSet(DataTypeConnectionProvider provider, ResultSet rs) throws SQLException {
        long hash = 0L;
        Object conn = provider.lockDataTypeConnection();
        if (conn != null) {
            try {
                String sql = "DECLARE    ctx DBMS_XMLGEN.ctxHandle;    hashSum NUMBER;    TYPE rc IS REF CURSOR;    ref1 rc := :p1; BEGIN    ctx := DBMS_XMLGEN.newContext(ref1);    DBMS_XMLGEN.setMaxRows(ctx, 1);   hashSum := 0;    LOOP        DECLARE            rowVal CLOB;            hashVal NUMBER;        BEGIN            rowVal := DBMS_XMLGEN.getXML(ctx);            EXIT WHEN DBMS_XMLGEN.getNumRowsProcessed(ctx) = 0;            hashVal := DBMS_UTILITY.get_hash_value(rowVal, 1, POWER(2,16)-1);            hashSum := hashSum + hashVal;        END;    END LOOP;    DBMS_XMLGEN.closeContext(ctx);    ? := hashSum;END;";
                OracleCallableStatement stmt = (OracleCallableStatement)conn.prepareCall(sql);
                stmt.setCursorAtName("p1", rs);
                stmt.registerOutParameter(2, 2);
                try {
                    stmt.execute();
                    hash = stmt.getLong(2);
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                provider.unlockDataTypeConnection();
            }
        }
        return hash;
    }
}

