/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeEncodingException;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.objects.BlobDatum;
import oracle.dbtools.raptor.datatypes.objects.LargeBinary;
import oracle.dbtools.raptor.datatypes.oracle.sql.LOB;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.util.encoding.EncodingException;
import org.xml.sax.SAXException;

public class BLOB
extends LOB {
    protected BLOB(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        LargeBinary largeBinary = (LargeBinary)value.getInternalValue();
        return largeBinary.getStringValue(stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        BlobDatum blobDatum = (BlobDatum)internalValue;
        try {
            switch (valueType) {
                case JDBC: 
                case DATUM: 
                case TARGET: {
                    return blobDatum.getTypedValue(connectionProvider, valueType, target);
                }
            }
            return super.customTypedValue(connectionProvider, value, valueType, target);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue);
        }
        catch (IOException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return InputStream.class;
            }
            case JDBC: 
            case DATUM: {
                return Blob.class;
            }
            case DEFAULT: {
                return BlobDatum.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2004;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value == null) {
                return new BlobDatum();
            }
            if (value instanceof BlobDatum) {
                return value;
            }
            return BlobDatum.constructFrom(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (EncodingException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (IOException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
    }

    @Override
    protected void customMarshal(DataTypeConnectionProvider connectionProvider, DataValueInternal value, DataValueMarshalHandler hd, String name) throws SAXException {
        BlobDatum blobDatum = (BlobDatum)value.getInternalValue();
        blobDatum.marshal(this, hd, name);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return BlobDatum.getBuilder();
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
        BlobDatum.BlobDatumBuilder builder = (BlobDatum.BlobDatumBuilder)value.getValue();
        try {
            builder.write(ch, start, length);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
        catch (EncodingException e) {
            throw new DataTypeEncodingException(e);
        }
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        BlobDatum.BlobDatumBuilder builder = (BlobDatum.BlobDatumBuilder)value.getValue();
        try {
            return this.getDataValue(builder != null ? builder.build() : null);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
    }
}

