/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.plsql;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.objects.PLSQLRecord;
import oracle.dbtools.raptor.datatypes.oracle.plsql.PLSQLDatum;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingRECORD;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.CompositeValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class RECORD
extends PLSQLDatum {
    protected RECORD(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        StringBuilder sb = new StringBuilder();
        int len = 0;
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append("<");
        }
        ++len;
        List<DataValue> components = this.getComponents(value);
        int i = 0;
        for (DataValue component : components) {
            if (i > 0) {
                if (maxLen < 0 || sb.length() < maxLen) {
                    sb.append(", ");
                }
                len += 2;
            }
            String fieldTag = component.getName() != null ? component.getName() + "=" : "";
            String componentValue = "" + component.getStringValue(connectionProvider, stringType, maxLen);
            if (maxLen < 0 || sb.length() < maxLen) {
                sb.append(fieldTag);
            }
            len += fieldTag.length();
            if (maxLen < 0 || sb.length() < maxLen) {
                sb.append(componentValue);
            }
            len += componentValue.length();
            ++i;
        }
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append(">");
        }
        return new StringValue(sb.toString(), ++len);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        PLSQLRecord record = new PLSQLRecord(this);
        List dataValueList = this.customComponents(value);
        for (DataValue dataValue : dataValueList) {
            record.add(dataValue.getTypedValue(valueType));
        }
        return record;
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        return PLSQLRecord.class;
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -333;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        LinkedList<DataValue> dataValueList = new LinkedList<DataValue>();
        if (value == null) {
            return this.customInternalValue(connectionProvider, dataValueList);
        }
        if (value.getClass().isArray()) {
            int arrayLength = Array.getLength(value);
            int i = 0;
            Collection<NamedValue<DataType>> components = this.getTypeComponents();
            for (NamedValue namedValue : components) {
                Object fieldValue = i < arrayLength ? Array.get(value, i++) : null;
                DataValue newDataValue = ((DataType)namedValue.getValue()).getDataValue(fieldValue);
                dataValueList.add(NamedDataValue.getNamedDataValue(namedValue.getName(), newDataValue));
            }
            return dataValueList;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Object[] values = collection.toArray(new Object[0]);
            return this.customInternalValue(connectionProvider, values);
        }
        if (value instanceof PLSQLRecord) {
            PLSQLRecord record = (PLSQLRecord)value;
            return this.getInternalValue(record.getRoot());
        }
        throw new DataTypeIllegalArgumentException(this, value);
    }

    public static String getUserDataTypeString(TypeMetadata typeMetadata) {
        String _type_name = typeMetadata.get_type_name();
        String _type_subname = typeMetadata.get_type_subname();
        StringBuilder buffer = new StringBuilder();
        RECORD.appendIdentifier(buffer, _type_name);
        RECORD.appendIdentifier(buffer, _type_subname);
        return buffer.length() == 0 ? null : buffer.toString();
    }

    @Override
    protected String customUserDataTypeString() {
        return RECORD.getUserDataTypeString(this.typeMetadata);
    }

    @Override
    protected Object customInternalValueFilter(DataTypeConnectionProvider connectionProvider, Object value) {
        return this.customInternalValue(connectionProvider, DataTypesUtil.isNull(value) ? null : value);
    }

    @Override
    public <P extends DataBinding> CallableBinding<P> getBind(BindContext context, P param) {
        return new CallableBindingRECORD<P>(context, param);
    }

    protected LinkedList<DataValue> customComponents(DataValueInternal value) {
        return (LinkedList)value.getInternalValue();
    }

    @Override
    protected DataValue customDataValue(Object object) {
        return new CompositeValue((DataTypeImpl)this, object);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        return this.customInternalValue(this.getDataTypeContext().getDataTypeConnectionProvider(), null);
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
    }

    @Override
    public void bodyDataValue(NamedValue value, String text) {
    }

    @Override
    public void bodyDataValue(NamedValue value, DataValue dataValue) {
        LinkedList dataValueList = (LinkedList)value.getValue();
        int i = 0;
        for (DataValue valueSlot : dataValueList) {
            String slotName = valueSlot.getName();
            String valueName = dataValue.getName();
            if (slotName != null && valueName != null && slotName.equals(valueName)) {
                dataValueList.set(i, NamedDataValue.getNamedDataValue(slotName, dataValue));
            }
            ++i;
        }
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        return this.customDataValue(value.getValue());
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.RECORD;
    }
}

