/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.plsql;

import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.plsql.PLSQLDatum;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingBOOLEAN;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.DataValueMapped;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class BOOLEAN
extends PLSQLDatum {
    private final DataType numberType;
    private DataValue trueValue;
    private DataValue falseValue;

    protected BOOLEAN(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
        TypeMetadata numberMetadata = context.getDataTypeFactory().getTypeMetadata(context.getDataTypeConnectionProvider(), (Integer)2);
        this.numberType = context.getDataTypeFactory().getDataType(context, numberMetadata);
        this.trueValue = null;
        this.falseValue = null;
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        return new StringValue(this.internalStringValue(value.getInternalValue()));
    }

    private String internalStringValue(Object value) {
        String stringValue = DataTypesUtil.stringValue(value, null);
        if (stringValue != null) {
            Boolean boolValue = null;
            try {
                int intValue = Integer.parseInt(stringValue);
                boolValue = intValue != 0;
            }
            catch (NumberFormatException e) {
                boolValue = Boolean.valueOf(stringValue);
            }
            stringValue = DataTypesUtil.stringValue(boolValue, null);
        }
        return stringValue;
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return Boolean.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 16;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        return Boolean.valueOf(this.internalStringValue(value));
    }

    @Override
    protected String customPlainDataTypeString() {
        return "BOOLEAN";
    }

    @Override
    protected String customBaseDataTypeString() {
        return "PL/SQL BOOLEAN";
    }

    @Override
    protected DataValue customDataValue(Object object) {
        DataValue typedDataValue = super.customDataValue(object);
        Boolean boolValue = (Boolean)typedDataValue.getTypedValue(ValueType.DEFAULT);
        Integer bitValue = boolValue == null ? null : Integer.valueOf(boolValue == true ? 1 : 0);
        DataValue bindingDataValue = this.numberType.getDataValue(bitValue);
        return new DataValueMapped(typedDataValue, bindingDataValue);
    }

    @Override
    public boolean isEnumeration() {
        return true;
    }

    @Override
    public List<DataValue> getEnumerationValues() {
        if (this.trueValue == null) {
            this.trueValue = this.getDataValue(Boolean.TRUE);
        }
        if (this.falseValue == null) {
            this.falseValue = this.getDataValue(Boolean.FALSE);
        }
        return new LinkedList<DataValue>(){
            {
                this.add(BOOLEAN.this.trueValue);
                this.add(BOOLEAN.this.falseValue);
            }
        };
    }

    @Override
    public <P extends DataBinding> CallableBinding<P> getBind(BindContext context, P param) {
        return new CallableBindingBOOLEAN<P>(context, param, this.numberType);
    }
}

