/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.raptor.datatypes.objects.OraIntervalDatum;
import oracle.dbtools.raptor.nls.OraINTERVALYMFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.INTERVALYM;

public class OraINTERVALYM
extends OraIntervalDatum {
    public static final int SIZE_INTERVALYM = 5;
    public static final int BYTE_YEAR1 = 0;
    public static final int BYTE_YEAR2 = 1;
    public static final int BYTE_YEAR3 = 2;
    public static final int BYTE_YEAR4 = 3;
    public static final int BYTE_MONTH = 4;
    private static final int INTERVALBYTEOFFSET = 60;
    private static final int INTERVALWORDOFFSET = Integer.MIN_VALUE;

    public static OraINTERVALYM getInstance() {
        return OraINTERVALYM.getInstance(0, 0);
    }

    public static OraINTERVALYM getInstance(int years, int months) {
        return new OraINTERVALYM(new OraINTERVALYMImpl(years, months));
    }

    public static OraINTERVALYM getInstance(INTERVALYM interval) {
        return interval != null ? new OraINTERVALYM(new OraINTERVALYMImpl(interval)) : null;
    }

    protected OraINTERVALYM(OraINTERVALYMImpl impl) {
        super(impl);
    }

    @Override
    public boolean nanosSupported() {
        return false;
    }

    public INTERVALYM getDatum() {
        byte[] bytes = ((OraINTERVALYMImpl)this.datumImpl).getDatumBytes();
        return new INTERVALYM(bytes);
    }

    public String toString() {
        try {
            OraINTERVALYMFormat formatter = new OraINTERVALYMFormat(OraLocaleInfo.getInstance((Locale)Locale.US));
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static class OraINTERVALYMImpl
    extends OraIntervalDatum.OraIntervalDatumImpl {
        protected OraINTERVALYMImpl(int years, int months) {
            super(new YMMetadata(), OraINTERVALYMImpl.getFieldArray(years, months), 1, 2, 2, 9);
        }

        protected OraINTERVALYMImpl(INTERVALYM interval) {
            super(new YMMetadata(), OraINTERVALYMImpl.getFieldArray(interval.shareBytes()), 1, 2, 2, 9);
        }

        protected static int[] getFieldArray(int years, int months) {
            int[] fieldArray = new int[]{0, years, months};
            return fieldArray;
        }

        protected static int[] getFieldArray(byte[] bytes) {
            int intMonth = 0;
            int intYear = (bytes[0] & 0xFF) << 24;
            intYear |= (bytes[1] & 0xFF) << 16;
            intYear |= (bytes[2] & 0xFF) << 8;
            intYear |= bytes[3] & 0xFF;
            intMonth = bytes[4] - 60;
            return OraINTERVALYMImpl.getFieldArray(intYear -= Integer.MIN_VALUE, intMonth);
        }

        @Override
        protected byte[] getDatumBytes() {
            byte[] bytes = new byte[5];
            int intSign = this.get(0);
            int intYear = this.get(1) * intSign + Integer.MIN_VALUE;
            int intMonth = this.get(2) * intSign + 60;
            bytes[0] = (byte)(intYear >> 24 & 0xFF);
            bytes[1] = (byte)(intYear >> 16 & 0xFF);
            bytes[2] = (byte)(intYear >> 8 & 0xFF);
            bytes[3] = (byte)(intYear & 0xFF);
            bytes[4] = (byte)(intMonth & 0xFF);
            return bytes;
        }

        @Override
        public void normalize() {
            int years = this.get(1);
            int months = this.get(2);
            int yearsXtra = months % 12;
            if (yearsXtra != 0) {
                years += yearsXtra;
                months -= yearsXtra * 12;
            }
            this.set(2, months);
            this.set(1, years);
        }

        protected static class YMMetadata
        extends OraIntervalDatum.MetaData {
            private ArrayList<OraIntervalDatum.Field> fieldMetaData = new ArrayList(3);

            private YMMetadata() {
                this.fieldMetaData.add(OraIntervalDatum.Field.SIGN);
                this.fieldMetaData.add(OraIntervalDatum.Field.YEARS);
                this.fieldMetaData.add(OraIntervalDatum.Field.MONTHS);
            }

            @Override
            protected List<OraIntervalDatum.Field> getFieldList() {
                return this.fieldMetaData;
            }

            @Override
            public Object clone() {
                YMMetadata other = (YMMetadata)super.clone();
                other.fieldMetaData = (ArrayList)this.fieldMetaData.clone();
                return other;
            }
        }
    }
}

