/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public final class ArgMetadata
extends NamedValue<Map<TypeMetadata.Attribute, Object>> {
    final TreeMap<Integer, ArgMetadata> components;
    final BindingMode mode;
    final boolean defaulted;
    final String defaultValue;
    final Integer defaultLength;
    ArgIdentifier identifier;
    Integer minCompSequence;
    Integer maxCompSequence;

    public ArgMetadata(ArgIdentifier identifier, String argName, String inOut, Map<TypeMetadata.Attribute, Object> typeAttributes, String defaulted, String defaultValue, Integer defaultLength, List<ArgMetadata> components) {
        super(argName, typeAttributes);
        this.identifier = identifier;
        this.components = new TreeMap();
        this.mode = argName == null && identifier.position != null && identifier.position == 0 ? BindingMode.RETURN : BindingMode.getBindingMode(inOut);
        this.defaulted = "Y".equals(defaulted);
        this.defaultValue = defaultValue;
        this.defaultLength = defaultLength;
        this.minCompSequence = null;
        this.maxCompSequence = null;
        if (components != null) {
            for (ArgMetadata component : components) {
                this.addComponent(component);
            }
        }
    }

    public ArgMetadata(ArgIdentifier identifier, String argName, String inOut, Map<TypeMetadata.Attribute, Object> typeAttributes, String defaulted, String defaultValue, Integer defaultLength) {
        this(identifier, argName, inOut, typeAttributes, defaulted, defaultValue, defaultLength, null);
    }

    public ArgIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isDefaulted() {
        return this.defaulted;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Integer getDefaultLength() {
        return this.defaultLength;
    }

    public BindingMode getMode() {
        return this.mode;
    }

    public ArgMetadata getComponent(int sequence) {
        return this.components.get(sequence);
    }

    boolean addComponent(ArgMetadata component) {
        if (component != null) {
            Integer sequence = component.identifier.sequence;
            if (sequence == null) {
                sequence = this.components.size() + 1;
            } else if (sequence < 0) {
                throw new IllegalArgumentException();
            }
            ArgMetadata oldComponent = this.components.put(sequence, component);
            if (oldComponent != null && oldComponent != component) {
                this.components.put(oldComponent.identifier.sequence, oldComponent);
                throw new IllegalArgumentException();
            }
            if (this.minCompSequence == null || this.minCompSequence > sequence) {
                this.minCompSequence = sequence;
            }
            if (this.maxCompSequence == null || this.maxCompSequence < sequence) {
                this.maxCompSequence = sequence;
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public int countComponents() {
        return this.components.size();
    }

    public Iterator<ArgMetadata> componentIterator() {
        return this.components.values().iterator();
    }

    public NamedValue<TypeMetadata> extractTypeMetadata() {
        HashMap<TypeMetadata.Attribute, Object> typeAttributes = new HashMap<TypeMetadata.Attribute, Object>((Map)this.getValue());
        LinkedList<NamedValue<TypeMetadata>> typeComponents = new LinkedList<NamedValue<TypeMetadata>>();
        for (ArgMetadata argMetadata : this.components.values()) {
            typeComponents.add(argMetadata.extractTypeMetadata());
        }
        if (typeComponents.size() != 0) {
            typeAttributes.put(TypeMetadata.Attribute.TYPE_COMPONENTS, typeComponents);
        }
        TypeMetadata typeMetaData = DataTypeFactory.getInstance().getTypeMetadata(typeAttributes);
        return new NamedValue<TypeMetadata>(this.getName(), typeMetaData);
    }

    boolean identifiedBy(ArgIdentifier identifier) {
        return this.identifier.matches(identifier);
    }

    public static final class ArgIdentifier
    implements Cloneable {
        Integer position;
        Integer sequence;
        Integer level;

        ArgIdentifier(int position, Integer sequence, Integer level) {
            this.position = position;
            this.sequence = sequence;
            this.level = level;
        }

        public Object clone() {
            return new ArgIdentifier(this.position, this.sequence, this.level);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ArgIdentifier) {
                ArgIdentifier other = (ArgIdentifier)obj;
                return DataTypesUtil.areEqual(this.position, other.position) && DataTypesUtil.areEqual(this.sequence, other.sequence) && DataTypesUtil.areEqual(this.level, other.level);
            }
            return false;
        }

        public int hashCode() {
            int hash = 23;
            hash = 31 * hash + (this.position == null ? 0 : this.position.hashCode());
            hash = 31 * hash + (this.sequence == null ? 0 : this.sequence.hashCode());
            hash = 31 * hash + (this.level == null ? 0 : this.level.hashCode());
            return hash;
        }

        public Integer getSequence() {
            return this.sequence;
        }

        public Integer getPosition() {
            return this.position;
        }

        public Integer getLevel() {
            return this.level;
        }

        boolean matches(ArgIdentifier identifier) {
            return DataTypesUtil.areEqual(this, identifier);
        }
    }
}

