/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeMarshallingException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import org.xml.sax.SAXException;

public abstract class DataTypeImpl
implements DataType {
    protected final TypeMetadata typeMetadata;
    private final DataTypeContext dataTypeContext;
    protected final LinkedHashMap<String, NamedValue<DataType>> typeComponents;
    private String dataTypeString;
    public static boolean _DEBUG = false;

    protected DataTypeImpl(DataTypeContext context, TypeMetadata typeMetadata) {
        this.dataTypeContext = context;
        this.typeComponents = this.customTypeComponents(context, typeMetadata.get_type_components());
        this.typeMetadata = this.buildExpandedTypeMetadata(typeMetadata, this.getTypeComponents());
        this.dataTypeString = this.initDataTypeString();
        if (this.requiresConnection() && context != null) {
            context.getDataTypeConnectionProvider().getValidDataTypeConnection();
        }
    }

    protected LinkedHashMap<String, NamedValue<DataType>> customTypeComponents(DataTypeContext context, List<NamedValue<TypeMetadata>> metaComponents) {
        LinkedHashMap<String, NamedValue<DataType>> typeComponents = null;
        if (metaComponents != null) {
            typeComponents = new LinkedHashMap<String, NamedValue<DataType>>();
            for (NamedValue<TypeMetadata> typeComponent : metaComponents) {
                typeComponents.put(typeComponent.getName(), new NamedValue<DataType>(typeComponent.getName(), context.getDataTypeFactory().getDataType(context, typeComponent.getValue())));
            }
        }
        return typeComponents;
    }

    private TypeMetadata buildExpandedTypeMetadata(TypeMetadata typeMetadata, Iterable<NamedValue<DataType>> subTypes) {
        TypeMetadata builtTypeMetadata = typeMetadata;
        if (subTypes != null) {
            LinkedList<NamedValue<TypeMetadata>> buildTypeMetadataComponents = new LinkedList<NamedValue<TypeMetadata>>();
            for (NamedValue<DataType> namedComponent : subTypes) {
                buildTypeMetadataComponents.add(new NamedValue<TypeMetadata>(namedComponent.getName(), namedComponent.getValue().getTypeMetadata()));
            }
            HashMap<TypeMetadata.Attribute, Object> attributes = new HashMap<TypeMetadata.Attribute, Object>();
            attributes.put(TypeMetadata.Attribute.TYPE_COMPONENTS, buildTypeMetadataComponents);
            builtTypeMetadata = DataTypeFactory.getTypeMetadata(builtTypeMetadata, attributes);
        }
        return builtTypeMetadata;
    }

    @Override
    public final TypeMetadata getTypeMetadata() {
        return this.typeMetadata;
    }

    protected DataTypeContext getDataTypeContext() {
        return this.dataTypeContext;
    }

    @Override
    public final DataValue getDataValue(Object object) {
        try {
            if (object instanceof DataValue) {
                DataValue value = (DataValue)object;
                if (this.isDataType(value)) {
                    return NamedDataValue.getNamedDataValue(null, value);
                }
                return this.getDataValue(value.getTypedValue(ValueType.DEFAULT));
            }
            return this.customDataValue(object);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, object, e);
        }
    }

    protected DataValue customDataValue(Object object) {
        return new DataValueImpl(this, object);
    }

    @Override
    public final Collection<NamedValue<DataType>> getTypeComponents() {
        return this.typeComponents != null ? this.typeComponents.values() : null;
    }

    @Override
    public final Iterable<String> getComponentNames() {
        return this.customComponentNames();
    }

    protected Iterable<String> customComponentNames() {
        return this.typeComponents != null ? this.typeComponents.keySet() : null;
    }

    protected final List<DataValue> getComponents(DataValueInternal value) {
        try {
            return value.getInternalValue() == null || this.getTypeComponents() == null ? null : this.customComponents(value);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, value.getInternalValue(), e);
        }
    }

    protected List<DataValue> customComponents(DataValueInternal value) {
        if (value.getInternalValue() == null || this.getTypeComponents() == null) {
            List<DataValue> ret = null;
            return ret;
        }
        throw new UnsupportedOperationException();
    }

    protected void _debug(String msg) {
        if (_DEBUG) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, msg);
        }
    }

    protected final StringValue getStringValue(DataValueInternal value, StringType stringType, int maxLen) {
        return this.getStringValue(this.dataTypeContext.getDataTypeConnectionProvider(), value, stringType, maxLen);
    }

    protected final StringValue getStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        try {
            StringValue stringValue = internalValue == null ? new StringValue(null) : this.customStringValue(connectionProvider, value, stringType, maxLen);
            String valueText = stringValue.toString();
            if (maxLen < 0 || valueText == null || valueText.length() <= maxLen) {
                return stringValue;
            }
            return new StringValue(valueText.substring(0, maxLen), stringValue.getMaxLength());
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
    }

    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        Object nlsConnection = connectionProvider.peekNLSConnection();
        switch (stringType) {
            case NLS: {
                nlsConnection = connectionProvider.getNLSConnection();
            }
            case REST: 
            case GENERIC: {
                try {
                    String valueText = maxLen >= 0 ? DataTypesUtil.stringValueChecked(internalValue, nlsConnection, maxLen) : DataTypesUtil.stringValueChecked(internalValue, nlsConnection);
                    return new StringValue(valueText);
                }
                catch (NullPointerException npe) {
                    throw npe;
                }
                catch (DataTypeException de) {
                    throw de;
                }
                catch (SQLException e) {
                    throw new DataTypeSQLException(e);
                }
                catch (IOException e) {
                    throw new DataTypeIOException(e);
                }
                catch (Exception e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue, e);
                }
            }
            case DEFAULT: {
                return this.customStringValue(connectionProvider, value, nlsConnection != null ? StringType.NLS : StringType.GENERIC, maxLen);
            }
        }
        return this.customStringValue(connectionProvider, value, StringType.DEFAULT, maxLen);
    }

    protected final Object getTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        try {
            return this.customTypedValueFilter(connectionProvider, value, valueType, target);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
    }

    protected final Object getTypedValue(DataValueInternal value, ValueType valueType, Object target) {
        return this.getTypedValue(this.dataTypeContext.getDataTypeConnectionProvider(), value, valueType, target);
    }

    protected final Object getTypedValue(DataValueInternal value, ValueType valueType) {
        return this.getTypedValue(value, valueType, null);
    }

    protected final Object getTypedValue(DataValueInternal value, Object target) {
        return this.getTypedValue(value, ValueType.TARGET, target);
    }

    @Override
    public final Class getTypedClass(ValueType valueType) {
        return this.customTypedClass(this.dataTypeContext.getDataTypeConnectionProvider(), valueType);
    }

    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return Object.class;
            }
        }
        return this.customTypedClass(connectionProvider, ValueType.DEFAULT);
    }

    protected Object customTypedValueFilter(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        return value.getInternalValue() == null ? target : this.customTypedValue(connectionProvider, value, valueType, target);
    }

    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        switch (valueType) {
            case DEFAULT: {
                return internalValue;
            }
            case TARGET: {
                throw new DataTypeIllegalArgumentException(this, target);
            }
        }
        return this.customTypedValue(connectionProvider, value, ValueType.DEFAULT, target);
    }

    protected final Object getInternalValue(Object value) {
        try {
            return this.customInternalValueFilter(this.dataTypeContext.getDataTypeConnectionProvider(), value);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
    }

    protected Object customInternalValueFilter(DataTypeConnectionProvider connectionProvider, Object value) {
        return DataTypesUtil.isNull(value) ? null : this.customInternalValue(connectionProvider, value);
    }

    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        return value;
    }

    protected final void marshal(DataValueInternal value, DataValueMarshalHandler hd, String name) throws SAXException {
        try {
            this.customMarshal(this.dataTypeContext.getDataTypeConnectionProvider(), value, hd, name);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, value.getInternalValue(), e);
        }
    }

    protected void customMarshal(DataTypeConnectionProvider connectionProvider, DataValueInternal value, DataValueMarshalHandler hd, String name) throws SAXException {
        StringType stringType = hd.getStringType();
        StringValue stringValue = this.getStringValue(value, stringType, -1);
        hd.bodyDataValue((DataType)this, name, stringValue.toString());
    }

    public final boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = this == obj;
        if (!isEqual && obj instanceof DataTypeImpl) {
            isEqual = this.customEquals(obj);
        }
        return isEqual;
    }

    protected boolean customEquals(Object obj) {
        if (obj instanceof DataTypeImpl) {
            DataTypeImpl objDataType = (DataTypeImpl)obj;
            return DataTypeImpl.areEquals(this.dataTypeContext, objDataType.dataTypeContext) && DataTypeImpl.areEquals(this.typeMetadata, objDataType.typeMetadata) && DataTypeImpl.areEquals(this.getTypeComponents(), objDataType.getTypeComponents());
        }
        return false;
    }

    final boolean equals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && this.customEquals(obj1, obj2);
    }

    protected boolean customEquals(Object obj1, Object obj2) {
        return DataTypeImpl.areEquals(obj1, obj2);
    }

    protected static boolean areEquals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    private boolean isDataType(DataValue value) {
        return DataTypeImpl.areEquals(this, value.getDataType());
    }

    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                Integer typeCode = this.typeMetadata.get_type_code();
                if (typeCode != null) {
                    return typeCode;
                }
                typeCode = DataTypesUtil.getJdbcTypeCode(this.getPlainDataTypeString());
                if (typeCode != null) {
                    return typeCode;
                }
                typeCode = DataTypesUtil.getJdbcTypeCode(this.getBaseDataTypeString());
                if (typeCode == null) {
                    return 1111;
                }
                return typeCode;
            }
        }
        return this.customSqlDataType(ValueType.DEFAULT);
    }

    @Override
    public final int getSqlDataType(ValueType valueType) {
        return this.customSqlDataType(valueType);
    }

    @Override
    public final String getDataTypeString() {
        return this.dataTypeString;
    }

    public final String initDataTypeString() {
        return DataTypesUtil.reformatDataTypeString(this.customDataTypeString());
    }

    protected String customDataTypeString() {
        String dataTypeString = this.typeMetadata.get_data_type();
        if (dataTypeString == null && (dataTypeString = this.getUserDataTypeString()) == null) {
            Integer _data_precision = this.typeMetadata.get_data_precision();
            Integer _data_scale = this.typeMetadata.get_data_scale();
            StringBuffer buffer = new StringBuffer(this.getPlainDataTypeString());
            if (_data_precision != null && _data_scale != null) {
                buffer.append("(").append(_data_precision).append(",").append(_data_scale).append(")");
            } else if (_data_precision != null) {
                buffer.append("(").append(_data_precision).append(")");
            }
            dataTypeString = buffer.toString();
        }
        return dataTypeString;
    }

    @Override
    public final String getPlainDataTypeString() {
        return DataTypesUtil.stripDataTypeStringConstraints(this.customPlainDataTypeString());
    }

    protected String customPlainDataTypeString() {
        String plainDataTypeString = this.typeMetadata.get_data_type();
        if (plainDataTypeString == null && (plainDataTypeString = this.getUserDataTypeString()) == null) {
            plainDataTypeString = this.typeMetadata.get_base_type();
        }
        return plainDataTypeString;
    }

    @Override
    public final String getUserDataTypeString() {
        return this.customUserDataTypeString();
    }

    public static String getUserDataTypeString(TypeMetadata typeMetadata) {
        String _type_owner = typeMetadata.get_type_owner();
        String _type_name = typeMetadata.get_type_name();
        String _type_subname = typeMetadata.get_type_subname();
        StringBuilder buffer = new StringBuilder();
        DataTypeImpl.appendIdentifier(buffer, _type_owner);
        DataTypeImpl.appendIdentifier(buffer, _type_name);
        DataTypeImpl.appendIdentifier(buffer, _type_subname);
        return buffer.length() == 0 ? null : buffer.toString();
    }

    protected String customUserDataTypeString() {
        return DataTypeImpl.getUserDataTypeString(this.typeMetadata);
    }

    @Override
    public final String getBaseDataTypeString() {
        return DataTypesUtil.stripDataTypeStringConstraints(this.customBaseDataTypeString());
    }

    protected String customBaseDataTypeString() {
        String baseDataTypeString = this.typeMetadata.get_base_type();
        if (baseDataTypeString == null) {
            baseDataTypeString = this.typeMetadata.get_data_type();
        }
        return baseDataTypeString;
    }

    @Override
    public final String getConstrainedDataTypeString() {
        return this.customConstrainedDataTypeString();
    }

    protected String customConstrainedDataTypeString() {
        return this.getDataTypeString();
    }

    @Override
    public final String getUnconstrainedDataTypeString() {
        return this.customUnconstrainedDataTypeString();
    }

    protected String customUnconstrainedDataTypeString() {
        return this.getDataTypeString();
    }

    @Override
    public String validateValue(Object object) {
        String msg = null;
        try {
            if (!(object instanceof DataValue)) {
                this.getDataValue(object);
            }
        }
        catch (DataTypeIllegalArgumentException e) {
            msg = e.getLocalizedMessage();
        }
        return msg;
    }

    @Override
    public boolean isEnumeration() {
        return false;
    }

    @Override
    public List<DataValue> getEnumerationValues() {
        return null;
    }

    @Override
    public final boolean isSupported() {
        if (this.customSupported()) {
            Collection<NamedValue<DataType>> components = this.getTypeComponents();
            if (components != null) {
                for (NamedValue namedValue : components) {
                    DataType componentType = (DataType)namedValue.getValue();
                    if (componentType.isSupported()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean customSupported() {
        return true;
    }

    @Override
    public StructureType getStructureType() {
        if (this.getTypeComponents() != null && this.getTypeComponents().size() > 0) {
            return StructureType.TABLE;
        }
        return StructureType.PRIMITIVE;
    }

    @Override
    public final boolean requiresConnection() {
        if (this.getTypeComponents() != null) {
            for (NamedValue<DataType> typecomponent : this.getTypeComponents()) {
                if (!typecomponent.getValue().requiresConnection()) continue;
                return true;
            }
        }
        return this.customRequiresConnection();
    }

    @Override
    public DataTypeFactory getDataTypeFactory() {
        return this.dataTypeContext.getDataTypeFactory();
    }

    @Override
    public DataTypeConnectionProvider getDataTypeConnectionProvider() {
        return this.dataTypeContext.getDataTypeConnectionProvider();
    }

    protected boolean customRequiresConnection() {
        return false;
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return new StringBuilder();
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
        StringBuilder sb = (StringBuilder)value.getValue();
        sb.append(ch, start, length);
    }

    @Override
    public void bodyDataValue(NamedValue value, String text) {
        char[] chars = text.toCharArray();
        this.bodyDataValue(value, chars, 0, chars.length);
    }

    @Override
    public void bodyDataValue(NamedValue value, DataValue childValue) {
        throw new DataTypeMarshallingException(value.getName(), this);
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        StringBuilder sb = (StringBuilder)value.getValue();
        return this.getDataValue(sb != null ? sb.toString() : null);
    }

    protected static StringBuilder appendIdentifier(StringBuilder target, String source) {
        if (source != null) {
            if (target.length() == 0) {
                target.append(source);
            } else {
                target.append(".").append(source);
            }
        }
        return target;
    }

    public String toString() {
        try {
            return this.getPlainDataTypeString();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return super.toString();
        }
    }
}

