/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;

public class DataTypeConnectionProviderImpl<C extends Connection>
implements DataTypeConnectionProvider<C> {
    protected final Class<C> connectionClass;
    private WeakReference<C> connection;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String CONNECTION = "connection";

    public DataTypeConnectionProviderImpl(Class<C> connectionClass) {
        this(connectionClass, null);
    }

    public DataTypeConnectionProviderImpl(Class<C> connectionClass, C connection) {
        this.connectionClass = connectionClass;
        this.connection = new WeakReference<C>(connectionClass.cast(connection));
    }

    public DataTypeConnectionProviderImpl(C connection) {
        this.connectionClass = connection.getClass();
        this.connection = new WeakReference<C>(connection);
    }

    protected C setDataTypeConnection(C connection) {
        C oldConnection = this.peekDataTypeConnection();
        this.connection = new WeakReference<C>(this.connectionClass.cast(connection));
        this.firePropertyChange(CONNECTION, oldConnection, connection);
        return oldConnection;
    }

    protected C releaseDataTypeConnection(boolean close) throws DataTypeConnectionException {
        C oldConnection = this.peekDataTypeConnection();
        try {
            if (close && oldConnection != null && !oldConnection.isClosed()) {
                oldConnection.close();
            }
        }
        catch (SQLException e) {
            throw new DataTypeConnectionException(e);
        }
        return this.setDataTypeConnection(null);
    }

    @Override
    public C peekDataTypeConnection() {
        return (C)((Connection)this.connection.get());
    }

    @Override
    public C getDataTypeConnection() {
        return this.peekDataTypeConnection();
    }

    @Override
    public C getValidDataTypeConnection() {
        return this.getDataTypeConnection();
    }

    @Override
    public void unlockDataTypeConnection() throws DataTypeConnectionException {
    }

    @Override
    public C lockDataTypeConnection() throws DataTypeConnectionException {
        return this.lockDataTypeConnection(false);
    }

    @Override
    public C lockDataTypeConnection(boolean prompt) throws DataTypeConnectionException {
        return this.getValidDataTypeConnection();
    }

    @Override
    public C getNLSConnection() {
        return this.getDataTypeConnection();
    }

    @Override
    public C peekNLSConnection() {
        return this.peekDataTypeConnection();
    }

    @Override
    public C getValidNLSConnection() throws DataTypeConnectionException {
        return this.getValidDataTypeConnection();
    }

    @Override
    public void unlockNLSConnection() throws DataTypeConnectionException {
    }

    @Override
    public C lockNLSConnection() throws DataTypeConnectionException {
        return this.lockNLSConnection(false);
    }

    @Override
    public C lockNLSConnection(boolean prompt) throws DataTypeConnectionException {
        return this.getValidNLSConnection();
    }

    @Override
    public Class<C> getDataTypeConnnectionClass() {
        return this.connectionClass;
    }

    private static boolean areEquals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

