/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;

public abstract class CallableBindingImpl<P extends DataBinding>
implements CallableBinding<P> {
    private static final String FMT = "%1$-15s %2$-15s %3$-6s %4$-40s\n";
    protected final P param;
    protected final BindingMode mode;
    protected final DataType dataType;
    protected DataValue inputValue;
    protected DataValue outputValue;

    protected CallableBindingImpl(P param) {
        this(param, param.getDataType(), param.getMode());
    }

    protected CallableBindingImpl(P param, DataType dataType, BindingMode mode) {
        this.param = param;
        this.dataType = dataType;
        this.mode = mode;
        this.inputValue = null;
        this.outputValue = null;
    }

    @Override
    public final P getParameter() {
        return this.param;
    }

    @Override
    public final DataType getDataType() {
        return this.dataType;
    }

    @Override
    public final BindingMode getMode() {
        return this.mode;
    }

    @Override
    public abstract void setByNameBindToken(String var1);

    @Override
    public abstract String getByNameBindToken();

    @Override
    public abstract void setByPositionBindToken(String var1);

    @Override
    public abstract String getByPositionBindToken();

    @Override
    public abstract BindingStyle getBindingStyle(BindingMode var1);

    @Override
    public abstract String getBindToken(BindingMode var1);

    @Override
    public final DataValue getInput() throws SQLException {
        return this.inputValue;
    }

    @Override
    public final DataValue getOutput() throws SQLException {
        return this.customOutput();
    }

    protected abstract DataValue customOutput() throws SQLException;

    @Override
    public abstract CallableStatement getCallableStatement();

    protected abstract void setCallableStatement(CallableStatement var1);

    @Override
    public final void bind(CallableStatement stmt, DataValue value) throws SQLException {
        this.setCallableStatement(stmt);
        this.inputValue = value;
        this.outputValue = null;
        this.customBind(value);
    }

    protected void customBind(DataValue value) throws SQLException {
        switch (this.mode.getEffectiveMode()) {
            case IN: {
                this.customBindIN(value);
                break;
            }
            case OUT: {
                this.customBindOUT();
                break;
            }
            case IN_OUT: {
                this.customBindIN(value);
                this.customBindOUT();
            }
        }
    }

    protected abstract void customBindIN(DataValue var1) throws SQLException;

    @Override
    public final void bind(CallableStatement stmt) throws SQLException {
        this.setCallableStatement(stmt);
        this.inputValue = null;
        this.outputValue = null;
        this.customBind();
    }

    protected void customBind() throws SQLException {
        switch (this.mode.getEffectiveMode()) {
            case OUT: 
            case IN_OUT: {
                this.customBindOUT();
            }
        }
    }

    protected abstract void customBindOUT() throws SQLException;

    @Override
    public final PLSQLBoundBlockBuilder getBuilder() {
        return this.getBuilder(new PLSQLBoundBlockBuilder());
    }

    @Override
    public final PLSQLBoundBlockBuilder getBuilder(PLSQLBoundBlockBuilder builder) {
        return this.customBuilder(builder);
    }

    protected abstract PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder var1);

    @Override
    public final void reportBinding(StringBuilder buffer, DataValue value) {
        this.customReportBinding(buffer, value);
    }

    @Override
    public final void reportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        this.customReportBinding(buffer, nullToken, value);
    }

    protected void customReportBinding(StringBuilder buffer, DataValue value) {
        this.customReportBinding(buffer, null, value);
    }

    protected abstract void customReportBinding(StringBuilder var1, String var2, DataValue var3);

    protected final void reportBinding(StringBuilder buffer, String nullToken, String bindToken, DataType dataType, BindingMode mode, String value) {
        String debugValue;
        String string = mode == BindingMode.OUT ? nullToken : (debugValue = value == null ? nullToken : value);
        if (bindToken != null) {
            String inOut = mode.toString();
            buffer.append(String.format(FMT, bindToken, dataType.getPlainDataTypeString(), inOut, debugValue));
        }
    }

    @Override
    public boolean isSupported(BindingMode mode) {
        return this.getDataType().isSupported();
    }

    @Override
    public final CallableBindingSplitMode<P> getSplitModeBinding() {
        return this.customSplitModeBinding();
    }

    protected abstract CallableBindingSplitMode<P> customSplitModeBinding();
}

