/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;

public class BindContextImpl
implements BindContext {
    private int lastBindIndex;
    private List<String> bindTokens;
    protected final DataTypeConnectionProvider connectionProvider;

    public BindContextImpl(DataTypeConnectionProvider provider) {
        this.connectionProvider = provider;
        this.lastBindIndex = 0;
        this.bindTokens = null;
    }

    @Override
    public String nextBindToken() {
        return ":" + ++this.lastBindIndex;
    }

    @Override
    public String lastBindToken() {
        return ":" + this.lastBindIndex;
    }

    @Override
    public int remapPosition(String bindToken) {
        int newPosition = -1;
        if (this.bindTokens != null && (newPosition = this.bindTokens.indexOf(bindToken)) >= 0) {
            ++newPosition;
        }
        return newPosition;
    }

    @Override
    public void setBindTokens(List<String> bindTokens) {
        this.bindTokens = bindTokens;
    }

    @Override
    public List<String> getBindTokens() {
        return this.bindTokens;
    }

    @Override
    public DataTypeConnectionProvider getDataTypeConnectionProvider() {
        return this.connectionProvider;
    }
}

