/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.UnsupportedDataTypeImpl;

public abstract class AbstractDataTypeFactoryImpl
implements DataTypeProvider {
    private DataTypeProvider next;
    private final Map<Integer, TypeMetadata> typeCodeMetadataMap;
    private final Map<String, TypeMetadata> typeNameMetadataMap;

    protected AbstractDataTypeFactoryImpl(DataTypeProvider next, Map<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> typePropertyMap) {
        TypeMetadata typeMetadata;
        NamedValue<Map<TypeMetadata.Attribute, Object>> namedProps;
        String typeName;
        this.next = next;
        this.typeCodeMetadataMap = new HashMap<Integer, TypeMetadata>();
        this.typeNameMetadataMap = new HashMap<String, TypeMetadata>();
        for (Map.Entry<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> entry : typePropertyMap.entrySet()) {
            typeName = entry.getKey();
            namedProps = entry.getValue();
            HashMap<TypeMetadata.Attribute, Object> propMap = new HashMap<TypeMetadata.Attribute, Object>();
            AbstractDataTypeFactoryImpl.getTypePropertyMap(next, propMap, typePropertyMap, typeName, namedProps);
            boolean syntaxSynomym = namedProps != null && namedProps.getValue() == null && namedProps.getName() != null && !namedProps.getName().contains("(");
            typeMetadata = DataTypeFactory.getTypeMetadata(propMap, syntaxSynomym);
            if (typeMetadata == null) continue;
            this.typeNameMetadataMap.put(typeName, typeMetadata);
        }
        for (Map.Entry<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> entry : typePropertyMap.entrySet()) {
            Integer typeCode;
            typeName = entry.getKey();
            namedProps = entry.getValue();
            Map<TypeMetadata.Attribute, Object> props = namedProps.getValue();
            if (props == null || (typeCode = (Integer)props.get((Object)TypeMetadata.Attribute.TYPE_CODE)) == null || (typeMetadata = this.typeNameMetadataMap.get(typeName)) == null) continue;
            this.typeCodeMetadataMap.put(typeCode, typeMetadata);
        }
    }

    private static void getTypePropertyMap(DataTypeProvider next, Map<TypeMetadata.Attribute, Object> propMap, Map<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> typePropertyMap, String typeName, NamedValue<Map<TypeMetadata.Attribute, Object>> namedProps) {
        if (namedProps != null) {
            String basedOnName = namedProps.getName();
            Map<TypeMetadata.Attribute, Object> props = namedProps.getValue();
            if (basedOnName != null) {
                NamedValue<Map<TypeMetadata.Attribute, Object>> basedOnNamedProps = typePropertyMap.get(basedOnName);
                AbstractDataTypeFactoryImpl.getTypePropertyMap(next, propMap, typePropertyMap, basedOnName, basedOnNamedProps);
            }
            if (props != null) {
                propMap.putAll(props);
            }
            if (!propMap.containsKey((Object)TypeMetadata.Attribute.BASE_TYPE)) {
                propMap.put(TypeMetadata.Attribute.BASE_TYPE, typeName);
            }
        } else {
            TypeMetadata typeMetadata;
            TypeMetadata typeMetadata2 = typeMetadata = next != null ? next.getTypeMetadata(typeName) : null;
            if (typeMetadata != null) {
                typeMetadata.export(propMap);
            }
        }
        propMap.put(TypeMetadata.Attribute.DATA_TYPE, typeName);
    }

    @Override
    public DataType getDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        DataType datatype = null;
        TypeMetadata expandedTypeMetadata = this.expandTypeMetadata(typeMetadata);
        if (expandedTypeMetadata == null) {
            if (this.next != null) {
                return this.next.getDataType(context, typeMetadata);
            }
        } else {
            Class<? extends DataType> dataTypeClass = this.getDataTypeClass(expandedTypeMetadata);
            if (dataTypeClass != null) {
                try {
                    Constructor<? extends DataType> constr = dataTypeClass.getDeclaredConstructor(DataTypeContext.class, TypeMetadata.class);
                    constr.setAccessible(true);
                    datatype = constr.newInstance(context, expandedTypeMetadata);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        return datatype == null ? new UnsupportedDataTypeImpl(context, typeMetadata) : datatype;
    }

    protected TypeMetadata filterExpandedTypeMetadata(TypeMetadata expandedTypeMetadata, TypeMetadata typeMetadata) {
        return this.customFilterExpandedTypeMetadata(expandedTypeMetadata, typeMetadata);
    }

    protected TypeMetadata customFilterExpandedTypeMetadata(TypeMetadata expandedTypeMetadata, TypeMetadata typeMetadata) {
        if (expandedTypeMetadata != null) {
            String implDataType;
            String expandedImplDataType = expandedTypeMetadata.get_impl_data_type();
            if (!(typeMetadata == null || (implDataType = typeMetadata.get_impl_data_type()) == null || expandedImplDataType != null && expandedImplDataType.equals(implDataType))) {
                return null;
            }
            if (!this.customSupportedType(expandedTypeMetadata)) {
                return null;
            }
        }
        return expandedTypeMetadata;
    }

    protected Class<? extends DataType> getDataTypeClass(TypeMetadata typeMetadata) {
        return typeMetadata.get_impl_class();
    }

    protected String getDataTypeName(TypeMetadata typeMetadata) {
        return typeMetadata.get_data_type();
    }

    protected boolean customSupportedType(TypeMetadata typeMetadata) {
        return this.customImplementedType(typeMetadata);
    }

    protected boolean customImplementedType(TypeMetadata typeMetadata) {
        return this.getDataTypeClass(typeMetadata) != null;
    }

    @Override
    public final Set<String> getSupportedTypes() {
        TreeSet<String> chainTypes = this.next != null ? this.next.getSupportedTypes() : new TreeSet();
        for (Map.Entry<String, TypeMetadata> entry : this.typeNameMetadataMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getKey().contains("(") || !this.customImplementedType(entry.getValue())) continue;
            chainTypes.add(entry.getKey());
        }
        return chainTypes;
    }

    @Override
    public final Set<Integer> getSupportedSQLTypes() {
        TreeSet<Integer> chainTypes = this.next != null ? this.next.getSupportedSQLTypes() : new TreeSet();
        for (Map.Entry<Integer, TypeMetadata> entry : this.typeCodeMetadataMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || this.customImplementedType(entry.getValue())) continue;
            chainTypes.add(entry.getKey());
        }
        return chainTypes;
    }

    @Override
    public final Map<String, TypeMetadata> getSupportedTypeMetadata() {
        HashMap<String, TypeMetadata> chainTypeMetadata = this.next != null ? this.next.getSupportedTypeMetadata() : new HashMap();
        for (Map.Entry<String, TypeMetadata> entry : this.typeNameMetadataMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getKey().contains("(") || !this.customImplementedType(entry.getValue())) continue;
            chainTypeMetadata.put(entry.getKey(), entry.getValue());
        }
        return chainTypeMetadata;
    }

    protected TypeMetadata expandTypeMetadata(TypeMetadata typeMetadata) {
        TypeMetadata expandedTypeMetadata = null;
        TypeMetadata template = null;
        Integer typeCode = typeMetadata.get_type_code();
        if (typeMetadata.get_data_type() != null && (template = this.typeNameMetadataMap.get(typeMetadata.get_data_type())) != null && typeCode != null && !typeCode.equals(template.get_type_code())) {
            template = null;
        }
        if (template == null && typeMetadata.get_base_type() != null && (template = this.typeNameMetadataMap.get(typeMetadata.get_base_type())) != null && typeCode != null && !typeCode.equals(template.get_type_code())) {
            template = null;
        }
        if (template == null && typeCode != null) {
            template = this.typeCodeMetadataMap.get(typeCode);
        }
        if (template != null) {
            expandedTypeMetadata = this.filterExpandedTypeMetadata(DataTypeFactory.getTypeMetadata(template, typeMetadata), typeMetadata);
        }
        if (expandedTypeMetadata != null) {
            HashMap<TypeMetadata.Attribute, Object> attributes = new HashMap<TypeMetadata.Attribute, Object>();
            this.expandDataTypeAttributes(expandedTypeMetadata, attributes);
            if (attributes.size() > 0) {
                expandedTypeMetadata = DataTypeFactory.getTypeMetadata(template, attributes);
            }
        }
        return expandedTypeMetadata;
    }

    protected void expandDataTypeAttributes(TypeMetadata typeMetadata, Map<TypeMetadata.Attribute, Object> attributeMap) {
        String datatype = typeMetadata.get_data_type();
        if (datatype != null && (datatype.contains(".") || datatype.contains("@")) && typeMetadata.get_type_owner() == null && typeMetadata.get_type_name() == null && typeMetadata.get_type_subname() == null && typeMetadata.get_type_link() == null) {
            String[] locations = datatype.split("[@]");
            String[] ids = locations[0].split("[.]");
            if (ids.length == 2) {
                attributeMap.put(TypeMetadata.Attribute.TYPE_OWNER, ids[0]);
                attributeMap.put(TypeMetadata.Attribute.TYPE_NAME, ids[1]);
            } else if (ids.length == 3) {
                attributeMap.put(TypeMetadata.Attribute.TYPE_OWNER, ids[0]);
                attributeMap.put(TypeMetadata.Attribute.TYPE_NAME, ids[1]);
                attributeMap.put(TypeMetadata.Attribute.TYPE_SUBNAME, ids[2]);
            }
            if (locations.length == 2) {
                attributeMap.put(TypeMetadata.Attribute.TYPE_LINK, locations[1]);
                if (ids.length == 1) {
                    attributeMap.put(TypeMetadata.Attribute.TYPE_NAME, ids[0]);
                }
            }
            if (attributeMap.size() != 0 && attributeMap.get((Object)TypeMetadata.Attribute.DATA_TYPE) == null) {
                attributeMap.put(TypeMetadata.Attribute.DATA_TYPE, datatype);
            }
        }
    }

    @Override
    public final TypeMetadata getTypeMetadata(String datatype) {
        TypeMetadata typeMetaData = this.customTypeMetadata(datatype);
        return typeMetaData == null && this.next != null ? this.next.getTypeMetadata(datatype) : typeMetaData;
    }

    protected TypeMetadata customTypeMetadata(String datatype) {
        return this.typeNameMetadataMap.get(datatype);
    }

    @Override
    public final TypeMetadata getTypeMetadata(Integer oracleType) {
        TypeMetadata typeMetaData = this.customTypeMetadata(oracleType);
        return typeMetaData == null && this.next != null ? this.next.getTypeMetadata(oracleType) : typeMetaData;
    }

    protected TypeMetadata customTypeMetadata(Integer oracleType) {
        return this.typeCodeMetadataMap.get(oracleType);
    }
}

