/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.AbstractDataTypeFactoryImpl;
import oracle.dbtools.raptor.datatypes.impl.BindContextImpl;
import oracle.dbtools.raptor.datatypes.impl.DataParameterImpl;
import oracle.dbtools.raptor.datatypes.impl.DataTypeConnectionProviderImpl;
import oracle.dbtools.raptor.datatypes.impl.DataVariableImpl;
import oracle.dbtools.raptor.datatypes.oracle.plsql.OraclePLSQLDataTypeFactory;
import oracle.dbtools.raptor.datatypes.oracle.sql.OracleSQLDataTypeFactory;
import oracle.jdbc.OracleConnection;

public class DataTypeFactory {
    private static DataTypeFactory instance = null;
    private DataTypeProvider unsupportedDataProvider = null;
    private DataTypeProvider nativeJDBCProviderChain = null;
    private DataTypeProvider oracleProviderChain = null;
    private DataTypeProvider allProviderChain = null;
    private Map<Connection, SoftReference<DataTypeConnectionProvider>> connectionProviderCache = new WeakHashMap<Connection, SoftReference<DataTypeConnectionProvider>>();
    private Map<DataTypeConnectionProvider, SoftReference<DataTypeContext>> contextCache = new WeakHashMap<DataTypeConnectionProvider, SoftReference<DataTypeContext>>();
    private Map<DataTypeContext, Map<TypeMetadata, SoftReference<DataType>>> dataTypeCache = new WeakHashMap<DataTypeContext, Map<TypeMetadata, SoftReference<DataType>>>();
    private int creates = 0;
    private int frees = 0;
    private int reuses = 0;
    private Timer timer;

    protected DataTypeFactory() {
    }

    public static synchronized DataTypeFactory getInstance() {
        if (instance == null) {
            instance = new DataTypeFactory();
        }
        return instance;
    }

    public DataType getDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        return this.makeDataType(context, typeMetadata);
    }

    public DataType getDataType(DataTypeConnectionProvider connectionProvider, TypeMetadata typeMetadata) {
        return this.getDataType(this.getDataTypeContext(connectionProvider), typeMetadata);
    }

    public DataType getDataType(Connection connection, TypeMetadata typeMetadata) {
        return this.getDataType(this.getDataTypeConnectionProvider(connection), typeMetadata);
    }

    public boolean isSupportedType(DataTypeConnectionProvider connectionProvider, TypeMetadata typeMetadata) {
        try {
            DataType datatype = this.getDataType(connectionProvider, typeMetadata);
            return datatype != null && datatype.isSupported();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public <P extends DataBinding> boolean isSupportedBinding(BindContext context, P param) {
        try {
            DataType datatype = param.getDataType();
            CallableBinding<P> binding = datatype.getBind(context, param);
            return binding.isSupported(param.getMode());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public boolean isSupportedType(Connection connection, TypeMetadata typeMetadata) {
        return this.isSupportedType(this.getDataTypeConnectionProvider(connection), typeMetadata);
    }

    public boolean isSupportedType(DataTypeConnectionProvider connectionProvider, Integer oracleType) {
        try {
            TypeMetadata typeMetadata = this.getTypeMetadata(connectionProvider, oracleType);
            return this.isSupportedType(connectionProvider, typeMetadata);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public boolean isSupportedType(Connection connection, Integer oracleType) {
        return this.isSupportedType(this.getDataTypeConnectionProvider(connection), oracleType);
    }

    public Set<String> getSupportedTypes(Class<? extends Connection> connectionClass) {
        return this.getProviderChain(connectionClass).getSupportedTypes();
    }

    public Set<String> getSupportedTypes(DataTypeConnectionProvider connectionProvider) {
        return this.getSupportedTypes(connectionProvider.getDataTypeConnnectionClass());
    }

    public Set<String> getSupportedTypes(Connection connection) {
        return this.getSupportedTypes(connection.getClass());
    }

    public Set<Integer> getSupportedSQLTypes(Class<? extends Connection> connectionClass) {
        return this.getProviderChain(connectionClass).getSupportedSQLTypes();
    }

    public Set<Integer> getSupportedSQLTypes(DataTypeConnectionProvider connectionProvider) {
        return this.getSupportedSQLTypes(connectionProvider.getDataTypeConnnectionClass());
    }

    public Set<Integer> getSupportedSQLTypes(Connection connection) {
        return this.getSupportedSQLTypes(connection.getClass());
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(Class<? extends Connection> connectionClass) {
        return this.getProviderChain(connectionClass).getSupportedTypeMetadata();
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(DataTypeConnectionProvider connectionProvider) {
        return this.getSupportedTypeMetadata(connectionProvider.getDataTypeConnnectionClass());
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(Connection connection) {
        return this.getSupportedTypeMetadata(connection.getClass());
    }

    public Set<String> getAllSupportedTypes() {
        return this.getAllProviderChain().getSupportedTypes();
    }

    public Set<Integer> getAllSupportedSQLTypes() {
        return this.getAllProviderChain().getSupportedSQLTypes();
    }

    public TypeMetadata getTypeMetadata(Map<TypeMetadata.Attribute, Object> attributes) {
        return new TypeMetadata(attributes);
    }

    public static TypeMetadata getTypeMetadata(Map<TypeMetadata.Attribute, Object> attributes, boolean syntaxSynonym) {
        return new TypeMetadata(attributes, syntaxSynonym);
    }

    public static TypeMetadata getTypeMetadata(TypeMetadata source, Map<TypeMetadata.Attribute, Object> attributes) {
        return TypeMetadata.overideTypeMetadata(source, attributes);
    }

    public static TypeMetadata getTypeMetadata(TypeMetadata source, TypeMetadata source2) {
        return TypeMetadata.overideTypeMetadata(source, source2);
    }

    public TypeMetadata getTypeMetadata(DataTypeConnectionProvider connectionProvider, Integer oracleType) {
        return this.getProviderChain(connectionProvider).getTypeMetadata(oracleType);
    }

    public TypeMetadata getTypeMetadata(Connection connection, Integer oracleType) {
        return this.getTypeMetadata(this.getDataTypeConnectionProvider(connection), oracleType);
    }

    public TypeMetadata getTypeMetadata(DataTypeConnectionProvider connectionProvider, String typeName) {
        return this.getProviderChain(connectionProvider).getTypeMetadata(typeName);
    }

    public TypeMetadata getTypeMetadata(Connection connection, String typeName) {
        return this.getTypeMetadata(this.getDataTypeConnectionProvider(connection), typeName);
    }

    public TypeMetadata getTypeMetadata(ResultSetMetaData resultSetMetadata, int column) {
        try {
            int typeCode = resultSetMetadata.getColumnType(column);
            String datatype = resultSetMetadata.getColumnTypeName(column);
            int precision = resultSetMetadata.getPrecision(column);
            int scale = resultSetMetadata.getScale(column);
            return this.getTypeMetadata(typeCode, datatype, precision != 0 ? Integer.valueOf(precision) : null, precision != 0 ? Integer.valueOf(scale) : null);
        }
        catch (SQLException e) {
            throw new DataTypeSQLException(e);
        }
    }

    public TypeMetadata getTypeMetadata(Integer oracleType, String typeName, Integer precision, Integer scale) {
        return new TypeMetadata(oracleType, typeName, precision, scale);
    }

    public TypeMetadata getTypeMetadata(Integer oracleType, String typeName) {
        return new TypeMetadata(oracleType, typeName, null, null);
    }

    public DataVariable getDataVariable(String name, DataType dataType, BindingMode mode) {
        return new DataVariableImpl(name, dataType, mode);
    }

    public DataParameter getDataParameter(String name, DataType dataType, BindingMode mode) {
        return new DataParameterImpl(name, dataType, mode);
    }

    public BindContext getBindContext(DataTypeConnectionProvider connectionProvider) {
        return new BindContextImpl(connectionProvider);
    }

    public BindContext getBindContext(Connection connection) {
        return this.getBindContext(this.getDataTypeConnectionProvider(connection));
    }

    private DataTypeContext getDataTypeContext(DataTypeConnectionProvider connectionProvider) {
        return this.makeDataTypeContext(connectionProvider);
    }

    private DataTypeConnectionProvider getDataTypeConnectionProvider(Connection connection) {
        return this.makeDataTypeConnectionProvider(connection);
    }

    private synchronized DataTypeConnectionProvider makeDataTypeConnectionProvider(Connection connection) {
        DataTypeConnectionProvider connectionProvider;
        SoftReference<DataTypeConnectionProvider> ref = this.connectionProviderCache.get(connection);
        DataTypeConnectionProvider dataTypeConnectionProvider = connectionProvider = ref != null ? ref.get() : null;
        if (connectionProvider == null) {
            connectionProvider = this.buildDataTypeConnectionProvider(connection);
            this.connectionProviderCache.put(connection, new SoftReference<DataTypeConnectionProvider>(connectionProvider));
            ++this.creates;
        } else {
            ++this.reuses;
        }
        return connectionProvider;
    }

    protected DataTypeConnectionProvider buildDataTypeConnectionProvider(Connection connection) {
        if (connection == null) {
            return new DataTypeConnectionProviderImpl<Class<Connection>>(Connection.class);
        }
        return new DataTypeConnectionProviderImpl<Connection>(connection);
    }

    private synchronized DataTypeContext makeDataTypeContext(DataTypeConnectionProvider connectionProvider) {
        DataTypeContext context;
        SoftReference<DataTypeContext> ref = this.contextCache.get(connectionProvider);
        DataTypeContext dataTypeContext = context = ref != null ? ref.get() : null;
        if (context == null) {
            context = this.builDataTypeContext(connectionProvider);
            this.contextCache.put(connectionProvider, new SoftReference<DataTypeContext>(context));
            ++this.creates;
        } else {
            ++this.reuses;
        }
        return context;
    }

    protected DataTypeContext builDataTypeContext(DataTypeConnectionProvider connectionProvider) {
        return new DataTypeContext(this, connectionProvider);
    }

    private synchronized DataType makeDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        DataType datatype = this.lookupDataType(context, typeMetadata);
        if (datatype == null) {
            datatype = this.cacheDataType(context, typeMetadata, this.getProviderChain(context.getDataTypeConnectionProvider()).getDataType(context, typeMetadata));
        } else {
            ++this.reuses;
        }
        return datatype;
    }

    private synchronized DataType lookupDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        DataType datatype = null;
        Map<TypeMetadata, SoftReference<DataType>> datatypeMap = this.dataTypeCache.get(context);
        if (datatypeMap != null) {
            SoftReference<DataType> ref = datatypeMap.get(typeMetadata);
            datatype = ref != null ? ref.get() : null;
        }
        return datatype;
    }

    private synchronized DataType cacheDataType(DataTypeContext context, TypeMetadata typeMetadata, DataType datatype) {
        if (datatype != null) {
            Map<TypeMetadata, SoftReference<DataType>> datatypeMap = this.dataTypeCache.get(context);
            if (datatypeMap == null) {
                datatypeMap = new WeakHashMap<TypeMetadata, SoftReference<DataType>>();
                this.dataTypeCache.put(context, datatypeMap);
                ++this.creates;
            }
            datatypeMap.put(typeMetadata, new SoftReference<DataType>(datatype));
            ++this.creates;
        }
        return datatype;
    }

    private synchronized void doCleanupCache() {
        Iterator<Map.Entry<DataTypeContext, Map<TypeMetadata, SoftReference<DataType>>>> dataTypeCacheIter = this.dataTypeCache.entrySet().iterator();
        while (dataTypeCacheIter.hasNext()) {
            Map.Entry<DataTypeContext, Map<TypeMetadata, SoftReference<DataType>>> dataTypeCacheEntry = dataTypeCacheIter.next();
            if (dataTypeCacheEntry.getValue() == null || dataTypeCacheEntry.getValue().isEmpty()) {
                dataTypeCacheIter.remove();
                ++this.frees;
                continue;
            }
            Iterator<Map.Entry<TypeMetadata, SoftReference<DataType>>> dataTypeMapIter = dataTypeCacheEntry.getValue().entrySet().iterator();
            while (dataTypeMapIter.hasNext()) {
                Map.Entry<TypeMetadata, SoftReference<DataType>> dataTypeMapEntry = dataTypeMapIter.next();
                if (dataTypeMapEntry.getValue() != null && dataTypeMapEntry.getValue().get() != null) continue;
                dataTypeMapIter.remove();
                ++this.frees;
            }
            if (!dataTypeCacheEntry.getValue().isEmpty()) continue;
            dataTypeCacheIter.remove();
            ++this.frees;
        }
        Iterator<Map.Entry<DataTypeConnectionProvider, SoftReference<DataTypeContext>>> contextCacheIter = this.contextCache.entrySet().iterator();
        while (contextCacheIter.hasNext()) {
            Map.Entry<DataTypeConnectionProvider, SoftReference<DataTypeContext>> contextMapEntry = contextCacheIter.next();
            if (contextMapEntry.getValue() != null && contextMapEntry.getValue().get() != null) continue;
            contextCacheIter.remove();
            ++this.frees;
        }
        Iterator<Map.Entry<Connection, SoftReference<DataTypeConnectionProvider>>> connectionProviderCacheIter = this.connectionProviderCache.entrySet().iterator();
        while (connectionProviderCacheIter.hasNext()) {
            Map.Entry<Connection, SoftReference<DataTypeConnectionProvider>> connectionProviderMapEntry = connectionProviderCacheIter.next();
            if (connectionProviderMapEntry.getValue() != null && connectionProviderMapEntry.getValue().get() != null) continue;
            connectionProviderCacheIter.remove();
            ++this.frees;
        }
    }

    private DataTypeProvider getProviderChain(Class<? extends Connection> connectionClass) {
        if (OracleConnection.class.isAssignableFrom(connectionClass) || connectionClass.getPackage().equals(Package.getPackage("oracle.dbtools.jdbc"))) {
            return this.getOracleProviderChain();
        }
        if (Connection.class.isAssignableFrom(connectionClass)) {
            return this.getNativeJDBCProviderChain();
        }
        return this.getUnsupportedDataProvider();
    }

    private DataTypeProvider getProviderChain(DataTypeConnectionProvider connectionProvider) {
        return this.getProviderChain(connectionProvider.getDataTypeConnnectionClass());
    }

    private DataTypeProvider getUnsupportedDataProvider() {
        if (this.unsupportedDataProvider == null) {
            this.unsupportedDataProvider = new UnsupportedDataProvider(null);
        }
        return this.unsupportedDataProvider;
    }

    private DataTypeProvider getNativeJDBCProviderChain() {
        if (this.nativeJDBCProviderChain == null) {
            this.nativeJDBCProviderChain = this.getUnsupportedDataProvider();
        }
        return this.nativeJDBCProviderChain;
    }

    private DataTypeProvider getOracleProviderChain() {
        if (this.oracleProviderChain == null) {
            this.oracleProviderChain = new OraclePLSQLDataTypeFactory(new OracleSQLDataTypeFactory(this.getNativeJDBCProviderChain()));
        }
        return this.oracleProviderChain;
    }

    private DataTypeProvider getAllProviderChain() {
        if (this.allProviderChain == null) {
            this.allProviderChain = this.getOracleProviderChain();
        }
        return this.allProviderChain;
    }

    private class UnsupportedDataProvider
    extends AbstractDataTypeFactoryImpl {
        protected UnsupportedDataProvider(DataTypeProvider next) {
            super(next, new HashMap<String, NamedValue<Map<TypeMetadata.Attribute, Object>>>());
        }
    }
}

