/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql.doc;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.Substr;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Service;

public class HarvestDoc {
    private static StringBuilder plsqlTest = new StringBuilder("/* test generated from doc website */\n");
    private static StringBuilder sqlTest = new StringBuilder("/* test generated from doc website */\n");
    private static int testNo = 0;
    private static Set<String> processed = new HashSet<String>();
    private static final String fname = "templates.serial";
    private static final String fname1 = "frequencies.serial";
    private static final String fname2 = "railroad.serial";
    static final String path = "/oracle/dbtools/parser/plsql/doc/";
    private static Map<Long, Set<Substr>> templates = new HashMap<Long, Set<Substr>>();
    private static Map<Long, Integer> frequencies = null;
    private static Map<Integer, DocURL> railroads = new HashMap<Integer, DocURL>();

    public static void main(String[] args) throws Exception {
        HarvestDoc.crawlDocWebsite(DocURL.Manual.PLSQL);
        HarvestDoc.crawlDocWebsite(DocURL.Manual.SQL);
        for (long s : templates.keySet()) {
            int parent = Service.lY(s);
            int child = Service.lX(s);
            if (parent < 0) {
                System.err.println("parent<0 (" + parent + ")");
                continue;
            }
            if (SqlEarley.getInstance().allSymbols.length - 1 < parent) {
                System.err.println("len<parent (" + parent + ")");
                continue;
            }
            if (child < 0) {
                System.err.println("child<0 (" + child + ")");
                continue;
            }
            if (SqlEarley.getInstance().allSymbols.length - 1 < child) {
                System.err.println("len<child (" + child + ")");
                continue;
            }
            System.out.println(SqlEarley.getInstance().allSymbols[parent] + "->" + SqlEarley.getInstance().allSymbols[child] + "=" + templates.get(s).size());
        }
        FileOutputStream fos = new FileOutputStream("common/src/oracle/dbtools/parser/plsql/doc/templates.serial");
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(templates);
        out.close();
        fos = new FileOutputStream("common/src/oracle/dbtools/parser/plsql/doc/frequencies.serial");
        out = new ObjectOutputStream(fos);
        out.writeObject(frequencies);
        out.close();
        fos = new FileOutputStream("common/src/oracle/dbtools/parser/plsql/doc/railroad.serial");
        out = new ObjectOutputStream(fos);
        out.writeObject(railroads);
        out.close();
    }

    private static void crawlDocWebsite(DocURL.Manual man) {
        String input;
        block9: {
            testNo = 0;
            processed = new HashSet<String>();
            input = null;
            try {
                String masterBNFurl = man.getBasePrivateURL() + "index.htm";
                input = HarvestDoc.readURL(masterBNFurl);
            }
            catch (FileNotFoundException e) {
                System.err.println("\nFileNotFoundException " + e.getMessage());
                System.exit(0);
            }
            catch (Exception e) {
                if (!e.getClass().getPackage().getName().contains("java.net")) break block9;
                System.err.println("Failed to connect to " + e.getMessage());
                System.exit(0);
            }
        }
        String pre = "<a href=\"";
        String post = "\">";
        int iPre = input.indexOf(pre);
        while (iPre > 0) {
            int iPost = input.indexOf(post, iPre + pre.length());
            String url = input.substring(iPre + pre.length(), iPost);
            if (!url.startsWith("http://") && !url.startsWith("..")) {
                try {
                    int index = url.indexOf(35);
                    if (index != 0) {
                        String page = url;
                        if (index > 0) {
                            page = page.substring(0, index);
                        }
                        HarvestDoc.processDoc(man, page);
                    }
                }
                catch (Exception e) {
                    System.err.println(url + " " + e.getMessage() + " ");
                }
            }
            iPre = input.indexOf(pre, iPre + pre.length());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void processDoc(DocURL.Manual man, String page) throws FileNotFoundException, IOException {
        block24: {
            test = DocURL.Manual.SQL.equals(man) != false ? HarvestDoc.sqlTest : HarvestDoc.plsqlTest;
            input = null;
            earley = SqlEarley.getInstance();
            try {
                fullUrl = man.getBasePrivateURL() + page;
                if (HarvestDoc.processed.contains(fullUrl)) {
                    return;
                }
                HarvestDoc.processed.add(fullUrl);
                input = HarvestDoc.readURL(fullUrl);
            }
            catch (FileNotFoundException e) {
                System.err.println("\nFileNotFoundException " + e.getMessage());
                System.exit(0);
            }
            catch (Exception e) {
                if (!e.getClass().getPackage().getName().contains("java.net")) break block24;
                System.err.println("URL=" + page);
                System.err.println("Failed to connect to " + e.getMessage());
                System.exit(0);
            }
        }
        pre1 = "<p class=\"subhead2\"><a id=\"";
        post1 = "\"";
        pre2 = "<span class=\"italic\">";
        post2 = "::=";
        iPre1 = input.indexOf(pre1);
        while (iPre1 > 0) {
            iPost1 = input.indexOf(post1, iPre1 + pre1.length());
            id = input.substring(iPre1 + pre1.length(), iPost1);
            iPre2 = input.indexOf(pre2, iPost1);
            iPost2 = input.indexOf(post2, iPre2 + pre2.length());
            if (iPost2 >= 0 && 60 >= (symbol = input.substring(iPre2 + pre2.length(), iPost2)).length() && (iSpan = symbol.indexOf("</span>")) >= 0 && (s = (Integer)SqlEarley.getInstance().symbolIndexes.get(symbol = symbol.substring(0, iSpan))) != null) {
                HarvestDoc.railroads.put(s, new DocURL(man, page + "#" + id));
            }
            iPre1 = input.indexOf(pre1, iPre1 + pre1.length());
        }
        pre = "<pre xml:space=\"preserve\" class=\"oac_no_warn\">";
        post = "</pre>";
        iPre = input.indexOf(pre);
        while (iPre > 0) {
            block25: {
                block45: {
                    block44: {
                        block32: {
                            block43: {
                                block42: {
                                    block41: {
                                        block40: {
                                            block39: {
                                                block38: {
                                                    block37: {
                                                        block36: {
                                                            block35: {
                                                                block34: {
                                                                    block33: {
                                                                        block30: {
                                                                            block31: {
                                                                                block29: {
                                                                                    block28: {
                                                                                        block27: {
                                                                                            block26: {
                                                                                                iPost = input.indexOf(post, iPre + pre.length());
                                                                                                code = input.substring(iPre + pre.length(), iPost);
                                                                                                code = code.replace("&gt;", ">");
                                                                                                code = code.replace("&lt;", "<");
                                                                                                code = code.replace("<span class=\"italic\">", "");
                                                                                                code = code.replace("<span class=\"bold\">", "");
                                                                                                code = code.replace("</span>", "");
                                                                                                code = code.replace("Call completed.", "");
                                                                                                code = code.replace("1 row created.", "");
                                                                                                code = code.replace("1 row updated.", "");
                                                                                                code = code.replace("Commit complete.", "");
                                                                                                code = code.replace("Enter password: password", "");
                                                                                                code = code.replace("C    F_RATIO    P_VALUE", "");
                                                                                                code = code.replace("- ---------- ----------", "");
                                                                                                code = code.replace("F 5.59536943 4.7840E-09", "");
                                                                                                code = code.replace("M  9.2865001 6.7139E-17", "");
                                                                                                code = code.replace("CAST(POWERMULTISET_BY_CARDINALITY(CUST_ADDRESS_NTAB,2) AS CUST_ADDRESS_TAB_TAB_TYP)", "");
                                                                                                code = code.replace("YP)", "");
                                                                                                code = code.replace("LASVALUE(quantity", "LAST_VALUE(quantity");
                                                                                                code = code.replace("CREATE INDEX index ON table", "CREATE INDEX index ON tbl");
                                                                                                code = code.replace("ALTER TABLE table", "ALTER TABLE tbl");
                                                                                                code = code.replace("operator t_alias2.column", "= t_alias2.column");
                                                                                                code = code.replace("WHERE expr operator", "WHERE expr IN");
                                                                                                code = code.replace("WHERE column operator", "WHERE column IN");
                                                                                                code = code.replace("       salary + NVL(commission_pct, 0),", "      , salary + NVL(commission_pct, 0),");
                                                                                                code = code.replace("employee_id                              -- and employee id.", ",employee_id                              -- and employee id.");
                                                                                                code = code.replace("<span class=\"codeinlineitalic\"", "<span class=dqt codeinlineitalic dqt");
                                                                                                code = code.replace(". . .", "i integer);");
                                                                                                code = code.replace("Grant succeeded.", "");
                                                                                                code = code.replace("User altered.", "");
                                                                                                code = code.replace("Session altered.", "");
                                                                                                code = code.replace("View created.", "");
                                                                                                code = code.replace("View dropped.", "");
                                                                                                code = code.replace("5 rows updated.", "");
                                                                                                code = code.replace("CAST(POWERMULTISET(CUST_ADDRESS_NTAB) AS CUST_ADDRESS_TAB_TAB_T", "");
                                                                                                code = code.replace("no rows selected", "");
                                                                                                begin = 0;
                                                                                                if (10000 < iPre) {
                                                                                                    begin = iPre - 10000;
                                                                                                }
                                                                                                priorChunk = input.substring(begin, iPre);
                                                                                                paragraphPre = "<a id=\"";
                                                                                                iParagraph = priorChunk.lastIndexOf(paragraphPre);
                                                                                                pageParagraph = page;
                                                                                                if (0 <= iParagraph) {
                                                                                                    iEndOfPar = priorChunk.indexOf(34, iParagraph + paragraphPre.length());
                                                                                                    pageParagraph = pageParagraph + "#" + priorChunk.substring(iParagraph + paragraphPre.length(), iEndOfPar);
                                                                                                }
                                                                                                if (code.charAt(0) == '\n') {
                                                                                                    code = code.substring(1);
                                                                                                }
                                                                                                if (code.startsWith("WITH") && code.contains("reports_to_101 (eid, emp_last, mgr_id, reportLevel) AS")) {
                                                                                                    System.out.println("with--->" + code);
                                                                                                }
                                                                                                if (3 < (dash3index = code.indexOf("---")) && code.charAt(dash3index - 1) == ' ') {
                                                                                                    --dash3index;
                                                                                                }
                                                                                                if (2 >= dash3index || code.charAt(dash3index - 1) != '\n') break block26;
                                                                                                lastNewLineIndex = (code = code.substring(0, dash3index)).lastIndexOf("\n");
                                                                                                if (lastNewLineIndex < 1 || (lastNewLineIndex = (code = code.substring(0, lastNewLineIndex)).lastIndexOf("\n")) < 1) break block25;
                                                                                                code = code.substring(0, lastNewLineIndex);
                                                                                            }
                                                                                            if (code.toUpperCase().startsWith("EXECUTE IMMEDIATE ")) {
                                                                                                if (!code.trim().endsWith(";")) {
                                                                                                    code = code + ";";
                                                                                                }
                                                                                                code = "begin\n" + code + "\n end; \n";
                                                                                            }
                                                                                            if (code.toUpperCase().startsWith("TYPE ")) {
                                                                                                code = "declare " + code + "\n begin null; end; \n";
                                                                                            }
                                                                                            if (0 > code.indexOf("version=\"1.0\"")) break block27;
                                                                                            test.append("--version=\"1.0\" ; skipped \n\n");
                                                                                            break block25;
                                                                                        }
                                                                                        if (!"controlstatements.htm#LNPLS431".equals(pageParagraph)) break block28;
                                                                                        test.append("/*controlstatements.htm#LNPLS431 ; skipped*/ \n\n");
                                                                                        break block25;
                                                                                    }
                                                                                    if (0 > code.indexOf("ORA-")) break block29;
                                                                                    test.append("/*ORA- ; skipped*/ \n\n");
                                                                                    break block25;
                                                                                }
                                                                                if (0 > code.indexOf("...")) break block30;
                                                                                if (code.length() >= 300) break block31;
                                                                                test.append("/*incomplete ... ; skipped*/ \n\n");
                                                                                break block25;
                                                                            }
                                                                            code = code.replace("...", "/*...*/");
                                                                            break block32;
                                                                        }
                                                                        if (0 > code.indexOf("ORACLE exception")) break block33;
                                                                        test.append("/*ORACLE exception ; skipped*/ \n\n");
                                                                        break block25;
                                                                    }
                                                                    if (0 > code.indexOf("PL/SQL procedure successfully completed")) break block34;
                                                                    test.append("/*PL/SQL procedure successfully completed <-- skipped*/ \n\n");
                                                                    break block25;
                                                                }
                                                                if (0 > code.indexOf("SQL>")) break block35;
                                                                test.append("/*SQL>  ; skipped*/ \n\n");
                                                                break block25;
                                                            }
                                                            if (0 > code.indexOf("field_name")) break block36;
                                                            test.append("/*  field_name    ; skipped*/ \n\n");
                                                            break block25;
                                                        }
                                                        if (0 > code.indexOf("WHEN condition_n THEN statements_n")) break block37;
                                                        test.append("/*  WHEN condition_n THEN statements_n    ; skipped*/ \n\n");
                                                        break block25;
                                                    }
                                                    if (0 > code.indexOf("------------------------------------------------------------------------")) break block38;
                                                    test.append("/*  ------------------------------------------------------------------------  ; skipped*/ \n\n");
                                                    break block25;
                                                }
                                                if (0 > code.indexOf("\"sthref809\"")) break block39;
                                                test.append("/*  \"sthref809\"    ; skipped*/ \n\n");
                                                break block25;
                                            }
                                            if (0 > code.indexOf("<<end_loop>>")) break block40;
                                            test.append("/*  <<end_loop>>    ; skipped*/ \n\n");
                                            break block25;
                                        }
                                        if (0 > code.indexOf("hr.tb1.col1.x")) break block41;
                                        test.append("/*  hr.tb1.col1.x    ; skipped*/ \n\n");
                                        break block25;
                                    }
                                    if (0 > code.indexOf("We expect this THEN to always be performed")) break block42;
                                    test.append("/*  We expect this THEN to always be performed    ; skipped*/ \n\n");
                                    break block25;
                                }
                                if (0 != code.indexOf("Cursor is closed")) break block43;
                                test.append("/*  Cursor is closed...    ; skipped*/ \n\n");
                                break block25;
                            }
                            if (code.length() >= 30) break block32;
                            test.append("/*skipped: " + code + "*/ \n\n");
                            break block25;
                        }
                        skippedPrefixes = new String[]{"IF condition", "SUBTYPE subtype_name IS base_type", ":host_variable", "LOOP", "SUBTYPE INTEGER IS NUMBER(38,0)", "FUNCTION TO_CHAR (right DATE) RETURN VARCHAR2;", "ALTER SESSION SET NLS_DATE_FORMAT='\"'' OR service_type=''Merger\"';", "-- Second %s in \"Expected %s, found %s\":", "BEFORE", "-- Retrieve ora_sql_txt into  sql_text variable", "ALTER TRIGGER [schema.]trigger_name { ENABLE | DISABLE };", "ALTER TABLE table_name { ENABLE | DISABLE } ALL TRIGGERS;", "declare type VARCHAR2", "declare type DATE", "declare type NUMBER", "--- Original order data ---", "First", "Before", "--- Processing all results simultaneously ---", "------- Results from One Bulk Fetch --------", "EXCEPTION", "-- To save the output of the query to a file:", "Delete succeeded", "CURSOR cursor_name [", "Raise for employee", "declare TYPE type_name IS REF CURSOR [ RETURN return_type ]", "EXEC SQL", "Sum of", "<< label >> (optional)", "With first name first, email is: John.Doe@AcmeCorp", "Table updated?", "INSERT INTO TABLE (", "(SUM", "SUM((", "SELECT TO_CHAR(number, 'fmt')", "SELECT /*+ PARALLEL_INDEX(table1, index1, 3) */", "TIMESTAMP [(fractional_seconds_precision)]", "INTERVAL YEAR [(year_precision)]", "INTERVAL DAY [(day_precision)]", "SELECT CHR (196 USING NCHAR_CS)", "SELECT COMPOSE( 'o' || UNISTR(", "('CLARK' || 'SMITH')", "MIN([table.]column), MAX([table.]column)", "INTERVAL '5-3' YEAR TO MONTH + INTERVAL'20' MONTH =", "INTERVAL'20' DAY - INTERVAL'240' HOUR = INTERVAL'10-0' DAY TO SECOND", "(10, 20, 40)", ":employee_name INDICATOR :employee_name_indicator_var", "SELECT feature_id, value", "  If (CRN = FRN = RN) then the result is", "                     NULL if VAR_POP(expr2)  = 0", "   if (CRN = FRN = RN) then", "SELECT NCHR(187)", "SELECT TO_SINGLE_BYTE( CHR(15711393)) FROM DUAL;"};
                        skip = false;
                        for (String skipped : skippedPrefixes) {
                            if (!code.startsWith(skipped)) continue;
                            skipped = skipped.replace("/*", "/+");
                            skipped = skipped.replace("*/", "+/");
                            test.append("/*skipped " + skipped + " */ \n\n");
                            skip = true;
                            break;
                        }
                        if (skip) break block25;
                        skip = true;
                        src = LexerToken.parse(code);
                        matrix = new Matrix(earley);
                        earley.parse(src, matrix);
                        c01 = matrix.get(0, 1);
                        for (i = 0; i < c01.size(); ++i) {
                            pos = c01.getPosition(i);
                            if (0 >= pos) continue;
                            rule = c01.getRule(i);
                            rhs0 = earley.rules[rule].rhs[0];
                            if (earley.allSymbols[rhs0].charAt(0) != '\'') continue;
                            skip = false;
                        }
                        if (!skip) break block44;
                        test.append("/* failed scan " + code.substring(0, 20) + " */ \n\n");
                        break block25;
                    }
                    test.append("++");
                    test.append(HarvestDoc.testNo++);
                    test.append(";  /*  ");
                    test.append(pageParagraph);
                    test.append("  */\n");
                    test.append('`');
                    test.append(code);
                    test.append("`->\n");
                    root = null;
                    try {
                        root = earley.forest(src, matrix);
                    }
                    catch (AssertionError e) {
                        System.err.println("AssertionError" + e.getMessage());
                        System.err.println(code);
                        test.append("[0,0) dummy /***failed***/\n;\n\n");
                        break block25;
                    }
                    if (root != null && root.to >= 2) break block45;
                    System.err.println(code);
                    test.append("[0,0) dummy /**failed**/\n;\n\n");
                    break block25;
                }
                from = false;
                to = src.size();
                if (root.topLevel == null) ** GOTO lbl-1000
                for (ParseNode n : root.children()) {
                    if (n.from != 0) continue;
                    root = n;
                    to = root.to;
                }
                if (root.topLevel != null) {
                    System.err.println(code);
                    test.append("[0,0) dummy /*failed*/\n;\n\n");
                } else lbl-1000:
                // 2 sources

                {
                    test.append(root.tree() + "\n;\n\n");
                    System.out.println(code);
                    System.out.println("------------------------------");
                    try {
                        Substr.generateTemplate(root, src, code, HarvestDoc.templates, 0L, man, pageParagraph);
                        HarvestDoc.countFrequencies(root);
                    }
                    catch (Exception e) {
                        System.err.println(page + " --> " + e.getMessage());
                    }
                }
            }
            iPre = input.indexOf(pre, iPre + pre.length());
        }
    }

    public static Map<Long, Set<Substr>> getTemplates() {
        if (templates.size() == 0) {
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/templates.serial");
            try {
                InputStream is = u.openStream();
                ObjectInputStream in = new ObjectInputStream(is);
                templates = (Map)in.readObject();
                in.close();
            }
            catch (Exception e) {
                Logger.severe(HarvestDoc.class, "Failed to read templates: " + e.getMessage());
            }
        }
        return templates;
    }

    private static void countFrequencies(ParseNode root) {
        if (frequencies == null) {
            frequencies = new HashMap<Long, Integer>();
        }
        for (ParseNode descendant : root.descendants()) {
            ParseNode parent = descendant.parent();
            if (parent != null) {
                for (int i : descendant.content()) {
                    for (int j : parent.content()) {
                        long key = Service.lPair(i, j);
                        Integer frequency = frequencies.get(key);
                        if (frequency == null) {
                            frequency = 0;
                        }
                        frequencies.put(key, frequency + 1);
                    }
                }
                for (int c : descendant.content()) {
                    block4: for (int p : descendant.content()) {
                        if (c == p) continue;
                        for (Earley.Tuple t : SqlEarley.getInstance().rules) {
                            if (t.head != p || t.rhs.length != 1 || t.rhs[0] != c) continue;
                            long key = Service.lPair(c, p);
                            Integer frequency = frequencies.get(key);
                            if (frequency == null) {
                                frequency = 0;
                            }
                            frequencies.put(key, frequency + 1);
                            continue block4;
                        }
                    }
                }
                continue;
            }
            for (int i : descendant.content()) {
                long key = Service.lPair(i, 0);
                Integer frequency = frequencies.get(key);
                if (frequency == null) {
                    frequency = 0;
                }
                frequencies.put(key, frequency + 1);
            }
        }
    }

    public static Map<Long, Integer> getFrequencies() {
        if (frequencies == null) {
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/frequencies.serial");
            try {
                InputStream is = u.openStream();
                ObjectInputStream in = new ObjectInputStream(is);
                frequencies = (Map)in.readObject();
                in.close();
            }
            catch (Exception e) {
                Logger.severe(HarvestDoc.class, "Failed to read frequnecies: " + e.getMessage());
            }
        }
        return frequencies;
    }

    public static Map<Integer, DocURL> getRailroads() {
        if (railroads.size() == 0) {
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/railroad.serial");
            try {
                InputStream is = u.openStream();
                ObjectInputStream in = new ObjectInputStream(is);
                railroads = (Map)in.readObject();
                in.close();
            }
            catch (Exception e) {
                Logger.severe(HarvestDoc.class, "Failed to read railroad diagram URLs: " + e.getMessage());
            }
        }
        return railroads;
    }

    static String readURL(String masterBNFurl) throws Exception {
        if (masterBNFurl.endsWith(".pdf") || masterBNFurl.endsWith(".mobi") || masterBNFurl.endsWith(".epub")) {
            return "";
        }
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        URL url = new URL(masterBNFurl);
        System.out.print("opening " + masterBNFurl + "...");
        BufferedInputStream bin = new BufferedInputStream(url.openStream());
        System.out.println("done.");
        bytesRead = bin.read(bytes, 0, bytes.length);
        StringBuilder sb = new StringBuilder();
        while (bytesRead != -1) {
            sb.append(new String(bytes).substring(0, bytesRead));
            bytesRead = bin.read(bytes, 0, bytes.length);
        }
        bin.close();
        return sb.toString();
    }
}

