/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.PlsqlRules;
import oracle.dbtools.parser.plsql.SqlRules;
import oracle.dbtools.util.Service;

public class UnifiedRules {
    private static final String fname = "allRules.serial";
    private static final String path = "/oracle/dbtools/parser/plsql/";

    public static void main(String[] args) throws Exception {
        UnifiedRules.memorizeRules();
    }

    private static void memorizeRules() throws Exception {
        Set<RuleTuple> rules = UnifiedRules.extractRules();
        FileOutputStream fos = new FileOutputStream("common/src/oracle/dbtools/parser/plsql/allRules.serial");
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(rules);
        out.close();
    }

    public static Set<RuleTuple> getRules() throws Exception {
        URL u = PlsqlRules.class.getResource("/oracle/dbtools/parser/plsql/allRules.serial");
        InputStream is = u.openStream();
        ObjectInputStream in = new ObjectInputStream(is);
        Set rules = (Set)in.readObject();
        in.close();
        return rules;
    }

    private static Set<RuleTuple> extractRules() throws Exception {
        Set<RuleTuple> ret = PlsqlRules.parseBNFtext(PlsqlRules.readBNFfile());
        Object input = Service.readFile(UnifiedRules.class, "SqlPlus.grammar");
        List<LexerToken> src = LexerToken.parse((String)input);
        ParseNode root = Grammar.parseGrammarFile(src, (String)input);
        Grammar.grammar(root, src, ret);
        input = Service.readFile(UnifiedRules.class, "PlsqlFixes.grammar");
        src = LexerToken.parse((String)input);
        root = Grammar.parseGrammarFile(src, (String)input);
        Grammar.grammar(root, src, ret);
        PlsqlRules.fixIdentifierIsOrAs(ret);
        for (RuleTuple rule : ret) {
            if (!rule.head.contains("constrained_type")) continue;
            System.out.println(rule.toString());
        }
        Set<RuleTuple> sql = SqlRules.extractRules();
        ret.addAll(sql);
        ret.add(new RuleTuple("pls_expr", new String[]{"multiset_expression"}));
        RuleTransforms.eliminateEmptyProductions(ret);
        RuleTransforms.substituteSingleUnaryProductions(ret);
        return ret;
    }
}

