/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;

public class DbObjectsDDL {
    static final String path = "/oracle/dbtools/parser/plsql/";
    private static Connection c = null;
    private static String query = null;
    private static ResultSet rs1 = null;
    private static PreparedStatement stmt2 = null;
    private static Map<String, Integer> objectTypeCounts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbObject next() throws Exception {
        DbObject ret = null;
        ResultSet rs2 = null;
        if (rs1.next()) {
            String type = rs1.getString(1);
            String name = rs1.getString(2);
            String owner = rs1.getString(3);
            System.out.println(owner + "." + name + " (" + type + ")");
            stmt2.setString(1, type);
            stmt2.setString(2, name);
            stmt2.setString(3, owner);
            Integer cnt = objectTypeCounts.get(type);
            if (cnt == null) {
                cnt = 0;
            }
            if (10 < cnt) {
                return new DbObject("", "");
            }
            try {
                rs2 = stmt2.executeQuery();
                rs2.next();
                ret = new DbObject(type, rs2.getString(1));
            }
            catch (SQLException e) {
                System.err.println(owner + "." + name + " (" + type + ")");
                System.err.println(e.getMessage());
                DbObject dbObject = new DbObject("", "");
                return dbObject;
            }
            finally {
                if (rs2 != null) {
                    rs2.close();
                }
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        StringBuilder test = new StringBuilder();
        SqlEarley earley = SqlEarley.getInstance();
        int testNo = 0;
        DbObject obj = null;
        while ((obj = DbObjectsDDL.next()) != null) {
            String code = obj.definition;
            if (code.length() == 0) continue;
            if (!(code = code.trim()).endsWith(";")) {
                code = code + ";";
            }
            if (code.contains("***UNSUPPORTED DATA TYPE")) continue;
            boolean error = false;
            List<LexerToken> src = LexerToken.parse(code);
            Matrix matrix = new Matrix(earley);
            earley.parse(src, matrix);
            if (code.contains("CREATE OR REPLACE NONEDITIONABLE FUNCTION") && src.size() < 12) continue;
            ParseNode root = null;
            try {
                root = earley.forest(src, matrix);
            }
            catch (AssertionError e) {
                System.err.println("AssertionError" + ((Throwable)((Object)e)).getMessage());
                System.err.println(code);
                error = true;
            }
            if (root == null || root.to < 2) {
                System.err.println(code);
                error = true;
            }
            boolean from = false;
            int to = src.size();
            if (root != null && root.topLevel != null) {
                for (ParseNode n : root.children()) {
                    if (n.from != 0) continue;
                    root = n;
                    to = root.to;
                }
                if (root.topLevel != null) {
                    System.err.println(code);
                    error = true;
                }
            }
            if (!error) continue;
            test.append("++");
            test.append(testNo++);
            test.append(";\n");
            test.append('`');
            test.append(code);
            test.append("`->\n");
            test.append("[0,0) dummy /*failed*/\n;\n\n");
            Integer cnt = objectTypeCounts.get(obj.type);
            if (cnt == null) {
                cnt = 0;
            }
            objectTypeCounts.put(obj.type, cnt + 1);
        }
        System.out.println("------------------------------");
        FileWriter fw = new FileWriter("common/src/oracle/dbtools/parser/plsql/dbobjects_sql.test");
        fw.write(test.toString());
        fw.close();
    }

    static {
        try {
            Class.forName("oracle.jdbc.OracleDriver");
            c = DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521/DB12GR1P.uk.oracle.com", "system", "dbtools");
            query = "select object_type,object_name,owner from all_objects \n where OWNER like 'SYS%' and object_type not like '%JAVA%' and object_type != 'VIEW'/*and rownum < 1000*/";
            PreparedStatement stmt1 = c.prepareStatement(query);
            rs1 = stmt1.executeQuery();
            stmt2 = c.prepareStatement("select DBMS_METADATA.GET_DDL(:type,:name,:owner) from dual");
        }
        catch (Exception e) {
            throw new RuntimeException("failed to connect to database");
        }
        objectTypeCounts = new HashMap<String, Integer>();
    }

    static class DbObject {
        String type;
        String definition;

        public DbObject(String type, String definition) {
            this.type = type;
            this.definition = definition;
        }
    }
}

