/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;

public abstract class Parser {
    public String[] allSymbols;
    public Map<String, Integer> symbolIndexes;

    public Parser(Set<RuleTuple> originalRules) {
        this.extractSymbols(originalRules);
    }

    protected void extractSymbols(Set<RuleTuple> originalRules) {
        TreeSet<String> tmpSymbols = new TreeSet<String>();
        tmpSymbols.add("!nil");
        for (RuleTuple ct : originalRules) {
            if (ct.head == null || ct.rhs.length == 0 || ct.rhs[0] == null || ct.rhs.length > 1 && ct.rhs[1] == null) {
                throw new RuntimeException("ct has null symbols");
            }
            tmpSymbols.add(ct.head);
            for (String s : ct.rhs) {
                tmpSymbols.add(s);
            }
        }
        this.allSymbols = new String[tmpSymbols.size()];
        this.symbolIndexes = new HashMap<String, Integer>();
        int k = 0;
        for (String s : tmpSymbols) {
            this.symbolIndexes.put(s, k);
            this.allSymbols[k] = s;
            ++k;
        }
    }

    public boolean isTerminal(int terminal) {
        return this.allSymbols[terminal].charAt(0) == '\'';
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix) {
        HashMap<Long, ParseNode> explored = new HashMap<Long, ParseNode>();
        try {
            ParseNode root;
            int len = src.size();
            if (len == 0) {
                return new ParseNode(0, len, -1, -1, this);
            }
            Cell cell = matrix.get(0, len);
            if (cell != null && 0 < cell.size() && (root = this.treeForACell(src, matrix, cell, 0, len, explored)) != null) {
                return root;
            }
            ParseNode pseudoRoot = new ParseNode(0, len, -1, -1, this);
            int X = 0;
            int Y = matrix.lastY();
            for (int offset = 0; offset < Y; ++offset) {
                for (int t = 0; t < offset + 1; ++t) {
                    ParseNode node;
                    int x = X + t;
                    int y = Y + t - offset;
                    cell = matrix.get(x, y);
                    if (cell == null || (node = this.treeForACell(src, matrix, cell, x, y, explored = new HashMap())) == null) continue;
                    pseudoRoot.addTopLevel(node);
                    node.parent = pseudoRoot;
                    return pseudoRoot;
                }
            }
            return new ParseNode(0, 1, -1, -1, this);
        }
        catch (AssertionError e) {
            System.err.println("Parser.forest(): AssertionError" + ((Throwable)((Object)e)).getMessage());
            return null;
        }
    }

    abstract ParseNode treeForACell(List<LexerToken> var1, Matrix var2, Cell var3, int var4, int var5, Map<Long, ParseNode> var6);

    public int getSymbol(String string) {
        try {
            return this.symbolIndexes.get(string);
        }
        catch (NullPointerException e) {
            System.out.println("NPE: symbolIndexes.get(" + string + ")");
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void printOrderedRules(String symbol, boolean headOnly, boolean exactMatch) {
        for (int i = 0; i < ((Earley)this).rules.length; ++i) {
            Earley.Tuple tuple = ((Earley)this).rules[i];
            if (!exactMatch && ((Earley)this).allSymbols[tuple.head].contains(symbol) || exactMatch && ((Earley)this).allSymbols[tuple.head].equals(symbol)) {
                System.out.println(i + "     " + tuple.toString());
            }
            if (headOnly) continue;
            for (int rhsi : tuple.rhs) {
                if ((exactMatch || !((Earley)this).allSymbols[rhsi].contains(symbol)) && (!exactMatch || !((Earley)this).allSymbols[rhsi].equals(symbol))) continue;
                System.out.println(i + "     " + tuple.toString());
            }
        }
    }
}

