/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Timer {
    private static final String COLON = ":";
    private static final String DOT = ".";
    private long startTime;
    private long endTime;
    private boolean cacheDuration = false;
    private List<Long> durationCache = new ArrayList<Long>();

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
        if (this.cacheDuration) {
            this.durationCache.add(this.duration());
        }
    }

    public long duration() {
        return this.endTime - this.startTime;
    }

    public void printDuration(PrintStream out) {
        long elapsedTimeInSecond = this.duration();
        out.println("\nTotal execution time:" + elapsedTimeInSecond + " milliseconds");
    }

    public void printDuraion() {
        this.printDuration(System.out);
    }

    public void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.cacheDuration = false;
        this.durationCache.clear();
    }

    public void cacheDuration(boolean cache) {
        this.cacheDuration = cache;
    }

    public void printCachedDurations() {
        Collections.sort(this.durationCache);
        for (Long l : this.durationCache) {
            System.out.println("duration =" + l + " milliseconds");
        }
    }

    public void averageDuration() {
        if (this.durationCache.size() < 1) {
            System.out.println("-1");
        }
        long ret = 0L;
        for (Long l : this.durationCache) {
            ret += l.longValue();
        }
        System.out.println("average duration =" + (float)ret / (float)this.durationCache.size() + " milliseconds");
    }

    public void totalTime() {
        long ret = 0L;
        for (Long l : this.durationCache) {
            ret += l.longValue();
        }
        System.out.println("total time =" + ret + " milliseconds");
    }

    public static void main(String[] args) {
        int i;
        Timer timer = new Timer();
        timer.start();
        for (i = 0; i < 500; ++i) {
            System.out.print("#");
        }
        timer.end();
        timer.printDuration(System.out);
        timer.reset();
        timer.cacheDuration(true);
        for (i = 0; i < 50; ++i) {
            timer.start();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.getLogger(Timer.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            timer.end();
            timer.printDuration(System.out);
            if (i % 4 != 0) continue;
            System.out.println(i + "  hahahahahhahahaha");
        }
        timer.averageDuration();
    }

    public long durationInSecs() {
        return this.duration() / 1000L;
    }

    public String durationSQLPlus() {
        long secs;
        long mins;
        long durationMilliSecs = this.duration();
        String x = "";
        long hrs = durationMilliSecs / 3600000L % 24L;
        if (hrs > 0L) {
            durationMilliSecs -= hrs * 1000L * 60L * 60L;
            x = x + String.format("%02d", hrs) + COLON;
        }
        if ((mins = durationMilliSecs / 60000L % 60L) > 0L) {
            durationMilliSecs -= mins * 1000L * 60L;
            x = x + String.format("%02d", mins) + COLON;
        }
        if ((secs = durationMilliSecs / 1000L % 60L) > 0L) {
            durationMilliSecs -= secs * 1000L;
            x = x + String.format("%02d", secs) + DOT;
        }
        if (durationMilliSecs > 0L) {
            x = x + String.format("%03d", durationMilliSecs);
        }
        return x;
    }
}

