/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.logging.ILoggingPage;

public class LogPaneHandler
extends Handler {
    private static LogPaneHandler INSTANCE;
    private static final Object INSTANCE_LOCK;
    private static final Logger BASE_LOGGER;
    private Queue<LogRecord> m_records = new ConcurrentLinkedQueue<LogRecord>();
    private static final String PROXY_LOGGER = "oracle.dbtools.raptor.proxy.ProxyLogger";
    private volatile Class<ILoggingPage> _logPageClass;
    private transient Runnable _logRunner;
    private volatile ILoggingPage _logPage;

    private LogPaneHandler() {
        LogManager lm = LogManager.getLogManager();
        Logger root = lm.getLogger("");
        root.addHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogPaneHandler getInstance() {
        if (INSTANCE == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new LogPaneHandler();
                    INSTANCE.setLevel(Level.ALL);
                }
            }
        }
        return INSTANCE;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
        this.logMessages(true);
    }

    @Override
    public void publish(LogRecord rec) {
        assert (rec != null);
        if (BASE_LOGGER.isLoggable(rec.getLevel())) {
            if (PROXY_LOGGER.equals(rec.getLoggerName())) {
                return;
            }
            if (null == rec.getSourceClassName()) {
                rec.setSourceClassName(null);
            }
            this.m_records.add(rec);
            this.logMessages(false);
        }
    }

    public void setLogPageClass(Class clazz) {
        assert (clazz != null);
        this._logPageClass = clazz;
    }

    private void logMessages(boolean flush) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.logMessages();
        } else if (flush || null == this._logRunner) {
            this._logRunner = new Runnable(){

                @Override
                public void run() {
                    LogPaneHandler.this._logRunner = null;
                    LogPaneHandler.this.logMessages();
                }
            };
            SwingUtilities.invokeLater(this._logRunner);
        }
    }

    private void logMessages() {
        assert (SwingUtilities.isEventDispatchThread());
        ILoggingPage page = this.getLogPage();
        if (page != null) {
            LogRecord rec;
            while ((rec = this.m_records.poll()) != null) {
                page.log(rec);
            }
        }
    }

    private void setLogPage(ILoggingPage page) {
        this._logPage = page;
    }

    private ILoggingPage getLogPage() {
        if (this._logPageClass != null) {
            try {
                ILoggingPage logPage = this._logPageClass.newInstance();
                this._logPageClass = null;
                this.setLogPage(logPage);
            }
            catch (InstantiationException e) {
                BASE_LOGGER.log(Level.SEVERE, e.getMessage());
            }
            catch (IllegalAccessException e) {
                BASE_LOGGER.log(Level.SEVERE, e.getMessage());
            }
        }
        return this._logPage;
    }

    static {
        INSTANCE_LOCK = new Object();
        BASE_LOGGER = Logger.getLogger("oracle.dbtools");
    }
}

