/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.util.Properties;
import oracle.dbtools.db.DefaultConnectionResolver;

public abstract class ConnectionResolver {
    public static final String ORACLE_TYPE = "Oracle";
    public static final String TIMES_TEN_TYPE = "TimesTen";
    public static final String GENERIC_TYPE = "Generic";
    private static ConnectionResolver sInstance = new DefaultConnectionResolver();

    static void setConnectionResolver(ConnectionResolver impl) {
        sInstance = impl;
    }

    public static Connection getConnection(String name) throws Exception {
        return sInstance.getConnectionImpl(name);
    }

    public static String getConnectionName(Connection conn) {
        return sInstance.getConnectionNameImpl(conn);
    }

    public static String[] getConnectionNames() {
        return sInstance.getConnNamesImpl();
    }

    public static Properties getConnectionInfo(String name) {
        return sInstance.getConnectionInfoImpl(name);
    }

    public static boolean isOracle(Connection conn) {
        return sInstance.isOracleImpl(conn);
    }

    public static boolean isTimesTen(Connection conn) {
        return sInstance.isTimesTenImpl(conn);
    }

    public static String getConnectionType(Connection conn) {
        return sInstance.getConnectionTypeImpl(conn);
    }

    public static String getQualifiedConnectionName(String name) {
        return sInstance.getQualifiedName(name);
    }

    public static Connection getUniqueConnection(String name) throws Exception {
        return sInstance.getUniqueConnectionImpl(name);
    }

    protected abstract Connection getConnectionImpl(String var1) throws Exception;

    protected abstract String getConnectionNameImpl(Connection var1);

    protected abstract String[] getConnNamesImpl();

    protected abstract Properties getConnectionInfoImpl(String var1);

    protected abstract boolean isOracleImpl(Connection var1);

    protected abstract boolean isTimesTenImpl(Connection var1);

    protected abstract String getConnectionTypeImpl(Connection var1);

    protected abstract String getQualifiedName(String var1);

    protected abstract Connection getUniqueConnectionImpl(String var1) throws Exception;
}

