/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.DefaultConnectionResolver;

public class AdvancedConnectionResolver
extends DefaultConnectionResolver {
    private ArrayList<ConnectionDetails> _loadedConnections = new ArrayList();

    @Override
    protected String getConnectionTypeImpl(Connection conn) {
        for (ConnectionDetails connDetails : this._loadedConnections) {
            if (connDetails.getConn() != conn) continue;
            return connDetails.getType();
        }
        return "Oracle";
    }

    @Override
    protected Connection getConnectionImpl(String name) throws Exception {
        if (name.startsWith("\"")) {
            return this.getConnectionFromURL(this.strip(name, '\"'));
        }
        return DefaultConnectionResolver.getConnection(name);
    }

    private String strip(String connStr, char stripChar) {
        if ((connStr = connStr.trim()).charAt(0) == stripChar && connStr.charAt(connStr.length() - 1) == stripChar) {
            return connStr.substring(1, connStr.length() - 1);
        }
        return connStr;
    }

    private Connection getConnectionFromURL(String url) {
        Connection conn = null;
        ConnectionDetails currentConnDetails = new ConnectionDetails(url);
        for (ConnectionDetails connectionDetails : this._loadedConnections) {
            if (!currentConnDetails.getUrl().equals(connectionDetails.getUrl())) continue;
            conn = connectionDetails.getConn();
            break;
        }
        if (conn == null) {
            this._loadedConnections.add(currentConnDetails);
            conn = currentConnDetails.getConn();
        }
        return conn;
    }
}

