/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.readservice;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.data.readservice.ReadService;

public class ReadServiceDelimited
extends ReadService {
    public static final String NAME = "Delimited";
    public static final String FORMAT = "delimited";
    public static final String EXT = "dsv";
    public static final int BUFFER_SIZE = 1024;
    public static final int BUFFER_KSIZE = 1;
    private BufferedReader _reader;
    private InputStream _inputStream;
    private ReadParmsDelimitedAPI _parms;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private String[] m_headerRowColumnNames;
    private int m_columnCount = -1;
    private String m_currentRow = null;
    private boolean m_currentRowRead = true;
    private String[] m_firstRow = null;
    private int m_rowsRead = 0;

    public ReadServiceDelimited(InputStream inputStream, ReadParmsDelimitedAPI parms) {
        this(inputStream, parms, null);
    }

    public ReadServiceDelimited(InputStream inputStream, ReadParmsDelimitedAPI parms, Iterable<Locale> responseLocales) {
        this._inputStream = inputStream;
        this._parms = parms == null ? new ReadParmsDelimitedAPI.Builder().build() : parms;
        super.setResponseLocales(responseLocales);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getType() {
        return EXT;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    protected void setLogger(Logger logger) {
        this.LOGGER = logger;
        super.setLogger(logger);
    }

    @Override
    public String[] getColumnNames() throws DataFormatException {
        try {
            int i;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            ArrayList<String> names = new ArrayList<String>();
            if (this._parms.isHeaderBeforeSkip()) {
                for (i = 0; i < this._parms.getSkipRows(); ++i) {
                    if (this.hasMoreRows()) continue;
                    this.readLine(this._reader);
                }
            }
            if (this.hasMoreRows()) {
                this.m_firstRow = (String[])this.readline();
            }
            while (this.hasMoreRows() && this.m_firstRow != null && (this.m_firstRow.length == 0 || this.m_firstRow.length == 1 && this.m_firstRow[0].length() == 0)) {
                this.m_firstRow = (String[])this.readline();
            }
            if (this.m_firstRow != null && this.m_firstRow.length > 0) {
                for (i = 0; i < this.m_firstRow.length; ++i) {
                    if (this.m_firstRow[i] == null) continue;
                    if (map.containsKey(this.m_firstRow[i])) {
                        map.put(this.m_firstRow[i], (Integer)map.get(this.m_firstRow[i]) + 1);
                        names.add(this.m_firstRow[i].toString() + map.get(this.m_firstRow[i]));
                        continue;
                    }
                    map.put(this.m_firstRow[i], 1);
                    names.add(this.m_firstRow[i]);
                }
                this.m_headerRowColumnNames = names.toArray(new String[names.size()]);
            }
            int n = this.m_columnCount = this.m_headerRowColumnNames == null ? 0 : this.m_headerRowColumnNames.length;
            if (!this._parms.isHeaderBeforeSkip()) {
                for (i = 0; i < this._parms.getSkipRows(); ++i) {
                    if (this.hasMoreRows()) continue;
                    this.readLine(this._reader);
                }
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return this.m_headerRowColumnNames;
    }

    private String[] splitRow(String line) throws DataFormatException {
        ArrayList<String> columns = new ArrayList<String>();
        String delimValue = this._parms.getDelimiterValue();
        int delimValueLength = delimValue.length();
        int errorOffset = -1;
        if (delimValueLength != 0) {
            int col = 0;
            int state = 0;
            StringBuilder token = new StringBuilder();
            if (this._parms.isDelimiterWhiteSpace()) {
                delimValue = "\t";
                delimValueLength = 1;
            }
            String eLeftValue = this._parms.getEnclosureLeft();
            String eRightValue = this._parms.getEnclosureRight();
            boolean isEnclosed = this._parms.isEnclosed();
            if (state == 2) {
                state = 0;
            }
            int lineIndex = 0;
            while (lineIndex < line.length()) {
                char c = line.charAt(lineIndex);
                switch (state) {
                    case 0: {
                        if (isEnclosed && line.startsWith(eLeftValue, lineIndex)) {
                            lineIndex += eLeftValue.length();
                            state = 1;
                            break;
                        }
                        if (this.isThisDelimiter(line, lineIndex, delimValue)) {
                            columns.add(token.toString());
                            ++col;
                            token = new StringBuilder();
                            lineIndex += delimValueLength;
                            if (!this._parms.isDelimiterWhiteSpace()) break;
                            state = 2;
                            break;
                        }
                        token.append(c);
                        ++lineIndex;
                        break;
                    }
                    case 1: {
                        if (isEnclosed && line.startsWith(eRightValue, lineIndex)) {
                            lineIndex += eRightValue.length();
                            state = this._parms.isEnclosureRightDouble() ? 3 : 4;
                            break;
                        }
                        token.append(c);
                        ++lineIndex;
                        break;
                    }
                    case 2: {
                        if (!this.isThisDelimiter(line, lineIndex, delimValue)) {
                            if (isEnclosed && line.startsWith(eLeftValue, lineIndex)) {
                                state = 1;
                                token = new StringBuilder();
                                lineIndex += eLeftValue.length();
                                break;
                            }
                            state = 0;
                            ++lineIndex;
                            token.append(c);
                            break;
                        }
                        lineIndex += delimValueLength;
                        break;
                    }
                    case 3: {
                        if (this.isThisDelimiter(line, lineIndex, delimValue)) {
                            columns.add(token.toString());
                            ++col;
                            token = new StringBuilder();
                            lineIndex += delimValueLength;
                            if (this._parms.isDelimiterWhiteSpace()) {
                                state = 2;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        if (line.startsWith(eRightValue, lineIndex)) {
                            token.append(c);
                            ++lineIndex;
                            state = 1;
                            break;
                        }
                        if (errorOffset == -1) {
                            errorOffset = lineIndex;
                        }
                        token.append(eRightValue + c);
                        ++lineIndex;
                        state = 5;
                        break;
                    }
                    case 4: {
                        if (this.isThisDelimiter(line, lineIndex, delimValue)) {
                            columns.add(token.toString());
                            ++col;
                            token = new StringBuilder();
                            lineIndex += delimValueLength;
                            if (this._parms.isDelimiterWhiteSpace()) {
                                state = 2;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        if (line.startsWith(eRightValue, lineIndex)) {
                            token.append(eRightValue);
                            ++lineIndex;
                            break;
                        }
                        token.append(eRightValue + c);
                        ++lineIndex;
                        state = 1;
                        break;
                    }
                    case 5: {
                        token.append(c);
                        ++lineIndex;
                    }
                }
            }
            if (state == 0) {
                columns.add(token.toString());
                col = 0;
                token = new StringBuilder();
            } else if (state == 1) {
                columns.add(eLeftValue + token.toString());
                if (errorOffset == -1) {
                    errorOffset = line.length() - 1;
                }
            } else if (state != 0) {
                columns.add(token.toString());
            }
        } else {
            columns.add(line);
        }
        if (errorOffset != -1) {
            String msg = this.translate("ENCLOSURE_ERR") + " " + (errorOffset + 1);
            throw new DataFormatException(msg, errorOffset + 1, line, columns.toArray(new String[columns.size()]));
        }
        return columns.toArray(new String[columns.size()]);
    }

    private boolean isThisDelimiter(String record, int lineIndex, String delimValue) {
        if (this._parms.isDelimiterWhiteSpace()) {
            return record.startsWith(delimValue, lineIndex) || record.startsWith(" ", lineIndex);
        }
        return record.startsWith(delimValue, lineIndex);
    }

    @Override
    public boolean hasMoreRows() {
        boolean currentRowRead = this.m_currentRowRead;
        this.m_currentRowRead = false;
        try {
            if (!currentRowRead) {
                return true;
            }
            if (!this._parms.isLimitRows() || this.m_rowsRead < this._parms.getLimitRows()) {
                this.m_currentRow = this.readLine(this._reader);
                if (this.m_currentRow != null) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            this.m_currentRow = null;
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void start() {
        try {
            if (this._reader != null) {
                this._reader.close();
            }
            this._reader = this.getReader();
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        this.m_currentRow = null;
    }

    private BufferedReader getReader() {
        BufferedReader tmpReader = null;
        this.m_currentRow = null;
        try {
            tmpReader = new BufferedReader(new InputStreamReader(this._inputStream, this._parms.getEncoding()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmpReader;
    }

    @Override
    public void close() {
        try {
            if (this._reader != null) {
                this._reader.close();
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        this.m_currentRow = null;
        this._reader = null;
    }

    public static void main(String[] args) {
        try {
            ReadServiceDelimited readServiceDelimited = new ReadServiceDelimited(new FileInputStream(new File("d:/family.csv")), null);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public Object[] readline() throws DataFormatException {
        Object[] colArray = this.splitRow(this.m_currentRow);
        this.m_currentRowRead = true;
        return colArray;
    }

    private String readLine(BufferedReader reader) throws IOException {
        if (!this._parms.isStandardTerminator()) {
            StringBuffer phys_record;
            block3: {
                String recordTerminator = this._parms.getTerminator();
                char[] buffer = new char[1];
                int num_read = reader.read(buffer);
                if (num_read == -1) {
                    return null;
                }
                ++this.m_rowsRead;
                int totalChars = num_read;
                phys_record = new StringBuffer();
                phys_record.append(buffer);
                String phys_record_end = "";
                do {
                    num_read = reader.read(buffer);
                    totalChars += num_read;
                    if (num_read == -1) break block3;
                    phys_record.append(buffer);
                } while (phys_record.length() < recordTerminator.length() || recordTerminator.length() <= 0 || !(phys_record_end = phys_record.substring(phys_record.length() - recordTerminator.length(), phys_record.length())).equals(recordTerminator));
                return phys_record.substring(0, phys_record.length() - recordTerminator.length());
            }
            return phys_record.length() == 0 ? null : phys_record.toString();
        }
        return reader.readLine();
    }
}

