/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.Paths;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.util.Logger;

public class FileUtils {
    public static URLConnection getFile(String filename) {
        return FileUtils.getFile(null, filename);
    }

    public static URLConnection getFile(ScriptRunnerContext ctx, String filename) {
        URLConnection uc = null;
        String cdfilename = null;
        String toRun = null;
        if (ctx == null) {
            ctx = new ScriptRunnerContext();
        }
        if (filename != null && filename.length() > 0) {
            try {
                if (!(FileUtils.startsWithHttpOrFtp(filename) && FileUtils.haveIBytes(filename, ctx) || FileUtils.haveIBytesRaw(filename))) {
                    cdfilename = ctx.prependCD(filename);
                    String pathGiven = null;
                    if (cdfilename.equals(filename) && SQLPLUS.getSqlpathProvider() != null && (pathGiven = SQLPLUS.getSqlpathProvider().getSQLPATHsetting()).trim().equals(".")) {
                        pathGiven = System.getProperty("user.dir");
                    }
                    boolean prependDirectory = false;
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        if (filename.length() <= 3 || (filename.charAt(1) != ':' || filename.charAt(2) != '/' && filename.charAt(2) != '\\') && (filename.charAt(0) != '/' || filename.charAt(2) != ':' || filename.charAt(3) != '/')) {
                            prependDirectory = true;
                        }
                    } else if (!filename.startsWith("/") && !filename.startsWith("\\")) {
                        prependDirectory = true;
                    }
                    if (pathGiven != null && prependDirectory) {
                        for (String possible : pathGiven.split(File.pathSeparator)) {
                            if (possible == null) continue;
                            possible = possible.endsWith("/") || possible.endsWith("\\") ? possible + filename : possible + File.separator + filename;
                            possible = System.getProperty("os.name").startsWith("Windows") ? possible.replace("/", "\\") : possible.replace("\\", "/");
                            if (!new File(possible).exists() || !new File(possible).canRead()) continue;
                            toRun = new File(possible).getAbsolutePath();
                            break;
                        }
                    } else {
                        toRun = !new File(filename).isAbsolute() && cdfilename.equals(filename) && prependDirectory ? System.getProperty("user.home") + File.separator + filename : cdfilename;
                    }
                    if (toRun == null) {
                        toRun = cdfilename;
                    }
                    if (FileUtils.startsWithHttpOrFtp(toRun)) {
                        return new URL(toRun).openConnection();
                    }
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        toRun = "/" + toRun.replace("\\", "/");
                    }
                    return new URL("file://" + toRun).openConnection();
                }
                toRun = filename;
                return new URL(toRun).openConnection();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return uc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean haveIBytes(String base, ScriptRunnerContext ctx) {
        if (!FileUtils.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        Proxy proxy = null;
        try {
            String lower = base.toLowerCase();
            if (FileUtils.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            try {
                if (ctx.getProperty("script.runner.hhtp.proxy") != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ctx.getProperty("script.runner.hhtp.proxy.host").toString(), Integer.parseInt(ctx.getProperty("script.runner.hhtp.proxy.port").toString())));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (System.getProperties().get("http.proxyHost") != null && System.getProperties().get("http.proxyPort") != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getProperties().get("http.proxyHost").toString(), Integer.parseInt(System.getProperty("http.proxyPort"))));
            }
            if ((is = (c = proxy != null ? new URL(base).openConnection(proxy) : new URL(base.replaceAll("\\\\", "/")).openConnection()).getInputStream()).read() != -1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean startsWithHttpOrFtp(String base) {
        if (base == null) {
            return false;
        }
        String lower = base.toLowerCase();
        return lower.startsWith("http://") || lower.startsWith("https://") || lower.startsWith("http:\\\\") || lower.startsWith("https:\\\\") || FileUtils.containsFile(lower) || lower.startsWith("ftp:\\\\") || lower.startsWith("ftps:\\\\") || lower.startsWith("ftps://") || lower.startsWith("ftp://");
    }

    public static boolean containsFile(String inFile) {
        String stub;
        boolean retVal = false;
        if (inFile.indexOf(":") > 1 && (stub = inFile.substring(0, inFile.indexOf(":"))).endsWith("file") && stub.indexOf("/") == -1 && stub.indexOf("\\") == -1) {
            retVal = true;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean haveIBytesRaw(String base) {
        if (!FileUtils.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (FileUtils.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            if (base.indexOf("\\") != -1) {
                base.replace("/", "\\");
                c = new URL(base).openConnection();
                is = c.getInputStream();
                if (is.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static void main(String[] args) {
        URLConnection uc = FileUtils.getFile("barry.sql");
        try {
            uc.getInputStream();
            uc.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getSQLPathString(ScriptRunnerContext ctx) {
        Object[] sources;
        String provider = null;
        if (SQLPLUS.getSqlpathProvider() != null) {
            provider = SQLPLUS.getSqlpathProvider().getSQLPATHsetting();
        }
        String pathGiven = "";
        for (Object source : sources = new Object[]{(String)ctx.getProperty("script.runner.cd_command"), FileUtils.getParent((URL)ctx.getProperty("script.runner.base.url")), System.getenv("SQLDEV_STARTUP"), FileUtils.getParent((URL)ctx.getProperty("script.runner.topbase.url")), FileUtils.getParent(FileUtils.useIfNotDirectoryOrNotFile(ctx.getLastNodeForDirNameURL())), FileUtils.useIfDirectoryOrNotFile(ctx.getLastNodeForDirNameURL()), FileUtils.getParent(FileUtils.useIfNotDirectoryOrNotFile(ctx.getLastDirNameURL())), FileUtils.useIfDirectoryOrNotFile(ctx.getLastDirNameURL()), ctx.getProperty("DBConfig.DEFAULT_PATH"), provider}) {
            if (source == null) continue;
            if (source instanceof String) {
                String val = (String)source;
                if (val.equals("")) continue;
                pathGiven = pathGiven + File.pathSeparator + (String)source;
                continue;
            }
            if (!(source instanceof URL)) continue;
            String toString = ((URL)source).toString();
            toString = FileUtils.decodeIfFile(toString);
            pathGiven = pathGiven + File.pathSeparator + toString;
        }
        if (ctx.getProperty("script.runner.jline") == null) {
            pathGiven = pathGiven + File.pathSeparator + ".";
        }
        if (pathGiven.length() > 1) {
            pathGiven = pathGiven.substring(1);
        }
        return pathGiven;
    }

    public static String[] getSQLPath(ScriptRunnerContext ctx) {
        return FileUtils.getSQLPathString(ctx).split(File.pathSeparator);
    }

    public static String getCWD(ScriptRunnerContext ctx) {
        String[] paths = FileUtils.getSQLPath(ctx);
        if (paths.length > 0) {
            return paths[0];
        }
        return Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
    }

    public static URL getParent(URL inURL) {
        URL retVal = null;
        if (inURL == null) {
            return null;
        }
        try {
            URI uri = inURL.toURI();
            String resolve = ".";
            if (uri.getPath().endsWith("/") || uri.getPath().endsWith("\\")) {
                resolve = "..";
            }
            URI parent = uri.resolve(resolve);
            retVal = parent.toURL();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return retVal;
    }

    public static String getDirFromFileURL(URL inURL) throws IOException {
        if (inURL == null) {
            return null;
        }
        String pathname = null;
        File file = null;
        try {
            file = new File(inURL.getFile());
            pathname = file.getCanonicalPath();
            if (!file.isDirectory()) {
                if (!file.exists() || pathname.indexOf(File.separator) == -1) {
                    throw new IOException(Messages.getString("ScriptRunnerContext.14") + pathname);
                }
                pathname = pathname.substring(0, pathname.lastIndexOf(File.separator));
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return pathname;
    }

    static URL useIfDirectoryOrNotFile(URL inURL) {
        if (inURL == null) {
            return null;
        }
        if (inURL.getProtocol() == null || !inURL.getProtocol().toLowerCase().endsWith("file")) {
            return inURL;
        }
        try {
            if (new File(inURL.getFile()).isDirectory()) {
                return inURL;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static URL useIfNotDirectoryOrNotFile(URL inURL) {
        if (inURL == null) {
            return null;
        }
        if (inURL.getProtocol() == null || !inURL.getProtocol().toLowerCase().endsWith("file")) {
            return inURL;
        }
        try {
            if (new File(inURL.getFile()).isDirectory()) {
                return null;
            }
            return inURL;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static String decodeIfFile(String sourceRef) {
        if (sourceRef != null && !sourceRef.equals("") && FileUtils.containsFile(sourceRef)) {
            try {
                String toString = null;
                try {
                    toString = new URL(sourceRef).toURI().getPath();
                }
                catch (URISyntaxException e) {
                    Logger.fine(FileUtils.class, e);
                }
                catch (MalformedURLException e) {
                    Logger.fine(FileUtils.class, e);
                }
                if (toString == null && (toString = URLDecoder.decode(sourceRef, "UTF-8")) != null) {
                    int theIndex = toString.indexOf(":");
                    toString = theIndex != -1 && toString.length() > theIndex + 1 ? toString.substring(theIndex + 1) : null;
                }
                if (toString != null) {
                    if (toString.replace('\\', '/').startsWith("//") && toString.length() > 2) {
                        toString = toString.substring(2);
                    }
                    if (System.getProperty("os.name").startsWith("Windows") && (toString.startsWith("/") || toString.startsWith("\\")) && toString.length() > 3 && toString.substring(2, 3).equals(":")) {
                        toString = toString.substring(1).replace("/", "\\");
                    }
                    sourceRef = toString;
                }
            }
            catch (UnsupportedEncodingException e) {
                Logger.warn(FileUtils.class, e);
            }
        }
        return sourceRef;
    }

    public static String getUserHome() {
        String storage = System.getProperty("user.home") + File.separator + ".sqlcl";
        if (PlatformUtils.isWindows()) {
            String appData = System.getenv("APPDATA");
            storage = appData != null ? appData + File.separator + "sqlcl" : null;
        }
        return storage;
    }
}

