/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SqlProgram
extends Program {
    public SqlProgram(Class<?> dir, String file) throws IOException {
        this(Service.readFile(dir, file));
    }

    public SqlProgram(String programText) throws IOException {
        super(SqlEarley.getInstance());
        this.compile(programText);
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, Object callback) throws IOException {
        return this.run(input, src, null, callback);
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, String[] rootSyntax, Object callback) throws IOException {
        if (src == null) {
            src = LexerToken.parse(input);
        }
        Parsed target = new Parsed(input, src, (Earley)SqlEarley.getInstance(), rootSyntax);
        Map<String, MaterializedPredicate> predicateVectors = this.eval(target, callback);
        return predicateVectors;
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src) throws IOException {
        return this.run(input, src, null);
    }

    public Map<String, MaterializedPredicate> run(String input, Object callback) throws IOException {
        return this.run(input, null, callback);
    }

    public Map<String, MaterializedPredicate> run(String input) throws IOException {
        return this.run(input, null, null);
    }

    public static void main(String[] args) throws IOException {
        String input = "q: [id) identifier & ?y='p_owner';";
        SqlProgram r = new SqlProgram(input){};
        String sql = "SELECT p_owner FROM EMPLOYEES where FIRST_NAME not like 'Jeff%';";
        List<LexerToken> src = LexerToken.parse(sql);
        Map<String, MaterializedPredicate> output = r.run(sql, src);
        for (String p : output.keySet()) {
            System.out.println(p + "=" + output.get(p).toString(p.length() + 1));
        }
    }
}

