/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.AggregatePredicate;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.AttributeDefinitions;
import oracle.dbtools.arbori.BindVar;
import oracle.dbtools.arbori.Composite;
import oracle.dbtools.arbori.CompositeExpr;
import oracle.dbtools.arbori.Head;
import oracle.dbtools.arbori.IndependentAttribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.NodeContent;
import oracle.dbtools.arbori.NodeMatchingSrc;
import oracle.dbtools.arbori.NodesWMatchingSrc;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.Position;
import oracle.dbtools.arbori.PositionalRelation;
import oracle.dbtools.arbori.PredRef;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.PredicateDependency;
import oracle.dbtools.arbori.SameNodes;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tail;
import oracle.dbtools.arbori.True;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class Program {
    public static boolean debug = false;
    public static boolean timing = false;
    protected Earley parser;
    private static int attribute = -1;
    private static int backslash = -1;
    private static int closePar = -1;
    private static int closeBr = -1;
    private static int col = -1;
    private static int conj = -1;
    private static int digits = -1;
    private static int disj = -1;
    private static int dot = -1;
    private static int eq = -1;
    private static int excl = -1;
    private static int identifier = -1;
    private static int header = -1;
    private static int lt = -1;
    private static int minus = -1;
    private static int node_parent = -1;
    private static int node_predecessor = -1;
    private static int node_position = -1;
    private static int node_successor = -1;
    private static int node = -1;
    private static int openBr = -1;
    private static int openPar = -1;
    private static int plus = -1;
    private static int predicate = -1;
    private static int referenced_node = -1;
    private static int rule = -1;
    private static int srcPtr = -1;
    private static int semicol = -1;
    private static int slash = -1;
    private static int statement = -1;
    private static int string_literal = -1;
    private LinkedList<String> execOrder = new LinkedList();
    Map<String, Predicate> namedPredicates = new HashMap<String, Predicate>();
    private PredicateDependency dependency = new PredicateDependency();
    private Set<String> outputRelations = new HashSet<String>();
    private Program compiledInstance = null;
    protected static HashMap<String, Program> compiledPrograms = new HashMap();

    public Program(Earley parser) {
        this.parser = parser;
    }

    public static void main(String[] args) throws Exception {
        String input = "SELECT * FROM EMPLOYEES where FIRST_NAME not like 'Jeff%';";
        final List<LexerToken> src = LexerToken.parse("SELECT * FROM EMPLOYEES where FIRST_NAME not like 'Jeff%';");
        SqlProgram r = new SqlProgram(Service.readFile("c:/raptor_trunk/db/src/oracle/dbtools/raptor/phighlight/semantic_analysis.prg")){
            int caret;
            int offset;
            String newName;
            {
                super(programText);
                this.caret = "SELECT * FROM EMPLOYEES where FIRST_NAME not like 'Jeff%';".indexOf("p; --");
                this.offset = LexerToken.scanner2parserOffset(src, this.caret);
                this.newName = "-new name-";
            }
        };
        Map<String, MaterializedPredicate> output = r.run("SELECT * FROM EMPLOYEES where FIRST_NAME not like 'Jeff%';", src);
        for (String p : output.keySet()) {
            System.out.println(p + "=" + output.get(p).toString(p.length() + 1));
        }
    }

    public static Earley getArboriParser() throws IOException {
        Set<RuleTuple> rules = Program.getRules();
        Earley testParser = new Earley((Set)rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
            }
        };
        attribute = (Integer)testParser.symbolIndexes.get("attribute");
        backslash = (Integer)testParser.symbolIndexes.get("'\\'");
        closePar = (Integer)testParser.symbolIndexes.get("')'");
        closeBr = (Integer)testParser.symbolIndexes.get("']'");
        col = (Integer)testParser.symbolIndexes.get("':'");
        conj = (Integer)testParser.symbolIndexes.get("'&'");
        digits = (Integer)testParser.symbolIndexes.get("digits");
        disj = (Integer)testParser.symbolIndexes.get("'|'");
        dot = (Integer)testParser.symbolIndexes.get("'.'");
        eq = (Integer)testParser.symbolIndexes.get("'='");
        excl = (Integer)testParser.symbolIndexes.get("'!'");
        identifier = (Integer)testParser.symbolIndexes.get("identifier");
        header = (Integer)testParser.symbolIndexes.get("header");
        lt = (Integer)testParser.symbolIndexes.get("'<'");
        minus = (Integer)testParser.symbolIndexes.get("'-'");
        node_parent = (Integer)testParser.symbolIndexes.get("node_parent");
        node_position = (Integer)testParser.symbolIndexes.get("node_position");
        node_predecessor = (Integer)testParser.symbolIndexes.get("node_predecessor");
        node_successor = (Integer)testParser.symbolIndexes.get("node_successor");
        node = (Integer)testParser.symbolIndexes.get("node");
        openBr = (Integer)testParser.symbolIndexes.get("'['");
        openPar = (Integer)testParser.symbolIndexes.get("'('");
        plus = (Integer)testParser.symbolIndexes.get("'+'");
        predicate = (Integer)testParser.symbolIndexes.get("predicate");
        referenced_node = (Integer)testParser.symbolIndexes.get("referenced_node");
        rule = (Integer)testParser.symbolIndexes.get("rule");
        semicol = (Integer)testParser.symbolIndexes.get("';'");
        slash = (Integer)testParser.symbolIndexes.get("'/'");
        srcPtr = (Integer)testParser.symbolIndexes.get("'?'");
        statement = (Integer)testParser.symbolIndexes.get("statement");
        string_literal = (Integer)testParser.symbolIndexes.get("string_literal");
        return testParser;
    }

    private static Set<RuleTuple> getRules() throws IOException {
        String input = Service.readFile(Program.class, "arbori.grammar");
        List<LexerToken> src = LexerToken.parse(input);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, ret);
        return ret;
    }

    public LinkedList<String> querySequence() {
        return this.execOrder;
    }

    private void copyState(Program source) {
        this.execOrder = source.execOrder;
        this.namedPredicates.clear();
        for (String key : source.namedPredicates.keySet()) {
            Predicate value = source.namedPredicates.get(key);
            Predicate clone = value.copy(this);
            this.namedPredicates.put(key, clone);
        }
        this.dependency = source.dependency;
        this.outputRelations = source.outputRelations;
        this.parser = source.parser;
    }

    public void compile(String programText) throws IOException {
        this.compiledInstance = compiledPrograms.get(programText);
        if (this.compiledInstance == null) {
            Parsed prg = new Parsed(programText, Program.getArboriParser(), "program");
            this.program(prg.getRoot(), prg.getSrc(), prg.getInput());
            this.compiledInstance = new Program(this.parser);
            this.compiledInstance.copyState(this);
            compiledPrograms.put(programText, this.compiledInstance);
        } else {
            this.copyState(this.compiledInstance);
        }
    }

    private void program(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(statement)) {
            this.statement(root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            this.program(child, src, input);
        }
    }

    private void statement(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(rule)) {
            this.rule(root, src, input);
        }
    }

    private void rule(ParseNode root, List<LexerToken> src, String input) {
        String first = null;
        boolean legitimateOper = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                if (child.from + 1 == child.to) {
                    first = child.content(src);
                    continue;
                }
                return;
            }
            if (!legitimateOper) {
                if (child.contains(col)) {
                    legitimateOper = true;
                    continue;
                }
                return;
            }
            if (child.contains(predicate)) {
                Predicate p = this.predicate(child, src, input);
                int x = 0;
                if (p instanceof NodeContent && "sql_stmt".equals(((NodeContent)p).nodeVar)) {
                    ++x;
                }
                Map<String, Boolean> dependencies = p.dependencies();
                for (String s : dependencies.keySet()) {
                    this.dependency.addDependency(s, first, dependencies.get(s));
                }
                this.execOrder.add(first);
                this.namedPredicates.put(first, p);
                continue;
            }
            if (child.contains(minus)) {
                this.outputRelations.add(first);
                return;
            }
            return;
        }
    }

    private Predicate predicate(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(identifier)) {
            return new PredRef(root.content(src), this);
        }
        Predicate ret = this.isBrackets(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isParenthesis(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isConjunction(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isDisjunction(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isDifference(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isAtomicPredicate(root, src, input);
        if (ret != null) {
            return ret;
        }
        throw new AssertionError((Object)("unexpected case for: " + root.content(src)));
    }

    private Predicate isConjunction(ParseNode root, List<LexerToken> src, String input) {
        ParseNode first = null;
        boolean legitimateOper = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!legitimateOper) {
                if (child.contains(conj)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input);
            Predicate rgt = this.predicate(child, src, input);
            return new CompositeExpr(lft, rgt, Oper.CONJUNCTION);
        }
        return null;
    }

    private Predicate isDisjunction(ParseNode root, List<LexerToken> src, String input) {
        ParseNode first = null;
        boolean legitimateOper = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!legitimateOper) {
                if (child.contains(disj)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input);
            Predicate rgt = this.predicate(child, src, input);
            return new CompositeExpr(lft, rgt, Oper.DISJUNCTION);
        }
        return null;
    }

    private Predicate isDifference(ParseNode root, List<LexerToken> src, String input) {
        ParseNode first = null;
        boolean isLegit = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!isLegit) {
                if (child.contains(minus)) {
                    isLegit = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input);
            Predicate rgt = this.predicate(child, src, input);
            return new CompositeExpr(lft, rgt, Oper.DIFFERENCE);
        }
        return null;
    }

    private Predicate isParenthesis(ParseNode root, List<LexerToken> src, String input) {
        boolean isOpenParen = false;
        for (ParseNode child : root.children()) {
            if (!isOpenParen) {
                if (child.contains(openPar)) {
                    isOpenParen = true;
                    continue;
                }
                return null;
            }
            if (isOpenParen && child.contains(predicate)) {
                return this.predicate(child, src, input);
            }
            return null;
        }
        return null;
    }

    private Predicate isBrackets(ParseNode root, List<LexerToken> src, String input) {
        boolean isOpenBr = false;
        for (ParseNode child : root.children()) {
            if (!isOpenBr) {
                if (child.contains(openBr)) {
                    isOpenBr = true;
                    continue;
                }
                return null;
            }
            if (isOpenBr) {
                if (child.contains(header)) {
                    return this.header(child, src, input);
                }
                if (!child.contains(closeBr)) continue;
                return new MaterializedPredicate(new ArrayList<String>(), src, "[]");
            }
            return null;
        }
        return null;
    }

    private MaterializedPredicate header(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(attribute)) {
            ArrayList<String> hdr = new ArrayList<String>();
            hdr.add(root.content(src));
            return new MaterializedPredicate(hdr, src, "[" + root.content(src) + "]");
        }
        MaterializedPredicate ret = null;
        for (ParseNode child : root.children()) {
            if (ret == null) {
                ret = this.header(child, src, input);
                continue;
            }
            ret = MaterializedPredicate.join(ret, this.header(child, src, input));
        }
        return ret;
    }

    private Predicate isAtomicPredicate(ParseNode root, List<LexerToken> src, String input) {
        Predicate ret = this.isExclamation(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeContent(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeMatchingSrc(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isSameNode(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeAncestorDescendant(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isAggregate(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isPositionalRelation(root, src, input);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private Predicate isAggregate(ParseNode root, List<LexerToken> src, String input) {
        Boolean slash1 = null;
        Boolean slash2 = null;
        ParseNode attribute = null;
        boolean seenOpenParen = false;
        ParseNode p = null;
        for (ParseNode child : root.children()) {
            if (slash1 == null) {
                if (child.contains(slash)) {
                    slash1 = true;
                    continue;
                }
                if (child.contains(backslash)) {
                    slash1 = false;
                    continue;
                }
                return null;
            }
            if (slash2 == null) {
                if (child.contains(slash)) {
                    slash2 = true;
                    continue;
                }
                if (child.contains(backslash)) {
                    slash2 = false;
                    continue;
                }
                return null;
            }
            if (attribute == null) {
                attribute = child;
                continue;
            }
            if (!seenOpenParen) {
                if (child.contains(openPar)) {
                    seenOpenParen = true;
                    continue;
                }
                throw new AssertionError((Object)"Syntax error not caught by parsing?");
            }
            p = child;
            break;
        }
        Predicate predicate = this.predicate(p, src, input);
        return new AggregatePredicate(attribute.content(src), predicate, slash1, slash2);
    }

    private Predicate isExclamation(ParseNode root, List<LexerToken> src, String input) {
        boolean isExcl = false;
        for (ParseNode child : root.children()) {
            if (!isExcl) {
                if (child.contains(excl)) {
                    isExcl = true;
                    continue;
                }
                return null;
            }
            if (!isExcl) continue;
            return new CompositeExpr(this.predicate(child, src, input), null, Oper.NEGATION);
        }
        return null;
    }

    private Predicate isNodeContent(ParseNode root, List<LexerToken> src, String input) {
        boolean openBrace = false;
        String first = null;
        boolean legitimateOper = false;
        String second = null;
        for (ParseNode child : root.children()) {
            if (!openBrace) {
                if (child.contains(openBr)) {
                    openBrace = true;
                    continue;
                }
                return null;
            }
            if (first == null && child.contains(node)) {
                if (child.from + 1 == child.to || child.contains(node_parent) || child.contains(node_predecessor) || child.contains(node_successor) || child.contains(referenced_node)) {
                    first = child.content(src);
                    continue;
                }
                return null;
            }
            if (!legitimateOper) {
                if (child.contains(closePar)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            if (second == null) {
                second = child.content(src);
                continue;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        Integer symbol = (Integer)this.parser.symbolIndexes.get(second);
        if (symbol == null) {
            throw new AssertionError((Object)("Symbol '" + second + "' not found"));
        }
        return new NodeContent(first, symbol);
    }

    private Predicate isNodeMatchingSrc(ParseNode root, List<LexerToken> src, String input) {
        boolean legitimateAt1 = false;
        String first = null;
        boolean legitimateOper = false;
        boolean legitimateAt2 = false;
        String second = null;
        for (ParseNode child : root.children()) {
            if (!legitimateAt1) {
                if (child.contains(srcPtr)) {
                    legitimateAt1 = true;
                    continue;
                }
                return null;
            }
            if (first == null) {
                if (child.contains(node)) {
                    first = child.content(src);
                    continue;
                }
                return null;
            }
            if (!legitimateOper) {
                if (child.contains(eq)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            if (!legitimateAt2) {
                if (child.contains(srcPtr)) {
                    legitimateAt2 = true;
                    continue;
                }
                if (child.contains(string_literal)) {
                    return new NodeMatchingSrc(first, child.content(src));
                }
                return null;
            }
            if (second == null) {
                if (child.contains(node)) {
                    second = child.content(src);
                    continue;
                }
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new NodesWMatchingSrc(first, second);
    }

    private Predicate isNodeAncestorDescendant(ParseNode root, List<LexerToken> src, String input) {
        boolean isStrict = true;
        Pair<String, String> p = this.binaryPredicateNames(root, src, lt);
        if (p == null) {
            p = this.binaryPredicateNames(root, src, lt, eq);
            if (p == null) {
                return null;
            }
            isStrict = false;
        }
        return new AncestorDescendantNodes(p.first(), p.second(), isStrict);
    }

    private Predicate isSameNode(ParseNode root, List<LexerToken> src, String input) {
        Pair<String, String> p = this.binaryPredicateNames(root, src, eq);
        if (p == null) {
            return null;
        }
        return new SameNodes(p.first(), p.second());
    }

    public Pair<String, String> binaryPredicateNames(ParseNode root, List<LexerToken> src, int oper) throws AssertionError {
        return this.binaryPredicateNames(root, src, oper, -1);
    }

    public Pair<String, String> binaryPredicateNames(ParseNode root, List<LexerToken> src, int oper1, int oper2) throws AssertionError {
        String first = null;
        boolean legitimateOper1 = false;
        boolean legitimateOper2 = -1 == oper2;
        String second = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                if (child.contains(node)) {
                    first = child.content(src);
                    if (this.namedPredicates.containsKey(first)) {
                        throw new AssertionError((Object)("Error: " + first + " is a predicate, not predicate attribute within binary operation"));
                    }
                    continue;
                }
                return null;
            }
            if (!legitimateOper1) {
                if (child.contains(oper1)) {
                    legitimateOper1 = true;
                    continue;
                }
                return null;
            }
            if (!legitimateOper2) {
                if (child.contains(oper2)) {
                    legitimateOper2 = true;
                    continue;
                }
                return null;
            }
            if (second == null) {
                if (child.contains(node)) {
                    second = child.content(src);
                    if (this.namedPredicates.containsKey(second)) {
                        throw new AssertionError((Object)("Error: " + second + " is a predicate, not predicate attribute within binary operation"));
                    }
                    continue;
                }
                return null;
            }
            if (!child.contains(semicol)) {
                throw new AssertionError((Object)("unexpected case for: " + root.content(src)));
            }
        }
        return new Pair<Object, Object>(first, second);
    }

    private Predicate isPositionalRelation(ParseNode root, List<LexerToken> src, String input) {
        Position first = null;
        boolean isGT = false;
        boolean isReflexive = false;
        Position second = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = this.nodeRelativePosition(child, src, input);
                if (first != null) continue;
                return null;
            }
            if (child.contains(lt)) {
                isGT = true;
                continue;
            }
            if (child.contains(eq)) {
                isReflexive = true;
                continue;
            }
            if (second == null) {
                second = this.nodeRelativePosition(child, src, input);
                if (second != null) continue;
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new PositionalRelation(first, second, isReflexive, isGT, this);
    }

    private Position nodeRelativePosition(ParseNode root, List<LexerToken> src, String input) {
        String name = null;
        Position t = null;
        int num = -1;
        for (ParseNode child : root.children()) {
            if (name == null && child.contains(node) || t instanceof BindVar) {
                name = child.content(src);
                continue;
            }
            if (child.contains(digits)) {
                num = Integer.decode(child.content(src));
                if (t == null) continue;
                ((Composite)t).addendum = num;
                continue;
            }
            if (t != null) continue;
            if (child.contains(openBr)) {
                t = new Head(name);
                continue;
            }
            if (child.contains(closePar)) {
                t = new Tail(name);
                continue;
            }
            if (child.contains(col)) {
                t = new BindVar(name);
                continue;
            }
            if (child.contains(plus)) continue;
            if (child.contains(node_position)) {
                Position tmp = this.nodeRelativePosition(child, src, input);
                name = tmp.name;
                t = new Composite(tmp, num);
                continue;
            }
            throw new AssertionError();
        }
        if (name == null) {
            throw new AssertionError((Object)"name == null");
        }
        if (t == null) {
            throw new AssertionError((Object)"t == null");
        }
        t.name = name;
        return t;
    }

    public Map<String, MaterializedPredicate> eval(Parsed target) {
        return this.eval(target, null);
    }

    public Map<String, MaterializedPredicate> eval(Parsed target, Object action) {
        ParseNode root = target.getRoot();
        if (timing) {
            System.out.println("tree depth =" + root.treeDepth());
            System.out.println("#tokens =" + target.getSrc().size());
        }
        long t1 = System.currentTimeMillis();
        HashMap<String, MaterializedPredicate> ret = new HashMap<String, MaterializedPredicate>();
        for (String predVar : this.execOrder) {
            long t11 = System.currentTimeMillis();
            if (debug) {
                System.out.println(">=================================<     " + predVar);
            }
            MaterializedPredicate table = null;
            table = new MaterializedPredicate(predVar, this._eval(target, predVar));
            if (timing) {
                System.out.print(predVar + " eval time = " + (System.currentTimeMillis() - t11));
                System.out.println("       (cardinality=" + table.cardinality() + ")");
            }
            table.name = predVar;
            ret.put(predVar, table);
            this.namedPredicates.put(predVar, table);
            table.trimAttributes();
            if (!debug) continue;
            System.out.println(predVar + "=" + table);
        }
        this.namedPredicates = new HashMap<String, Predicate>();
        for (String key : this.compiledInstance.namedPredicates.keySet()) {
            this.namedPredicates.put(key, this.compiledInstance.namedPredicates.get(key).copy(this));
        }
        long t2 = System.currentTimeMillis();
        if (debug || timing) {
            System.out.println("eval time = " + (t2 - t1));
        }
        if (action != null) {
            for (String predVar : this.execOrder) {
                if (!this.outputRelations.contains(predVar)) continue;
                if (debug) {
                    System.out.println("-------->>>   " + predVar);
                }
                Class<?> c = action.getClass();
                try {
                    Method callback = c.getDeclaredMethod(predVar, Parsed.class, Map.class);
                    callback.setAccessible(true);
                    MaterializedPredicate mp = (MaterializedPredicate)ret.get(predVar);
                    for (Tuple t : mp.tuples) {
                        HashMap<String, ParseNode> tuple = new HashMap<String, ParseNode>();
                        for (int j = 0; j < mp.arity(); ++j) {
                            String colName = mp.getAttribute(j);
                            ParseNode node = mp.getAttribute(t, colName);
                            tuple.put(colName, node);
                        }
                        callback.invoke(action, target, tuple);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    System.err.println(predVar + " callback: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        if (debug || timing) {
            System.out.println("callback time = " + (System.currentTimeMillis() - t2));
        }
        return ret;
    }

    private MaterializedPredicate _eval(Parsed target, String predVar) {
        Predicate evaluatedPredicate;
        MaterializedPredicate ret;
        if ("descendantNodes".equals(predVar)) {
            // empty if block
        }
        if ((ret = (evaluatedPredicate = this.namedPredicates.get(predVar)).eval(target)) != null) {
            return ret;
        }
        AttributeDefinitions varDefs = new AttributeDefinitions(predVar, this.namedPredicates);
        varDefs.evalDimensions(target, false);
        boolean firstTime = true;
        if (debug) {
            System.out.print("Eval space = ");
            for (String string : varDefs.listDimensions()) {
                System.out.print((firstTime ? "" : "x") + varDefs.getDimensionContent(string).cardinality());
                firstTime = false;
            }
            System.out.println();
        }
        firstTime = true;
        String firstDimension = null;
        for (String dim : varDefs.listDimensions()) {
            if (firstDimension != null && varDefs.getDimensionContent(dim).cardinality() >= varDefs.getDimensionContent(firstDimension).cardinality()) continue;
            firstDimension = dim;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(firstDimension);
        Attribute firstAttr = (Attribute)varDefs.get(firstDimension);
        ret = ((IndependentAttribute)firstAttr).getContent();
        while (hashSet.size() < varDefs.listDimensions().size()) {
            String current = varDefs.minimalRelatedDimension(hashSet, ret.cardinality());
            if (current == null) {
                throw new AssertionError((Object)("Cartesian product evaluation: failed to find attribute joined to " + hashSet));
            }
            hashSet.add(current);
            Attribute second = (Attribute)varDefs.get(current);
            MaterializedPredicate pred2 = ((IndependentAttribute)second).getContent();
            Predicate filter = new True();
            if (hashSet.size() != varDefs.listDimensions().size()) {
                for (String a : ret.attributes) {
                    if (ret.name != null) {
                        a = ret.name + "." + a;
                    }
                    for (String b : pred2.attributes) {
                        Predicate rel;
                        if (pred2.name != null) {
                            b = pred2.name + "." + b;
                        }
                        if ((rel = evaluatedPredicate.isRelated(a, b, varDefs)) == null) continue;
                        if (filter instanceof True) {
                            filter = rel;
                            continue;
                        }
                        if (filter == rel) continue;
                        filter = new CompositeExpr(filter, rel, Oper.CONJUNCTION);
                    }
                }
                if (filter instanceof True && 1 < varDefs.getDimensionContent(current).cardinality() && 1 < ret.cardinality()) {
                    throw new AssertionError((Object)"Cartesian product evaluation; check for missing binary predicates");
                }
            } else {
                filter = evaluatedPredicate;
            }
            ret = MaterializedPredicate.filteredCartesianProduct(ret, pred2, filter, varDefs, target.getRoot());
            if (!debug) continue;
            System.out.println("dim#" + hashSet.size() + ",cardinality=" + ret.cardinality());
        }
        ret = MaterializedPredicate.filter(ret, evaluatedPredicate, varDefs, target.getRoot());
        if (hashSet.size() == varDefs.listDimensions().size()) {
            return ret;
        }
        throw new AssertionError((Object)("Missing dyadic predicate in predvar " + predVar + "; won't evaluate cartesian product"));
    }
}

