/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.BindVar;
import oracle.dbtools.arbori.CompositeExpr;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.NodeContent;
import oracle.dbtools.arbori.NodeMatchingSrc;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.PositionalRelation;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.True;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

public class IndependentAttribute
extends Attribute {
    Map<String, Predicate> db;
    private MaterializedPredicate content;
    private Predicate failfastFilter = null;

    public IndependentAttribute(String name, Map<String, Predicate> db) {
        this.name = name;
        this.db = db;
    }

    public MaterializedPredicate getContent() {
        return this.content;
    }

    public void initContent(ParseNode root, List<LexerToken> src, Map<String, Attribute> varDefs, String predVar) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(this.name);
        for (String candidate : varDefs.keySet()) {
            Attribute attr = varDefs.get(candidate);
            if (attr == null) {
                attr = null;
            }
            if (attributes.contains(candidate) || !attr.isDependent(this.name, varDefs)) continue;
            attributes.add(candidate);
        }
        this.content = new MaterializedPredicate(attributes, src, null);
        block1: for (ParseNode node : root.descendants()) {
            if (node.from == 10 && node.to == 11) {
                node.from = 10;
            }
            Set<Tuple> candidates = new TreeSet<Tuple>();
            ParseNode[] t = new ParseNode[this.content.arity()];
            candidates.add(new Tuple(t));
            t[this.content.getAttribute((String)this.name).intValue()] = node;
            for (String attr : attributes) {
                candidates = this.content.assignDependencyChain(attr, candidates, varDefs, root);
                if (candidates.size() != 0) continue;
                continue block1;
            }
            candidates = this.filterUnaryPredicates(varDefs, predVar, this.content.attributePositions, candidates, root, src);
            for (Tuple tmp : candidates) {
                this.content.tuples.add(tmp);
            }
        }
    }

    int getLimits() {
        return this.content.cardinality();
    }

    void putFilter(Predicate filter) {
        this.failfastFilter = filter;
    }

    private Set<Tuple> filterUnaryPredicates(Map<String, Attribute> varDefs, String predVar, Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root, List<LexerToken> src) {
        if (this.failfastFilter == null) {
            Predicate fullPredicate = this.db.get(predVar);
            this.failfastFilter = this.unaryConjunctedPred(varDefs, fullPredicate);
        }
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        for (Tuple t : candidates) {
            if (!this.failfastFilter.eval(attributePositions, t.values, src)) continue;
            ret.add(t);
        }
        return ret;
    }

    private Predicate unaryConjunctedPred(Map<String, Attribute> varDefs, Predicate fullPredicate) {
        LinkedList<Predicate> tmp = new LinkedList<Predicate>();
        for (String s : varDefs.keySet()) {
            Attribute attr = varDefs.get(s);
            if (!attr.isDependent(this.name, varDefs)) continue;
            this.findUnaryConjuncts(tmp, fullPredicate, attr.name);
        }
        Predicate ret = new True();
        for (Predicate extra : tmp) {
            ret = this.appendProposition(extra, ret);
        }
        return ret;
    }

    private Predicate appendProposition(Predicate extra, Predicate p) {
        return new CompositeExpr(extra, p, Oper.CONJUNCTION);
    }

    private void findUnaryConjuncts(List<Predicate> ret, Predicate p, String nodeVar) {
        if (p instanceof CompositeExpr) {
            CompositeExpr ce = (CompositeExpr)p;
            if (ce.oper == Oper.CONJUNCTION) {
                this.findUnaryConjuncts(ret, ce.lft, nodeVar);
                this.findUnaryConjuncts(ret, ce.rgt, nodeVar);
            }
            if (ce.oper == Oper.DISJUNCTION) {
                this.addDisjunct(ce, ret, nodeVar);
            }
        } else if (p instanceof NodeContent) {
            NodeContent nc = (NodeContent)p;
            if (nc.nodeVar.equals(nodeVar)) {
                ret.add(nc);
            }
        } else if (p instanceof PositionalRelation) {
            PositionalRelation pr = (PositionalRelation)p;
            if (pr.a instanceof BindVar && pr.b.name.equals(nodeVar) || pr.b instanceof BindVar && pr.a.name.equals(nodeVar)) {
                ret.add(pr);
            }
        } else if (p instanceof NodeMatchingSrc) {
            NodeMatchingSrc nms = (NodeMatchingSrc)p;
            if (nms.nodeVar.equals(nodeVar)) {
                ret.add(nms);
            }
        }
    }

    private void addDisjunct(CompositeExpr ce, List<Predicate> ret, String nodeVar) {
        NodeMatchingSrc nms;
        PositionalRelation pr;
        NodeContent nc;
        IdentedPredicate lft = null;
        IdentedPredicate rgt = null;
        if (ce.lft instanceof NodeContent) {
            nc = (NodeContent)ce.lft;
            if (nc.nodeVar.equals(nodeVar)) {
                lft = nc;
            }
        }
        if (ce.lft instanceof PositionalRelation) {
            pr = (PositionalRelation)ce.lft;
            if (pr.a instanceof BindVar && pr.b.name.equals(nodeVar) || pr.b instanceof BindVar && pr.a.name.equals(nodeVar)) {
                lft = pr;
            }
        }
        if (ce.lft instanceof NodeMatchingSrc) {
            nms = (NodeMatchingSrc)ce.lft;
            if (nms.nodeVar.equals(nodeVar)) {
                lft = nms;
            }
        }
        if (ce.rgt instanceof NodeContent) {
            nc = (NodeContent)ce.rgt;
            if (nc.nodeVar.equals(nodeVar)) {
                rgt = nc;
            }
        }
        if (ce.rgt instanceof PositionalRelation) {
            pr = (PositionalRelation)ce.rgt;
            if (pr.a instanceof BindVar && pr.b.name.equals(nodeVar) || pr.b instanceof BindVar && pr.a.name.equals(nodeVar)) {
                rgt = pr;
            }
        }
        if (ce.rgt instanceof NodeMatchingSrc) {
            nms = (NodeMatchingSrc)ce.rgt;
            if (nms.nodeVar.equals(nodeVar)) {
                rgt = nms;
            }
        }
        if (lft != null && rgt != null) {
            ret.add(new CompositeExpr(ce.lft, ce.rgt, Oper.DISJUNCTION));
        }
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        throw new AssertionError((Object)"or should just return candidates?");
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return null;
    }
}

