/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.app.Format;
import oracle.dbtools.app.XML2Table;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.util.Pair;

public class Persist2XML
extends XML2Table {
    HashMap<String, Object> parameters = new HashMap();

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("A", "a");
        tmp.put("B", 11);
        tmp.put("C", true);
        tmp.put("D", (Object)Format.Case.lower);
        URL file = Paths.get("/temp", "persist.xml").toUri().toURL();
        Persist2XML.write(file, tmp);
        System.out.println(Persist2XML.read(file));
    }

    public static void write(URL url, Object what) throws IOException {
        FileOutputStream fos = new FileOutputStream(url.getFile());
        String xml = "<options>" + Persist2XML.dumpXML(what) + "</options>";
        fos.write(xml.getBytes());
        fos.close();
    }

    private static String dumpXML(Object what) {
        if (what instanceof Pair) {
            Pair pair = (Pair)what;
            return "<" + pair.first().toString() + ">" + pair.second().toString() + "</" + pair.first().toString() + ">\n";
        }
        if (what instanceof Map) {
            Map map = (Map)what;
            StringBuilder ret = new StringBuilder();
            for (Object key : map.keySet()) {
                ret.append("<" + key.toString() + ">" + map.get(key).toString() + "</" + key.toString() + ">\n");
            }
            return ret.toString();
        }
        if (what instanceof Object) {
            StringBuilder ret = new StringBuilder();
            for (Object elem : (Collection)what) {
                ret.append(Persist2XML.dumpXML(elem));
            }
            return ret.toString();
        }
        throw new AssertionError((Object)("what instanceof " + what.getClass().getName()));
    }

    public static Map<String, Object> read(URL url) throws IOException {
        FileInputStream fis = new FileInputStream(url.getFile());
        byte[] bytes = new byte[4096];
        StringBuffer tmp = new StringBuffer();
        BufferedInputStream bin = new BufferedInputStream(fis);
        int bytesRead = bin.read(bytes, 0, bytes.length);
        while (bytesRead != -1) {
            tmp.append(new String(bytes).substring(0, bytesRead));
            bytesRead = bin.read(bytes, 0, bytes.length);
        }
        Persist2XML xmlProgram = new Persist2XML();
        String input = tmp.toString();
        xmlProgram.run(input, null, xmlProgram);
        return xmlProgram.parameters;
    }

    @Override
    void tupleNodes(Parsed target, Map<String, ParseNode> tuple) {
    }

    @Override
    void values(Parsed target, Map<String, ParseNode> tuple) {
        String value = target.getSrc().get((int)tuple.get((Object)"value").from).content;
        Object obj = value;
        if (value.equalsIgnoreCase("false")) {
            obj = false;
        }
        if (value.equalsIgnoreCase("true")) {
            obj = true;
        }
        try {
            obj = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ("LOWER".equalsIgnoreCase(value)) {
            obj = Format.Case.lower;
        }
        if ("UPPER".equalsIgnoreCase(value)) {
            obj = Format.Case.UPPER;
        }
        if ("InitCap".equalsIgnoreCase(value)) {
            obj = Format.Case.InitCap;
        }
        if ("SingleLine".equalsIgnoreCase(value)) {
            obj = Format.InlineComments.SingleLine;
        }
        if ("MultiLine".equalsIgnoreCase(value)) {
            obj = Format.InlineComments.MultiLine;
        }
        if ("Before".equalsIgnoreCase(value)) {
            obj = Format.Breaks.Before;
        }
        if ("After".equalsIgnoreCase(value)) {
            obj = Format.Breaks.After;
        }
        if ("NoSpace".equalsIgnoreCase(value)) {
            obj = Format.Space.NoSpace;
        }
        if ("Inside".equalsIgnoreCase(value)) {
            obj = Format.Space.Inside;
        }
        if ("Outside".equalsIgnoreCase(value)) {
            obj = Format.Space.Outside;
        }
        this.parameters.put(target.getSrc().get((int)tuple.get((Object)"attribute").from).content, obj);
    }
}

