/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.util.Service;
import oracle.jdbc.OracleDriver;

public class Literals2Binds {
    public static final String prefix = "AUXSQLDBIND";
    private String sql;
    private Map<String, String> binds;

    public String getSql() {
        return this.sql;
    }

    public Map<String, String> getBinds() {
        return this.binds;
    }

    private Literals2Binds(String sql, Map<String, String> binds) {
        this.sql = sql;
        this.binds = binds;
    }

    public static Literals2Binds Literals2BindsNull(String sql) {
        return new Literals2Binds(sql, new HashMap<String, String>());
    }

    public static Literals2Binds bindAid(String origSql) {
        ArrayList<String> existingBinds = Parser.getInstance().getBindNames(origSql);
        int maxBind = 0;
        for (String eb : existingBinds) {
            try {
                int candidate = Integer.parseInt(eb);
                if (maxBind >= candidate) continue;
                maxBind = candidate;
            }
            catch (NumberFormatException candidate) {}
        }
        Map<Integer, String> args = SqlRecognizer.fragmentAtLocation(origSql, "arg");
        Map<Integer, String> pCall = SqlRecognizer.fragmentAtLocation(origSql, "procedureCall");
        String sql = origSql;
        HashMap<String, String> tmp = new HashMap<String, String>();
        int pos = maxBind;
        int adjust = 0;
        for (int key : args.keySet()) {
            boolean skip = false;
            for (int pKey : pCall.keySet()) {
                String call = pCall.get(pKey).toLowerCase();
                if (pKey >= key || key >= pKey + call.length() || !call.startsWith("dbms_sql") && !call.startsWith("userenv(") && !call.startsWith("sys_context(") && !call.startsWith("sys_guid(") && !call.startsWith("sys_typeid(") && !call.startsWith("xmltype(")) continue;
                skip = true;
            }
            if (skip) continue;
            ++pos;
            String literal = args.get(key);
            if (1 < literal.length() && 0 <= literal.substring(1, literal.length() - 1).indexOf(39)) continue;
            boolean isStr = false;
            if (literal.startsWith("'") && literal.endsWith("'")) {
                isStr = true;
            }
            String bind = "TO_NUMBER(:AUXSQLDBIND" + pos + ")";
            if (isStr) {
                bind = "TO_CHAR(:AUXSQLDBIND" + pos + ")";
            }
            sql = sql.substring(0, key + adjust) + bind + sql.substring(key + literal.length() + adjust);
            adjust += bind.length() - literal.length();
            if (isStr) {
                literal = literal.substring(1, literal.length() - 1);
            }
            tmp.put(prefix + pos, literal);
        }
        return new Literals2Binds(sql, tmp);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.sql + "\n");
        for (String bind : this.binds.keySet()) {
            ret.append(bind + "->" + this.binds.get(bind) + "\n");
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String plsqlBlock) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection c = DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521/DB12PERF", "hr", "hr");
        CallableStatement cs = null;
        try {
            cs = c.prepareCall("begin dbms_output.enable(1000000); end;");
            cs.execute();
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        Literals2Binds bp = Literals2Binds.bindAid(plsqlBlock);
        cs = c.prepareCall(bp.getSql());
        Map<String, String> bindsMap = bp.getBinds();
        int pos = 1;
        for (String bindName : bindsMap.keySet()) {
            cs.setString(pos++, bindsMap.get(bindName));
        }
        try {
            cs.execute();
            System.out.println("No Exception");
            SQLWarning sw = null;
            for (sw = cs.getWarnings(); sw != null; sw = sw.getNextWarning()) {
                String w = sw.getMessage();
                System.out.println("ZZ: " + w);
            }
            System.out.println("OP: " + Literals2Binds.getDBMSOUTPUT(c));
        }
        finally {
            if (cs != null) {
                cs.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDBMSOUTPUT(Connection c) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (CallableStatement stmt = null;){
            stmt = c.prepareCall("declare\nl_line varchar2(32767);\nl_done number;\nl_buffer varchar2(32767) := '';\nl_lengthbuffer number := 0;\nl_lengthline number := 0;\nbegin \nloop \n\tdbms_output.get_line( l_line, l_done ); \n\tif (l_buffer is null) then \n\t  l_lengthbuffer := 0; \n\telse \n\t  l_lengthbuffer := length(l_buffer); \n\tend if; \n\tif (l_line is null) then \n\t  l_lengthline := 0; \n\telse \n\t  l_lengthline := length(l_line); \n\tend if; \nexit when l_lengthbuffer + l_lengthline > :maxbytes OR l_lengthbuffer + l_lengthline > 32767 OR l_done = 1; \nl_buffer := l_buffer || l_line || chr(10); \nend loop; \n:done := l_done; \n:buffer := l_buffer; \n:line := l_line; \nend;");
            boolean useLargeBuffer = true;
            if (useLargeBuffer) {
                stmt.registerOutParameter(2, 4);
                stmt.registerOutParameter(3, 12);
                stmt.registerOutParameter(4, 12);
            } else {
                stmt.registerOutParameter(2, 4);
                stmt.registerOutParameter(3, 12);
            }
            do {
                stmt.setInt(1, 1000);
                stmt.executeUpdate();
                if (useLargeBuffer) {
                    String got = stmt.getString(3);
                    if (got != null) {
                        sb.append(got);
                    }
                    if ((got = stmt.getString(4)) != null) {
                        sb.append(got + "\n");
                        continue;
                    }
                    sb.append("\n");
                    continue;
                }
                sb.append(stmt.getString(3));
            } while (stmt.getInt(2) != 1);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String input = "exec dbms_output.put_line(123,'x','HELLO'||systimestamp);";
        input = "begin \nhello(:1,:3,'abc'); \nDBMS_OUTPUT.PUT_LINE('a''b',q'[&USER_ACCOUNT]','Command: ' || sql_text); \nDBMS_SQL.PARSE(odmruser_cursor, 'select grantee as \"USER\" from dba_role_privs where granted_role = ''ODMRUSER''', DBMS_SQL.NATIVE);  \nbye(42,'42'); \n end;\n";
        input = "declare \n  x integer; \nbegin \n  select 1 into x from dual where ABS(11)=11; \nend;\n/";
        input = Service.readFile(SqlEarley.class, "test.sql");
        Map<Integer, String> fragments = SqlRecognizer.fragmentAtLocation(input, "sql_statement");
        for (int pos : fragments.keySet()) {
            System.out.println("--------------------------------------------");
            String chunk = fragments.get(pos);
            if (chunk.startsWith("EXECUTE")) continue;
            Literals2Binds bp = Literals2Binds.bindAid(chunk);
            System.out.println(bp.toString());
            if (chunk.endsWith("/") || chunk.endsWith(";")) {
                chunk = chunk.substring(0, chunk.length() - 1);
            }
            Literals2Binds.test(chunk);
        }
    }
}

