/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class Format {
    public static String singleLineComments = "singleLineComments";
    public static String kwCase = "kwCase";
    public static String idCase = "idCase";
    public static String formatThreshold = "formatThreshold";
    public static String alignTypeDecl = "alignTypeDecl";
    public static String identSpaces = "identSpaces";
    public static String useTab = "useTab";
    public static String breaksComma = "breaksComma";
    public static String breaksConcat = "breaksConcat";
    public static String breaksAroundLogicalConjunctions = "breaksAroundLogicalConjunctions";
    public static String breaksAfterSelectFromWhere = "breaksAfterSelectFromWhere";
    public static String commasPerLine = "commasPerLine";
    public static String breakOnCompositeLogicalExpressions = "breakOnCompositeLogicalExpressions";
    public static String breakOnSubqueries = "breakOnSubqueries";
    public static String breakAnsiiJoin = "breakAnsiiJoin";
    public static String maxCharLineSize = "maxCharLineSize";
    public static String forceLinebreaksBeforeComment = "forceLinebreaksBeforeComment";
    public static String extraLinesAfterSignificantStatements = "extraLinesAfterSignificantStatements";
    public static String breakAfterCase = "breakAfterCase";
    public static String breakAfterWhen = "breakAfterWhen";
    public static String breakAfterThen = "breakAfterThen";
    public static String breakAfterElse = "breakAfterElse";
    public static String spaceAroundOperators = "spaceAroundOperators";
    public static String spaceAfterCommas = "spaceAfterCommas";
    public static String spaceAroundBrackets = "spaceAroundBrackets";
    public static Map<String, Object> options = new HashMap<String, Object>();
    public int inputPos = -1;
    public int outputPos = -1;
    static final String path = "/oracle/dbtools/app/";
    static SqlProgram programInstance;
    Map<Integer, Integer> posDepths = new HashMap<Integer, Integer>();
    int commasCount = 0;
    Map<Integer, String> newlinePositions = new HashMap<Integer, String>();
    Map<String, String> casedIds = new HashMap<String, String>();
    Map<String, Integer> maxIdLengthInScope = new HashMap<String, Integer>();
    Map<Integer, String> ids2scope = new HashMap<Integer, String>();
    Set<Integer> notPaddedParenthesis = new HashSet<Integer>();

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(SqlEarley.class, "test.sql");
        Program.timing = 1000 < input.length();
        SqlEarley.visualize = false;
        SqlEarley.main(new String[]{input});
        Format format = new Format();
        options.put(spaceAroundBrackets, (Object)Space.Inside);
        String output = format.format(input, true);
        if (input.length() < 10000) {
            System.out.println("----------------- output: ------------------");
            System.out.println(output);
        }
    }

    public static void setDefaultOptions() {
        options.put(singleLineComments, (Object)InlineComments.None);
        options.put(kwCase, (Object)Case.UPPER);
        options.put(idCase, (Object)Case.lower);
        options.put(formatThreshold, 1);
        options.put(alignTypeDecl, true);
        options.put(identSpaces, 4);
        options.put(useTab, false);
        options.put(breaksComma, (Object)Breaks.After);
        options.put(breaksConcat, (Object)Breaks.Before);
        options.put(breaksAroundLogicalConjunctions, true);
        options.put(breaksAfterSelectFromWhere, true);
        options.put(commasPerLine, 1);
        options.put(breakOnCompositeLogicalExpressions, true);
        options.put(breakOnSubqueries, true);
        options.put(breakAnsiiJoin, true);
        options.put(maxCharLineSize, 128);
        options.put(forceLinebreaksBeforeComment, false);
        options.put(extraLinesAfterSignificantStatements, true);
        options.put(breakAfterCase, true);
        options.put(breakAfterWhen, true);
        options.put(breakAfterThen, true);
        options.put(breakAfterElse, true);
        options.put(spaceAroundOperators, true);
        options.put(spaceAfterCommas, false);
        options.put(spaceAroundBrackets, (Object)Space.NoSpace);
    }

    public static void setOptions(Map<String, Object> changed) {
        for (String key : changed.keySet()) {
            options.put(key, changed.get(key));
        }
    }

    public String format(String input) throws IOException {
        return this.format(input, false);
    }

    public String format(String input, boolean ignoreSyntaxError) throws IOException {
        StringBuilder output = new StringBuilder();
        Parsed target = null;
        if (programInstance == null) {
            programInstance = new SqlProgram(Service.readFile(Format.class, "/oracle/dbtools/app/format.prg"));
        }
        try {
            List<LexerToken> src = LexerToken.parse(input);
            if (ignoreSyntaxError) {
                SqlEarley earley = SqlEarley.getInstance();
                Matrix matrix = new Matrix(earley);
                earley.parse(src, matrix);
                ParseNode root = earley.forest(src, matrix);
                target = new Parsed(input, src, root);
            } else {
                target = new Parsed(input, src, (Earley)SqlEarley.getInstance(), new String[]{"sql_statements", "subprg_body", "expr", "sql_stmt", "basic_d"});
            }
            programInstance.eval(target, this);
        }
        catch (SyntaxError e) {
            return input.substring(0, e.end) + "\n/*** " + e.getDetailedMessage() + "\n ***/" + input.substring(e.end);
        }
        int unary_add_op = SqlEarley.getInstance().getSymbol("unary_add_op");
        int compound_expression822 = SqlEarley.getInstance().getSymbol("compound_expression[8,22)");
        int sql_statement = SqlEarley.getInstance().getSymbol("sql_statement");
        List<LexerToken> fullCode = LexerToken.parse(input, true);
        int pos = -1;
        String priorIdent = null;
        LexerToken prior = null;
        int cumulativeChars = 0;
        int lastNewLine = -1;
        for (LexerToken t : fullCode) {
            if (this.outputPos < 0 && this.inputPos < t.begin) {
                this.outputPos = output.length();
            }
            if (t.type == Token.WS) {
                if (!"\n".equals(t.content)) continue;
                lastNewLine = t.end;
                continue;
            }
            if (t.type == Token.COMMENT || t.type == Token.LINE_COMMENT) {
                if (((Boolean)options.get(forceLinebreaksBeforeComment)).booleanValue() && prior != null && lastNewLine < prior.end) {
                    output.append("\n    ");
                }
                if (prior != null) {
                    output.append(input.substring(prior.end, t.begin));
                }
                if (t.content.endsWith("\r")) {
                    t.content = t.content.substring(0, t.content.length() - 1) + '\n';
                }
                String pureContent = t.content;
                boolean endsWNL = false;
                if (pureContent.endsWith("\n")) {
                    pureContent = pureContent.substring(0, pureContent.length() - 1);
                    endsWNL = true;
                }
                if (pureContent.startsWith("--")) {
                    pureContent = pureContent.substring(2);
                } else if (pureContent.startsWith("/*") && pureContent.endsWith("*/")) {
                    pureContent = pureContent.substring(2, pureContent.length() - 2);
                }
                if (!pureContent.contains("\n")) {
                    if (options.get(singleLineComments) == InlineComments.MultiLine) {
                        output.append("/*" + pureContent + "*/");
                        if (endsWNL) {
                            output.append("\n");
                        }
                    } else if (options.get(singleLineComments) == InlineComments.SingleLine) {
                        output.append("--" + pureContent);
                        output.append("\n");
                    } else {
                        output.append(t.content);
                    }
                } else {
                    output.append(t.content);
                }
                prior = t;
                cumulativeChars = 0;
                continue;
            }
            ParseNode node = target.getRoot().leafAtPos(++pos);
            String ident = this.newlinePositions.get(pos);
            if (ident != null) {
                output.append(ident);
                priorIdent = ident;
                cumulativeChars = 0;
            } else {
                String scope;
                if (prior != null && prior.type == Token.LINE_COMMENT && priorIdent != null) {
                    output.append(priorIdent);
                }
                if (null != (scope = this.ids2scope.get(pos))) {
                    int maxLen = this.maxIdLengthInScope.get(scope);
                    int pad = maxLen + 3 - prior.content.length();
                    output.append(Service.padln("", pad));
                } else {
                    String separator = "";
                    if (!(prior == null || (prior.type == Token.OPERATION || ",".equals(t.content) || ";".equals(t.content) || ".".equals(t.content) || "%".equals(t.content) || "@".equals(t.content)) && (prior.type != Token.OPERATION || ".".equals(prior.content) || ":".equals(prior.content) || "%".equals(prior.content) || "@".equals(prior.content) || t.type == Token.OPERATION))) {
                        if (!(Format.isOpenParen(prior) && (0 >= pos || this.notPaddedParenthesis.contains(pos - 1)) && options.get(spaceAroundBrackets) != Space.Inside || Format.isCloseParen(t) && this.notPaddedParenthesis.contains(pos) && options.get(spaceAroundBrackets) != Space.Inside || Format.isOpenParen(t) && this.notPaddedParenthesis.contains(pos) && options.get(spaceAroundBrackets) != Space.Outside)) {
                            ParseNode priorLeaf = target.getRoot().leafAtPos(pos - 1);
                            if (0 < pos && (priorLeaf == null || !priorLeaf.contains(unary_add_op) && !priorLeaf.contains(compound_expression822))) {
                                separator = " ";
                            }
                        }
                    } else if (prior != null && prior.type == Token.OPERATION && Format.isOpenParen(t) || prior != null && Format.isCloseParen(prior) && t.type == Token.OPERATION && !";".equals(t.content) && !".".equals(t.content) && !",".equals(t.content)) {
                        separator = " ";
                    }
                    if ("/".equals(t.content) && node.parent() != null && node.parent().contains(sql_statement)) {
                        separator = "\n";
                        cumulativeChars = 0;
                    }
                    output.append(separator);
                }
            }
            String word = t.content;
            if (t.type == Token.IDENTIFIER) {
                word = this.adjustCase(word, options.get(kwCase));
            }
            if (node != null && this.casedIds.containsKey(node.interval())) {
                word = this.casedIds.get(node.interval());
            }
            output.append(word);
            if ((Integer)options.get(maxCharLineSize) < (cumulativeChars += word.length())) {
                output.append("\n");
                cumulativeChars = 0;
            }
            prior = t;
        }
        if (pos < (Integer)options.get(formatThreshold)) {
            return input;
        }
        String ret = output.toString();
        if (ret.startsWith("\n")) {
            ret = ret.substring(1);
        }
        if (options.get(breaksComma) == Breaks.Before) {
            ret = this.moveComma(ret);
        }
        if (options.get(breaksConcat) == Breaks.After) {
            ret = this.moveConcat(ret, true);
        }
        if (options.get(breaksConcat) == Breaks.None) {
            ret = this.moveConcat(ret, false);
        }
        if (!((Boolean)options.get(breaksAroundLogicalConjunctions)).booleanValue()) {
            ret = this.trimBreaksAfterConjunctions(ret);
        }
        if (!((Boolean)options.get(breakAfterCase)).booleanValue()) {
            ret = this.trimBreaksAfterKeyword(ret, "CASE");
        }
        if (!((Boolean)options.get(breakAfterWhen)).booleanValue()) {
            ret = this.trimBreaksAfterKeyword(ret, "WHEN");
        }
        if (!((Boolean)options.get(breakAfterThen)).booleanValue()) {
            ret = this.trimBreaksAfterKeyword(ret, "THEN");
        }
        if (!((Boolean)options.get(breakAfterElse)).booleanValue()) {
            ret = this.trimBreaksAfterKeyword(ret, "ELSE");
        }
        if (!((Boolean)options.get(spaceAfterCommas)).booleanValue()) {
            ret = this.trimSpacesAfterOperations(ret, ",");
        }
        if (!((Boolean)options.get(spaceAroundOperators)).booleanValue()) {
            ret = this.trimSpacesAroundOperations(ret);
        }
        ret = ret.replace("\n\n\n", "\n\n");
        int index = -1;
        while ((index = ret.indexOf(";/", index + 1)) >= 0) {
            if (ret.indexOf("*", index + 1) == index + 2) continue;
            ret = ret.substring(0, index) + ";\n/" + ret.substring(index + 2);
        }
        return ret;
    }

    private String adjustCase(String word, Object changeCase) {
        if (!word.startsWith("\"") && changeCase == Case.lower) {
            word = word.toLowerCase();
        }
        if (!word.startsWith("\"") && changeCase == Case.UPPER) {
            word = word.toUpperCase();
        }
        if (!word.startsWith("\"") && changeCase == Case.InitCap) {
            char[] converted = new char[word.length()];
            int prior1 = 37;
            for (int i = 0; i < converted.length; ++i) {
                char current = word.charAt(i);
                converted[i] = i == 0 || prior1 == 95 ? Character.toUpperCase(current) : Character.toLowerCase(current);
                prior1 = current;
            }
            word = new String(converted);
        }
        return word;
    }

    private String moveComma(String input) {
        String ret = input;
        for (int i = 10; 0 <= i; --i) {
            String ident = this.spaceSequence(i);
            ret = ret.replace(",\n" + ident, "\n" + ident + ", ");
        }
        return ret;
    }

    private String moveConcat(String input, boolean brk) {
        String ret = input;
        for (int i = 10; 0 <= i; --i) {
            String ident = this.spaceSequence(i);
            ret = ret.replace("\n" + ident + " ||  ", " ||" + (brk ? "\n" + ident : ""));
        }
        return ret;
    }

    private String trimBreaksAfterConjunctions(String input) {
        String ret = input;
        ret = this.trimBreaksAfterKeyword(ret, "OR");
        ret = this.trimBreaksAfterKeyword(ret, "AND");
        return ret;
    }

    private String trimBreaksAfterKeyword(String input, String keyword) {
        String ret = input;
        String keyWord = this.adjustCase(keyword, options.get(kwCase));
        for (int i = 10; 0 <= i; --i) {
            String ident = this.spaceSequence(i);
            ret = ret.replace(keyWord + "\n" + ident, keyWord + " ");
        }
        return ret;
    }

    private String trimSpacesAfterOperations(String input, String oper) {
        String ret = input;
        ret = ret.replace(oper + " ", oper);
        return ret;
    }

    private String trimSpacesAroundOperations(String input, String oper) {
        String ret = input;
        ret = ret.replace(" " + oper + " ", oper);
        return ret;
    }

    private String trimSpacesAroundOperations(String input) {
        String ret = input;
        ret = this.trimSpacesAroundOperations(ret, "=");
        ret = this.trimSpacesAroundOperations(ret, "+");
        ret = this.trimSpacesAroundOperations(ret, "-");
        ret = this.trimSpacesAroundOperations(ret, "*");
        ret = this.trimSpacesAroundOperations(ret, "/");
        ret = this.trimSpacesAroundOperations(ret, "<");
        ret = this.trimSpacesAroundOperations(ret, "<=");
        ret = this.trimSpacesAroundOperations(ret, ">");
        ret = this.trimSpacesAroundOperations(ret, ">=");
        ret = this.trimSpacesAroundOperations(ret, ":=");
        return ret;
    }

    private static boolean isOpenParen(LexerToken t) {
        return "(".equals(t.content) || "[".equals(t.content);
    }

    private static boolean isCloseParen(LexerToken t) {
        return ")".equals(t.content) || "]".equals(t.content);
    }

    String spaceSequence(int level) {
        String output = "";
        if (((Boolean)options.get(useTab)).booleanValue()) {
            for (int i = 0; i < level; ++i) {
                output = output + "\t";
            }
        } else {
            for (int i = 0; i < level * (Integer)options.get(identSpaces); ++i) {
                output = output + " ";
            }
        }
        return output;
    }

    void selNodes(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        for (int i = node.from; i < node.to; ++i) {
            Integer posDepth = this.posDepths.get(i);
            if (posDepth == null) {
                posDepth = -1;
            }
            Integer n = posDepth;
            Integer n2 = posDepth = Integer.valueOf(posDepth + 1);
            this.posDepths.put(i, posDepth);
        }
    }

    void formattedNodes(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode parent;
        ParseNode node = tuple.get("node");
        Integer depth = this.depth(node.from);
        if (depth == null) {
            depth = 0;
        }
        int pos = node.from;
        if (",".equals(target.getSrc().get((int)node.from).content)) {
            ++pos;
        }
        if (!((Boolean)options.get(breakOnCompositeLogicalExpressions)).booleanValue() && node.contains("condition") && !node.contains("compound_condition") && (parent = node.parent()).contains("compound_condition")) {
            return;
        }
        if (!((Boolean)options.get(breakOnSubqueries)).booleanValue()) {
            ParseNode grandParent;
            if ((node.contains("select_term") || node.contains("query_table_expression") || node.contains("condition")) && node.to < node.from + 10 && (grandParent = node.parent().parent()) != null && grandParent.contains("subquery")) {
                return;
            }
            if (node.contains("subquery")) {
                return;
            }
        }
        if (!((Boolean)options.get(breakAnsiiJoin)).booleanValue() && (node.contains("table_reference") || node.contains("condition")) && (parent = node.parent()) != null && (parent.contains("on_using_condition") || parent.contains("\"inner_cross_join_clause\""))) {
            return;
        }
        String listAlignmentPadding = "";
        boolean skipFirstOffset = false;
        if (!((Boolean)options.get(breaksAfterSelectFromWhere)).booleanValue()) {
            ParseNode parent2 = node.parent();
            if (parent2 == null) {
                return;
            }
            ParseNode firstChild = null;
            Iterator<ParseNode> iterator = parent2.children().iterator();
            if (iterator.hasNext()) {
                ParseNode n;
                firstChild = n = iterator.next();
            }
            if (node.contains("select_term")) {
                if (firstChild.to == node.from || firstChild == node) {
                    skipFirstOffset = true;
                }
                listAlignmentPadding = Service.padln(" ", "select ".length() - (Integer)options.get(identSpaces));
            } else if (node.contains("table_reference")) {
                if (!(firstChild.to != node.from && firstChild != node || parent2.contains("\"inner_cross_join_clause\""))) {
                    skipFirstOffset = true;
                }
                listAlignmentPadding = Service.padln(" ", "from ".length() - (Integer)options.get(identSpaces));
            } else if (node.contains("condition")) {
                if (!(firstChild.to != node.from && firstChild != node || parent2.contains("on_using_condition"))) {
                    skipFirstOffset = true;
                }
                if (parent2.contains("where_clause")) {
                    listAlignmentPadding = Service.padln(" ", "from ".length() - (Integer)options.get(identSpaces));
                }
            }
        }
        LexerToken nextToken = null;
        if (node.to < target.getSrc().size()) {
            nextToken = target.getSrc().get(node.to);
        }
        if (options.get(breaksComma) == Breaks.None) {
            if (nextToken != null && ",".equals(nextToken.content)) {
                return;
            }
            LexerToken priorToken = null;
            if (1 < node.from) {
                priorToken = target.getSrc().get(node.from - 1);
            }
            if (priorToken != null && ",".equals(priorToken.content)) {
                return;
            }
        }
        if (!skipFirstOffset) {
            this.newlinePositions.put(pos, "\n" + this.spaceSequence(depth) + listAlignmentPadding);
        }
        if (nextToken == null) {
            return;
        }
        pos = node.to;
        if (",".equals(nextToken.content) || ";".equals(nextToken.content)) {
            ++pos;
        }
        this.newlinePositions.put(pos, "\n" + this.spaceSequence(this.depth(pos)));
    }

    private int depth(int pos) {
        Integer ret = this.posDepths.get(pos);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    void sameLevel(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        int depth = this.depth(node.from);
        this.newlinePositions.put(node.from, "\n" + this.spaceSequence(depth) + " ");
        int pos = node.to;
        this.newlinePositions.put(pos, "  ");
    }

    void identifiers(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("identifier");
        String id = target.getSrc().get((int)node.from).content;
        if ("TO_CHAR".equals(id.toUpperCase()) || "TO_DATE".equals(id.toUpperCase()) || "DECODE".equals(id.toUpperCase()) || "SYSDATE".equals(id.toUpperCase()) || "REF".equals(id.toUpperCase()) || "VARCHAR".equals(id.toUpperCase()) || "NULL".equals(id.toUpperCase()) || "RAISE".equals(id.toUpperCase())) {
            return;
        }
        id = this.adjustCase(id, options.get(idCase));
        this.casedIds.put(node.interval(), id);
    }

    void paddedIdsInScope(Parsed target, Map<String, ParseNode> tuple) {
        if (!((Boolean)options.get(alignTypeDecl)).booleanValue()) {
            return;
        }
        ParseNode properties = tuple.get("scope");
        Integer maxLen = this.maxIdLengthInScope.get(properties.interval());
        if (maxLen == null) {
            maxLen = 0;
        }
        ParseNode id = tuple.get("id");
        int idLen = target.getSrc().get((int)id.from).content.length();
        if (maxLen < idLen) {
            maxLen = idLen;
        }
        this.maxIdLengthInScope.put(properties.interval(), maxLen);
        this.ids2scope.put(id.from + 1, properties.interval());
    }

    void extraLines(Parsed target, Map<String, ParseNode> tuple) {
        if (!((Boolean)options.get(extraLinesAfterSignificantStatements)).booleanValue()) {
            return;
        }
        ParseNode node = tuple.get("node");
        String padding = this.newlinePositions.get(node.to);
        if (padding == null) {
            this.newlinePositions.put(node.to, "\n\n");
        } else {
            this.newlinePositions.put(node.to, "\n" + padding);
        }
        padding = this.newlinePositions.get(node.from);
    }

    void notPaddedParenthesis(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode paren = tuple.get("paren");
        this.notPaddedParenthesis.add(paren.from);
    }

    void closestAncestor(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    void firstDescendant(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    void lastDescendant(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    void descendantNodes(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    static {
        Format.setDefaultOptions();
        programInstance = null;
    }

    public static enum InlineComments {
        None,
        SingleLine,
        MultiLine;

    }

    public static enum Breaks {
        Before,
        After,
        None;

    }

    public static enum Space {
        Inside,
        Outside,
        NoSpace;

    }

    public static enum Case {
        UPPER,
        lower,
        InitCap,
        None;

    }
}

