/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingEvent;
import org.jdesktop.animation.timing.TimingListener;
import org.jdesktop.animation.timing.TimingTarget;

public class TimingController
implements TimingTarget {
    private Timer timer;
    private ArrayList targets = new ArrayList();
    private long startTime;
    private long currentStartTime;
    private int currentCycle = 0;
    private Direction direction = Direction.FORWARD;
    private boolean intRepeatCount;
    private ArrayList listeners = new ArrayList();
    private Envelope envelope;
    private Cycle cycle;
    private float acceleration = 0.0f;
    private float deceleration = 0.0f;
    public static final int INFINITE = -1;

    public TimingController(Cycle cycle, Envelope envelope) {
        this(cycle, envelope, null);
    }

    public TimingController(Cycle cycle, Envelope envelope, TimingTarget target) {
        this.cycle = cycle;
        this.envelope = envelope;
        if (target != null) {
            this.targets.add(target);
        }
        this.intRepeatCount = Math.rint(envelope.getRepeatCount()) == envelope.getRepeatCount();
        TimerTarget timerTarget = new TimerTarget();
        this.timer = new Timer(cycle.getResolution(), timerTarget);
        this.timer.setInitialDelay(envelope.getBegin());
        Toolkit tk = Toolkit.getDefaultToolkit();
    }

    public TimingController(int duration, TimingTarget target) {
        this(new Cycle(duration, 10), new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD), target);
    }

    public void setAcceleration(float acceleration) {
        if (acceleration < 0.0f || acceleration > 1.0f) {
            throw new IllegalArgumentException("Acceleration value cannot lie outside [0,1] range");
        }
        if (acceleration > 1.0f - this.deceleration) {
            throw new IllegalArgumentException("Acceleration value cannot be greater than (1 - deceleration)");
        }
        this.acceleration = acceleration;
    }

    public void setDeceleration(float deceleration) {
        if (deceleration < 0.0f || deceleration > 1.0f) {
            throw new IllegalArgumentException("Deceleration value cannot lie outside [0,1] range");
        }
        if (deceleration > 1.0f - this.acceleration) {
            throw new IllegalArgumentException("Deceleration value cannot be greater than (1 - acceleration)");
        }
        this.deceleration = deceleration;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public float getDeceleration() {
        return this.deceleration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(TimingTarget target) {
        if (target != null) {
            ArrayList arrayList = this.targets;
            synchronized (arrayList) {
                this.targets.add(target);
            }
        }
    }

    public void addTimingListener(TimingListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public Cycle getCycle() {
        return this.cycle;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setCycle(Cycle cycle) {
        this.cycle = cycle;
        this.timer.setDelay(cycle.getResolution());
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public void start() {
        this.begin();
        this.currentStartTime = this.startTime = System.nanoTime() / 1000000L + (long)this.envelope.getBegin();
        this.timer.start();
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public void stop() {
        this.timer.stop();
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timingEvent(long cycleElapsedTime, long totalElapsedTime, float fraction) {
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget target = (TimingTarget)this.targets.get(i);
                target.timingEvent(cycleElapsedTime, totalElapsedTime, fraction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        int i;
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            for (i = 0; i < this.targets.size(); ++i) {
                TimingTarget target = (TimingTarget)this.targets.get(i);
                target.begin();
            }
        }
        arrayList = this.listeners;
        synchronized (arrayList) {
            for (i = 0; i < this.listeners.size(); ++i) {
                TimingListener listener = (TimingListener)this.listeners.get(i);
                listener.timerStarted(new TimingEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        int i;
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            for (i = 0; i < this.targets.size(); ++i) {
                TimingTarget target = (TimingTarget)this.targets.get(i);
                target.end();
            }
        }
        arrayList = this.listeners;
        synchronized (arrayList) {
            for (i = 0; i < this.listeners.size(); ++i) {
                TimingListener listener = (TimingListener)this.listeners.get(i);
                listener.timerStopped(new TimingEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repeat() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                TimingListener listener = (TimingListener)this.listeners.get(i);
                listener.timerRepeated(new TimingEvent(this));
            }
        }
    }

    private void timingEventPreprocessor(long cycleElapsedTime, long totalElapsedTime, float fraction) {
        if (this.acceleration != 0.0f || this.deceleration != 0.0f) {
            float oldFraction = fraction;
            float runRate = 1.0f / (1.0f - this.acceleration / 2.0f - this.deceleration / 2.0f);
            if (fraction < this.acceleration) {
                float averageRunRate = runRate * (fraction / this.acceleration) / 2.0f;
                fraction *= averageRunRate;
            } else if (fraction > 1.0f - this.deceleration) {
                float tdec = fraction - (1.0f - this.deceleration);
                float pdec = tdec / this.deceleration;
                fraction = runRate * (1.0f - this.acceleration / 2.0f - this.deceleration + tdec * (2.0f - pdec) / 2.0f);
            } else {
                fraction = runRate * (fraction - this.acceleration / 2.0f);
            }
            if (fraction < 0.0f) {
                fraction = 0.0f;
            } else if (fraction > 1.0f) {
                fraction = 1.0f;
            }
        }
        this.timingEvent(cycleElapsedTime, totalElapsedTime, fraction);
    }

    private class TimerTarget
    implements ActionListener {
        private TimerTarget() {
        }

        public void actionPerformed(ActionEvent e) {
            long currentTime = System.nanoTime() / 1000000L;
            long cycleElapsedTime = currentTime - TimingController.this.currentStartTime;
            long totalElapsedTime = currentTime - TimingController.this.startTime;
            double currentCycle = (double)totalElapsedTime / (double)TimingController.this.cycle.getDuration();
            if (TimingController.this.envelope.getRepeatCount() != -1.0 && currentCycle >= TimingController.this.envelope.getRepeatCount()) {
                switch (TimingController.this.envelope.getEndBehavior()) {
                    case HOLD: {
                        float endFraction = TimingController.this.intRepeatCount ? (TimingController.this.direction == Direction.BACKWARD ? 0.0f : 1.0f) : Math.min(1.0f, (float)cycleElapsedTime / (float)TimingController.this.cycle.getDuration());
                        TimingController.this.timingEventPreprocessor(cycleElapsedTime, totalElapsedTime, endFraction);
                        break;
                    }
                    case RESET: {
                        TimingController.this.timingEventPreprocessor(cycleElapsedTime, totalElapsedTime, 0.0f);
                        break;
                    }
                }
                TimingController.this.stop();
            } else if (TimingController.this.cycle.getDuration() != -1 && cycleElapsedTime > (long)TimingController.this.cycle.getDuration()) {
                long actualCycleTime = cycleElapsedTime % (long)TimingController.this.cycle.getDuration();
                float fraction = (float)actualCycleTime / (float)TimingController.this.cycle.getDuration();
                TimingController.this.currentStartTime = currentTime - actualCycleTime;
                if (TimingController.this.envelope.getRepeatBehavior() == Envelope.RepeatBehavior.REVERSE) {
                    boolean oddCycles;
                    boolean bl = oddCycles = (int)(cycleElapsedTime / (long)TimingController.this.cycle.getDuration()) % 2 > 0;
                    if (oddCycles) {
                        TimingController.this.direction = TimingController.this.direction == Direction.FORWARD ? Direction.BACKWARD : Direction.FORWARD;
                    }
                    if (TimingController.this.direction == Direction.BACKWARD) {
                        fraction = 1.0f - fraction;
                    }
                }
                TimingController.this.timingEventPreprocessor(actualCycleTime, totalElapsedTime, fraction);
                TimingController.this.repeat();
            } else {
                float fraction = 0.0f;
                if (TimingController.this.cycle.getDuration() != -1) {
                    fraction = (float)cycleElapsedTime / (float)TimingController.this.cycle.getDuration();
                    if (TimingController.this.direction == Direction.BACKWARD) {
                        fraction = 1.0f - fraction;
                    }
                    fraction = Math.min(fraction, 1.0f);
                    fraction = Math.max(fraction, 0.0f);
                }
                TimingController.this.timingEventPreprocessor(cycleElapsedTime, totalElapsedTime, fraction);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

