/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt;

import ice.debug.Debug;
import ice.util.Defs;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public abstract class AwtQueueKit {
    public static final boolean trace_awt_queue = Debug.trace && Defs.sysPropertyBoolean("ice.util.awt.trace_awt_queue");
    protected static final Hashtable trace_java_stack = trace_awt_queue ? new Hashtable() : null;

    public static AwtQueueKit newInstance() {
        AwtQueueKit x = null;
        String className = Defs.sysProperty("ice.util.awt.AwtQueueKit");
        if (className != null) {
            x = (AwtQueueKit)Defs.newClassInstance(className);
        }
        if (x == null && (x = (AwtQueueKit)Defs.newClassInstance(className = "ice.util.awt.jdk12.AwtQueueKit_jdk12")) == null) {
            className = "ice.util.awt.jdk11.AwtQueueKit_jdk11";
            x = (AwtQueueKit)Defs.newClassInstance(className);
        }
        if (Debug.trace) {
            Debug.trace(x != null ? className : "FAILED!");
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace_add_to_stack_trace(Runnable code, long delay) {
        if (trace_awt_queue) {
            Hashtable hashtable = trace_java_stack;
            synchronized (hashtable) {
                if (trace_java_stack.get(code) == null) {
                    Throwable x = new Throwable("AWT thread post stack trace for " + code + ", delay=" + delay);
                    x.fillInStackTrace();
                    String s = ">>>>>>> " + Debug.getStackPrintoutAsString(x);
                    trace_java_stack.put(code, s);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace_print_java_stack(Runnable code) {
        if (trace_awt_queue) {
            String str;
            Hashtable hashtable = trace_java_stack;
            synchronized (hashtable) {
                str = (String)trace_java_stack.get(code);
                if (str != null) {
                    trace_java_stack.remove(code);
                }
            }
            if (str != null) {
                Debug.traceAsIs(str);
            }
        }
    }

    public abstract void invokeAndWait(Runnable var1) throws InterruptedException, InvocationTargetException;

    public abstract void invokeLater(Runnable var1);

    public abstract boolean isDispatchThread();
}

