/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.debug.Debug;
import ice.util.Defs;
import java.lang.reflect.Field;
import java.util.Locale;

public class Emulation {
    private static final String IE_APP_NAME = "Microsoft Internet Explorer";
    private static final String IE7_APP_VERSION = "4.0 (compatible; MSIE 7.0; " + Emulation.getMSIEPlatformInfo() + "; ICEbrowser)";
    private static final String IE6_APP_VERSION = "4.0 (compatible; MSIE 6.0; " + Emulation.getMSIEPlatformInfo() + "; ICEbrowser)";
    private static final String NS_APP_NAME = "Netscape";
    private static final String NS4_APP_VERSION = "4.7 [" + Locale.getDefault().toString() + "] (" + Emulation.getPlatformInfo() + "; I; ICEbrowser)";
    private static final String NS6_APP_VERSION = "5.0 (" + Emulation.getPlatformInfo() + "; " + Locale.getDefault().toString() + "; rv:1.5; ICEbrowser) Gecko/20031007 Netscape/7.2";
    private static final String FF2_APP_NAME = "Firefox";
    private static final String FF2_APP_VERSION = "5.0 (" + Emulation.getPlatformInfo() + "; " + Locale.getDefault().toString() + "; rv:1.8.1.1; ICEbrowser) Gecko/20061204 Firefox/2.0.0.1";
    private static final String DEFAULT_APP_NAME = "ICEbrowser";
    private static final String DEFAULT_APP_VERSION = "5.0 (Java " + Defs.sysProperty("java.version", "") + "; " + Emulation.getPlatformInfo() + "; " + Locale.getDefault().toString() + ") ICEbrowser/" + Emulation.getIBVersion();

    private static String getPlatformInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(Defs.sysProperty("os.name", ""));
        sb.append(' ');
        sb.append(Defs.sysProperty("os.version", ""));
        sb.append(' ');
        sb.append(Defs.sysProperty("os.arch", ""));
        return sb.toString();
    }

    private static String getMSIEPlatformInfo() {
        StringBuffer sb = new StringBuffer();
        if (!Defs.sysProperty("os.name", "").startsWith("Windows")) {
            sb.append("Windows NT 5.1");
        } else {
            sb.append(Defs.sysProperty("os.name", ""));
            sb.append(' ');
            sb.append(Defs.sysProperty("os.version", ""));
        }
        return sb.toString();
    }

    private static String getIBVersion() {
        String version;
        block8: {
            version = "";
            try {
                Class<?> c = Class.forName("ice.storm.StormBase");
                Field field = c.getField("VERSION");
                version = field.get(c).toString();
            }
            catch (ClassNotFoundException e) {
                if (Debug.ex) {
                    Debug.ex(e);
                }
            }
            catch (IllegalAccessException e) {
                if (Debug.ex) {
                    Debug.ex(e);
                }
            }
            catch (SecurityException e) {
                if (Debug.ex) {
                    Debug.ex(e);
                }
            }
            catch (NoSuchFieldException e) {
                if (!Debug.ex) break block8;
                Debug.ex(e);
            }
        }
        return version;
    }

    public static String getEmulationMode() {
        return Defs.sysProperty("ice.browser.emulation", "");
    }

    public static String getEmulatedAppCodeName() {
        return "Mozilla";
    }

    public static String getEmulatedAppName() {
        String appName = Defs.sysProperty("ice.browser.appName", null);
        if (appName == null) {
            String emulationMode = Emulation.getEmulationMode();
            appName = emulationMode.startsWith("ie") ? IE_APP_NAME : (emulationMode.startsWith("ns") ? NS_APP_NAME : (emulationMode.startsWith("ff") ? FF2_APP_NAME : DEFAULT_APP_NAME));
        }
        return appName;
    }

    public static String getEmulatedAppVersion() {
        String appVersion = Defs.sysProperty("ice.browser.appVersion", null);
        if (appVersion == null) {
            String emulationMode = Emulation.getEmulationMode();
            appVersion = emulationMode.equals("ie") || emulationMode.equals("ie6") ? IE6_APP_VERSION : (emulationMode.equals("ie7") ? IE7_APP_VERSION : (emulationMode.equals("ns") ? NS4_APP_VERSION : (emulationMode.equals("ns6") || emulationMode.equals("ns7") ? NS6_APP_VERSION : (emulationMode.equals("ff") || emulationMode.equals("ff2") ? FF2_APP_VERSION : DEFAULT_APP_VERSION))));
        }
        return appVersion;
    }

    public static String getEmulatedPlatform() {
        String emulationMode = Emulation.getEmulationMode();
        if (emulationMode.startsWith("ie")) {
            return "Win32";
        }
        return Emulation.getPlatformInfo();
    }

    public static String getEmulatedUserAgent() {
        String appAgent = Defs.sysProperty("ice.browser.http.agent", null);
        if (appAgent == null) {
            appAgent = Emulation.getEmulatedAppCodeName() + '/' + Emulation.getEmulatedAppVersion();
        }
        return appAgent;
    }
}

