/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

public class ByteUtil {
    private static final char[] HEXADECIMAL_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] padOrTruncate(byte[] bytes, int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("length is lesser than 0");
        }
        byte[] _bytes = new byte[length];
        System.arraycopy(bytes, 0, _bytes, 0, bytes.length <= length ? bytes.length : length);
        return _bytes;
    }

    public static String toHexadecimalString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuffer _stringBuffer = new StringBuffer(bytes.length * 2 + 2);
        _stringBuffer.append("0x");
        for (int i = 0; i < bytes.length; ++i) {
            _stringBuffer.append(HEXADECIMAL_CHARACTERS[(bytes[i] & 0xF0) >>> 4 & 0xF]);
            _stringBuffer.append(HEXADECIMAL_CHARACTERS[bytes[i] & 0xF]);
        }
        return _stringBuffer.toString();
    }
}

