/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import java.awt.Image;

public abstract class DocPane {
    public abstract int getDocWidth();

    public abstract int getDocHeight();

    public abstract int getScrollX();

    public abstract int getScrollY();

    public abstract int getPaneWidth();

    public abstract int getPaneHeight();

    public abstract void setScrollPosition(int var1, int var2);

    public void updateScrollbars(boolean isRTL) {
    }

    public final int getScrollMaxX() {
        int max = this.getDocWidth();
        if (max < 0) {
            max = 0;
        }
        return max;
    }

    public final int getScrollMaxY() {
        int max = this.getDocHeight();
        if (max < 0) {
            max = 0;
        }
        return max;
    }

    public final int getScrollX(int x) {
        if (x < 0) {
            return 0;
        }
        if (x > this.getScrollMaxX()) {
            return this.getScrollMaxX();
        }
        return x;
    }

    public final int getScrollY(int y) {
        if (y < 0) {
            return 0;
        }
        if (y > this.getScrollMaxY()) {
            return this.getScrollMaxY();
        }
        return y;
    }

    public final boolean isVisibleOnScreen(int x, int y) {
        int scrollY;
        int scrollX = this.getScrollX();
        int width = this.getPaneWidth();
        int height = this.getPaneHeight();
        return scrollX <= x && x <= scrollX + width && (scrollY = this.getScrollY()) <= y && y < scrollY + height;
    }

    public final boolean canScroll(int x, int y) {
        int maxX = this.getScrollMaxX();
        if (0 <= x && x <= maxX) {
            int maxY = this.getScrollMaxY();
            if (0 <= y && y <= maxY) {
                return true;
            }
        }
        return false;
    }

    public abstract void setAutoRepaint(boolean var1);

    public abstract boolean doesAutoRepaint();

    public abstract void revalidate(int var1, int var2, int var3, int var4);

    public abstract void reqClear();

    public abstract void reqFocus();

    public abstract void reqRepaint();

    public abstract void reqRepaint(int var1, int var2, int var3, int var4);

    public abstract void setCursor(int var1);

    public abstract Image createImage(int var1, int var2);
}

