/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.encoding.ReaderUTF8;
import ice.util.io.IOKit;
import ice.util.net.CookieSet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;

public class ContentLoader {
    private static final boolean debug_url_replace = Debug.extra && ContentLoader.debug_init_url_replace();
    private static final boolean debug_capture_all_input = Debug.extra && Defs.booleanProperty("ice.debug.capture_all_input");
    private static Object debug_url_replacement_map;
    private URL url;
    private URL serverRoot = null;
    private URLConnection uc;
    private String type;
    private InputStream inputStream;
    private Hashtable params;
    private String referer;
    private String userAgent;
    private String postType;
    private byte[] postData;
    private InputStream postStream;
    private boolean fromHistory = false;
    private boolean iframe = false;
    private IOException exceptionObject;
    private boolean lazyMake = false;
    private boolean redirected = false;
    private boolean connectionRequested;

    ContentLoader(String loc, boolean fromHistory) {
        this(null, loc, null);
        this.fromHistory = fromHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean debug_init_url_replace() {
        block12: {
            if (!Debug.extra) {
                return false;
            }
            String map_url = Defs.sysProperty("ice.debug.url_replacement");
            if (map_url != null) {
                map_url = ContentLoader.debug_preprocess_replace_url(map_url);
                Vector<String[]> buffer = new Vector<String[]>();
                try {
                    InputStream is = new URL(map_url).openStream();
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new ReaderUTF8(is));
                        String from = null;
                        while (null != (line = r.readLine())) {
                            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                            if (from == null) {
                                from = line;
                                continue;
                            }
                            line = ContentLoader.debug_preprocess_replace_url(line);
                            String[] data = new String[]{from, line};
                            buffer.addElement(data);
                            from = null;
                        }
                        if (buffer.size() != 0) {
                            String[][] map = new String[buffer.size()][];
                            buffer.copyInto((Object[])map);
                            if (Debug.trace) {
                                StringBuffer sb = new StringBuffer();
                                sb.append("length=");
                                sb.append(map.length);
                                for (int i = 0; i != map.length; ++i) {
                                    sb.append('\n');
                                    sb.append(map[i][0]);
                                    sb.append("\t -> ");
                                    sb.append(map[i][1]);
                                }
                                Debug.trace(sb.toString());
                            }
                            debug_url_replacement_map = map;
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    if (!Debug.ex) break block12;
                    Debug.ex(ex);
                }
            }
        }
        return debug_url_replacement_map != null;
    }

    private static String debug_preprocess_replace_url(String url) {
        if (Debug.extra) {
            if (url.startsWith("./") || url.startsWith(".\\")) {
                String dir = Defs.sysProperty("user.dir");
                if (dir == null && (dir = Defs.sysProperty("user.home")) == null) {
                    dir = "";
                }
                url = "file:" + dir + '/' + url.substring(2).replace('\\', '/');
            } else if (url.startsWith("~/") || url.startsWith("~\\")) {
                String dir = Defs.sysProperty("user.home");
                if (dir == null && (dir = Defs.sysProperty("user.dir")) == null) {
                    dir = "";
                }
                url = "file:" + dir + '/' + url.substring(2).replace('\\', '/');
            }
        }
        return url;
    }

    private static InputStream debug_get_replace_stream(URLConnection c) {
        if (debug_url_replace) {
            String url = c.getURL().toString();
            String[][] map = (String[][])debug_url_replacement_map;
            for (int i = 0; i != map.length; ++i) {
                String key = map[i][0];
                boolean match = false;
                match = key.charAt(key.length() - 1) == '*' ? key.regionMatches(0, url, 0, key.length() - 1) : key.equals(url);
                if (!match) continue;
                String to = map[i][1];
                if (Debug.trace) {
                    Debug.trace("input replacement: " + url + " -> " + to);
                }
                try {
                    return new URL(to).openStream();
                }
                catch (IOException ex) {
                    if (!Debug.ex) continue;
                    Debug.ex(ex);
                }
            }
        }
        return null;
    }

    boolean hasReply() {
        return this.connectionRequested || this.exceptionObject != null || this.inputStream != null;
    }

    public void setRedirected(boolean flag) {
        this.redirected = flag;
    }

    public boolean getRedirected() {
        return this.redirected;
    }

    public ContentLoader(URL u, String contentType) {
        this.url = u;
        this.type = contentType;
    }

    public ContentLoader(String url, String contentType) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException exception) {
            if (Debug.ex) {
                Debug.ex(exception);
            }
            this.setException(exception);
        }
        this.type = contentType;
    }

    public ContentLoader(URL base, String loc, String contentType) {
        try {
            this.url = base != null ? new URL(base, loc) : new URL(loc);
        }
        catch (MalformedURLException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            this.setException(ex);
        }
        this.type = contentType;
    }

    public ContentLoader(URLConnection urlc, String contentType) {
        this.uc = urlc;
        this.type = contentType;
    }

    public ContentLoader(URL documentBase, InputStream in, String contentType) {
        this.url = documentBase;
        this.inputStream = in;
        this.type = contentType;
    }

    public ContentLoader(URL serverRoot, URL documentBase, InputStream in, String contentType) {
        this.serverRoot = serverRoot;
        this.url = documentBase;
        this.inputStream = in;
        this.type = contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void make() {
        if (this.url == null && this.uc == null) {
            return;
        }
        if (this.getException() != null) {
            return;
        }
        try {
            URL _requestedUrl = this.url;
            if (this.uc == null || this.lazyMake) {
                if (this.uc == null) {
                    this.uc = this.openConnection(this.url);
                }
                if (this.referer != null) {
                    int _hashIndex = this.referer.indexOf("#");
                    if (_hashIndex != -1) {
                        this.referer = this.referer.substring(0, _hashIndex);
                    }
                    this.uc.setRequestProperty("Referer", this.referer);
                }
                if (this.userAgent != null) {
                    this.uc.setRequestProperty("User-Agent", this.userAgent);
                }
                if (this.postData != null && this.postType != null) {
                    this.uc.setDoOutput(true);
                    this.uc.setRequestProperty("Content-type", this.postType);
                    OutputStream _outputStream = this.uc.getOutputStream();
                    this.connectionRequested = true;
                    try {
                        _outputStream.write(this.postData);
                        _outputStream.flush();
                    }
                    finally {
                        _outputStream.close();
                    }
                }
                if (this.postStream != null && this.postType != null) {
                    int _numberOfBytes;
                    this.uc.setDoOutput(true);
                    this.uc.setRequestProperty("Content-type", this.postType);
                    OutputStream _outputStream = this.uc.getOutputStream();
                    byte[] _buffer = new byte[8192];
                    while ((_numberOfBytes = this.postStream.read(_buffer)) != -1) {
                        _outputStream.write(_buffer, 0, _numberOfBytes);
                    }
                    _outputStream.flush();
                    _outputStream.close();
                }
                this.lazyMake = false;
            }
            if (this.inputStream == null) {
                InputStream replace;
                this.setInputStream(this.uc.getInputStream());
                if (debug_capture_all_input) {
                    byte[] _bytes;
                    try {
                        _bytes = IOKit.readAll(this.inputStream);
                    }
                    finally {
                        this.inputStream.close();
                    }
                    ContentLoader.recordCapture(this.uc.getURL(), _bytes);
                    this.setInputStream(new ByteArrayInputStream(_bytes));
                }
                if (debug_url_replace && (replace = ContentLoader.debug_get_replace_stream(this.uc)) != null) {
                    InputStream original = this.getInputStream();
                    this.setInputStream(replace);
                    if (original != null) {
                        try {
                            byte[] tmp = new byte[4096];
                            original.read(tmp);
                        }
                        finally {
                            original.close();
                        }
                    }
                }
                this.connectionRequested = true;
            }
            if (this.type == null) {
                this.type = this.uc.getContentType();
            }
            this.url = this.uc.getURL();
            if (!this.url.equals(_requestedUrl) && this.postData != null) {
                this.postData = null;
            }
        }
        catch (IOException exception) {
            Debug.ex(exception);
            this.setException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordCapture(URL url, byte[] data) {
        block16: {
            File f;
            String host;
            String proto = url.getProtocol();
            if (proto == null || proto.length() == 0) {
                proto = "unknown";
            }
            if ((host = url.getHost()) == null || host.length() == 0) {
                host = "undefined";
            }
            File dir = new File(proto, host);
            dir.mkdirs();
            String path = url.getFile();
            if (path == null || path.length() == 0) {
                path = "unknown.html";
            } else if (path.charAt(0) == '/') {
                int i;
                for (i = 1; i != path.length() && path.charAt(i) == '/'; ++i) {
                }
                if ((path = path.substring(i)).length() == 0) {
                    path = "unknown.html";
                }
            }
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash >= 0) {
                File dir1 = new File(dir, path.substring(0, lastSlash));
                if (dir1.mkdirs()) {
                    dir = dir1;
                }
                if ((path = path.substring(lastSlash + 1).trim()).length() == 0) {
                    path = "unknown.html";
                }
            }
            if ((f = new File(dir, path)) != null) {
                try {
                    FileOutputStream os = new FileOutputStream(f);
                    try {
                        ((OutputStream)os).write(data);
                    }
                    finally {
                        ((OutputStream)os).close();
                        Debug.trace("content saved to " + f.getName());
                    }
                }
                catch (IOException ex) {
                    if (!Debug.ex) break block16;
                    Debug.ex(ex);
                }
            }
        }
    }

    public void setIframe(boolean flag) {
        this.iframe = flag;
    }

    boolean isIframe() {
        return this.iframe;
    }

    public boolean isFromHistory() {
        return this.fromHistory;
    }

    void setContentType(String contentType) {
        this.type = contentType;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String r) {
        this.referer = r;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setPostData(String type, byte[] d) {
        if (type == null) {
            type = "application/x-www-form-urlencoded";
        }
        this.postType = type;
        this.postData = d;
    }

    public void setPostStream(String type, InputStream ioStream) {
        if (type == null) {
            type = "multipart/form-data";
        }
        this.postType = type;
        this.postStream = ioStream;
    }

    public byte[] getPostData() {
        return this.postData;
    }

    public String getContentType() {
        if (this.type == null) {
            this.make();
        }
        if (this.type == null) {
            this.type = "content/unknown";
        }
        return this.type;
    }

    void setURL(URL u) {
        this.url = u;
    }

    public URL getURL() {
        if (this.url == null) {
            this.make();
        }
        return this.url;
    }

    public URL getServerRoot() {
        return this.serverRoot;
    }

    public URLConnection getURLConnection() {
        if (this.uc == null) {
            try {
                this.uc = this.openConnection(this.url);
                this.lazyMake = true;
            }
            catch (IOException exception) {
                Debug.ex(exception);
                this.setException(exception);
            }
        }
        return this.uc;
    }

    public String getRequestProperty(String property) {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc != null) {
            return this.uc.getRequestProperty(property);
        }
        return null;
    }

    public String getHeaderFieldKey(int i) {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc != null) {
            return this.uc.getHeaderFieldKey(i);
        }
        return null;
    }

    public String getHeaderField(int i) {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc != null) {
            return this.uc.getHeaderField(i);
        }
        return null;
    }

    public CookieSet getCookieSet() {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc instanceof CookieSet) {
            return (CookieSet)((Object)this.uc);
        }
        return null;
    }

    public InputStream getInputStream() {
        if (this.inputStream == null) {
            this.make();
        }
        return this.inputStream;
    }

    protected void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getContentCharset() {
        int _index;
        String _contentType;
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc != null && (_contentType = this.uc.getContentType()) != null && (_index = _contentType.toLowerCase().indexOf("charset")) != -1 && (_index = _contentType.indexOf("=", _index)) != -1 && _index != _contentType.length() - 1) {
            return _contentType.substring(_index + 1).trim();
        }
        return null;
    }

    public String getLocation() {
        if (this.url != null) {
            return this.url.toExternalForm();
        }
        return null;
    }

    public void setParams(Hashtable h) {
        this.params = h;
    }

    public Hashtable getParams() {
        return this.params;
    }

    void setException(IOException ex) {
        this.exceptionObject = ex;
    }

    public IOException getException() {
        return this.exceptionObject;
    }

    public String toString() {
        IOException ex;
        String type;
        StringBuffer sb = new StringBuffer(50);
        sb.append('{');
        boolean empty_lead = true;
        URL url = this.url;
        if (url != null) {
            sb.append(url.toExternalForm());
            empty_lead = false;
        }
        if (this.postType != null) {
            if (empty_lead) {
                empty_lead = false;
            } else {
                sb.append(' ');
            }
            sb.append("postType=");
            sb.append(this.postType);
            if (this.postData != null) {
                sb.append(" postData: ");
                sb.append(new String(this.postData));
            }
        }
        if ((type = this.type) != null) {
            if (empty_lead) {
                empty_lead = false;
            } else {
                sb.append(' ');
            }
            sb.append("type=");
            sb.append(type);
        }
        if ((ex = this.getException()) != null) {
            if (empty_lead) {
                empty_lead = false;
            } else {
                sb.append(' ');
            }
            sb.append("excepton=");
            sb.append(ex);
        }
        sb.append('}');
        return sb.toString();
    }

    void setFromHistoryFlag(boolean fromHistory) {
        this.fromHistory = fromHistory;
    }

    protected URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }
}

