/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.StormCallback;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.util.security.BoxedCode;
import java.awt.Container;

public class CallbackAdapter
implements ViewportCallback,
ScripterCallback {
    public void init(StormBase base) {
    }

    public Container createTopLevelContainer(Viewport vp) {
        if (Debug.trace) {
            Debug.trace("ERROR: NO TOP LEVEL CONTAINER FOR " + vp);
        }
        throw new RuntimeException("ice.storm.CallbackAdapter.createTopLevelContainer should be overwritten to return viewport container");
    }

    public void disposeTopLevelContainer(Viewport vp) {
        if (Debug.trace) {
            Debug.trace("WARNING: IGNORING FOR " + vp);
        }
    }

    public void processViewportMessage(Viewport view, String messageName, Object addArg, Object value) {
    }

    public long getMaxScriptRunningTime() {
        return 5000L;
    }

    public boolean interruptLongRunningScript(Viewport vp, long scriptRunTime) {
        if (Debug.trace) {
            Debug.trace("Interrupting too long (" + scriptRunTime + " ms) running script");
        }
        return true;
    }

    public boolean allowScriptClose(Viewport vp, boolean openedByScript) {
        if (openedByScript) {
            return true;
        }
        if (Debug.trace) {
            Debug.trace("Attempt to close top level window " + vp + " by script");
        }
        return false;
    }

    public void reportScriptError(Viewport vp, boolean justWarning, String errorMessage, String url, int lineNumber, String lineSource, int lineOffset) {
        if (Debug.trace) {
            StringBuffer sb = new StringBuffer();
            sb.append(justWarning ? "script warning: " : "SCRIPT ERROR: ");
            sb.append(url);
            sb.append(':');
            sb.append(lineNumber + 1);
            sb.append(':');
            sb.append(lineOffset);
            sb.append(": ");
            sb.append(errorMessage);
            if (lineSource != null) {
                sb.append('\n');
                sb.append(lineSource);
                sb.append('\n');
                for (int i = 0; i < lineOffset - 1; ++i) {
                    sb.append('.');
                }
                sb.append('^');
            }
            if (Debug.trace) {
                Debug.trace(sb.toString());
            }
        }
    }

    public String scriptPrompt(Viewport vp, String msg, String defVal) {
        if (Debug.trace) {
            Debug.trace("Script prompt call, window=" + vp + ", message=" + msg + " default=" + defVal);
        }
        return defVal;
    }

    public boolean scriptConfirm(Viewport vp, String msg) {
        if (Debug.trace) {
            Debug.trace("Script confirm call, window=" + vp + ", message=" + msg);
        }
        return false;
    }

    public void scriptAlert(Viewport vp, String msg) {
        if (Debug.trace) {
            Debug.trace("Script alert call, window=" + vp + ", message=" + msg);
        }
    }

    public void scriptPrint(Viewport vp) {
        if (Debug.trace) {
            Debug.trace("Script print call, window=" + vp);
        }
    }

    public final void registerWith(StormBase storm) {
        storm.setViewportCallback(this);
        storm.setScripterCallback(this);
    }

    public static BoxedCode box_createTopLevelContainer(ViewportCallback viewportCallback, Viewport vp) {
        BoxedCallback box = new BoxedCallback();
        box.id = 1;
        box.viewportCallback = viewportCallback;
        box.vp = vp;
        return box;
    }

    public static BoxedCode box_disposeTopLevelContainer(ViewportCallback viewportCallback, Viewport vp) {
        BoxedCallback box = new BoxedCallback();
        box.id = 2;
        box.viewportCallback = viewportCallback;
        box.vp = vp;
        return box;
    }

    public static BoxedCode box_getMaxScriptRunningTime(ScripterCallback sc) {
        BoxedCallback box = new BoxedCallback();
        box.id = 3;
        box.scripterCallback = sc;
        return box;
    }

    public static BoxedCode box_interruptLongRunningScript(ScripterCallback sc, Viewport vp, long scriptRunTime) {
        BoxedCallback box = new BoxedCallback();
        box.id = 4;
        box.scripterCallback = sc;
        box.vp = vp;
        box.scriptRunTime = scriptRunTime;
        return box;
    }

    public static BoxedCode box_allowScriptClose(ScripterCallback sc, Viewport vp, boolean openedByScript) {
        BoxedCallback box = new BoxedCallback();
        box.id = 5;
        box.scripterCallback = sc;
        box.vp = vp;
        box.openedByScript = openedByScript;
        return box;
    }

    public static BoxedCode box_reportScriptError(ScripterCallback sc, Viewport vp, boolean justWarning, String errorMessage, String url, int lineNumber, String lineSource, int lineOffset) {
        BoxedCallback box = new BoxedCallback();
        box.id = 6;
        box.scripterCallback = sc;
        box.vp = vp;
        box.justWarning = justWarning;
        box.errorMessage = errorMessage;
        box.url = url;
        box.lineNumber = lineNumber;
        box.lineSource = lineSource;
        box.lineOffset = lineOffset;
        return box;
    }

    public static BoxedCode box_scriptPrompt(ScripterCallback sc, Viewport vp, String msg, String defVal) {
        BoxedCallback box = new BoxedCallback();
        box.id = 7;
        box.scripterCallback = sc;
        box.vp = vp;
        box.msg = msg;
        box.defVal = defVal;
        return box;
    }

    public static BoxedCode box_scriptConfirm(ScripterCallback sc, Viewport vp, String msg) {
        BoxedCallback box = new BoxedCallback();
        box.id = 8;
        box.scripterCallback = sc;
        box.vp = vp;
        box.msg = msg;
        return box;
    }

    public static BoxedCode box_scriptAlert(ScripterCallback sc, Viewport vp, String msg) {
        BoxedCallback box = new BoxedCallback();
        box.id = 9;
        box.scripterCallback = sc;
        box.vp = vp;
        box.msg = msg;
        return box;
    }

    public static BoxedCode box_scriptPrint(ScripterCallback sc, Viewport vp) {
        BoxedCallback box = new BoxedCallback();
        box.id = 10;
        box.scripterCallback = sc;
        box.vp = vp;
        return box;
    }

    private static final class BoxedCallback
    implements BoxedCode {
        private static final int Id_createTopLevelContainer = 1;
        private static final int Id_disposeTopLevelContainer = 2;
        private static final int Id_getMaxScriptRunningTime = 3;
        private static final int Id_interruptLongRunningScript = 4;
        private static final int Id_allowScriptClose = 5;
        private static final int Id_reportScriptError = 6;
        private static final int Id_scriptPrompt = 7;
        private static final int Id_scriptConfirm = 8;
        private static final int Id_scriptAlert = 9;
        private static final int Id_scriptPrint = 10;
        int id;
        ViewportCallback viewportCallback;
        ScripterCallback scripterCallback;
        Viewport vp;
        long scriptRunTime;
        boolean openedByScript;
        boolean justWarning;
        String errorMessage;
        String url;
        int lineNumber;
        String lineSource;
        int lineOffset;
        String msg;
        String defVal;

        private BoxedCallback() {
        }

        public Object run() {
            switch (this.id) {
                case 1: {
                    return this.viewportCallback.createTopLevelContainer(this.vp);
                }
                case 2: {
                    this.viewportCallback.disposeTopLevelContainer(this.vp);
                    return null;
                }
                case 3: {
                    return new Long(this.scripterCallback.getMaxScriptRunningTime());
                }
                case 4: {
                    return this.scripterCallback.interruptLongRunningScript(this.vp, this.scriptRunTime) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 5: {
                    return this.scripterCallback.allowScriptClose(this.vp, this.openedByScript) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 6: {
                    this.scripterCallback.reportScriptError(this.vp, this.justWarning, this.errorMessage, this.url, this.lineNumber, this.lineSource, this.lineOffset);
                    return null;
                }
                case 7: {
                    return this.scripterCallback.scriptPrompt(this.vp, this.msg, this.defVal);
                }
                case 8: {
                    return this.scripterCallback.scriptConfirm(this.vp, this.msg) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 9: {
                    this.scripterCallback.scriptAlert(this.vp, this.msg);
                    return null;
                }
                case 10: {
                    this.scripterCallback.scriptPrint(this.vp);
                    return null;
                }
            }
            Debug.bug();
            return null;
        }
    }

    static class OldCallbackWrap
    extends CallbackAdapter {
        StormCallback oldCallback;

        OldCallbackWrap(StormCallback oldCallback_arg) {
            this.oldCallback = oldCallback_arg;
        }

        public void init(StormBase base) {
            this.oldCallback.init(base);
        }

        public Container createTopLevelContainer(Viewport viewport) {
            return this.oldCallback.createTopLevelContainer(viewport);
        }

        public void disposeTopLevelContainer(Viewport viewport) {
            this.oldCallback.disposeTopLevelContainer(viewport);
        }

        public String scriptPrompt(Viewport vp, String msg, String defVal) {
            return this.oldCallback.prompt(vp, msg, defVal);
        }

        public boolean scriptConfirm(Viewport vp, String msg) {
            return this.oldCallback.confirm(vp, msg);
        }

        public void scriptAlert(Viewport vp, String msg) {
            this.oldCallback.message(vp, msg);
        }
    }
}

